/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateVpcEndpointRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateVpcEndpointRequest> {
    private final String clientToken;
    private final String policyDocument;
    private final List<String> routeTableIds;
    private final String serviceName;
    private final String vpcId;

    private CreateVpcEndpointRequest(BuilderImpl builder) {
        this.clientToken = builder.clientToken;
        this.policyDocument = builder.policyDocument;
        this.routeTableIds = builder.routeTableIds;
        this.serviceName = builder.serviceName;
        this.vpcId = builder.vpcId;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public String policyDocument() {
        return this.policyDocument;
    }

    public List<String> routeTableIds() {
        return this.routeTableIds;
    }

    public String serviceName() {
        return this.serviceName;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.clientToken() == null ? 0 : this.clientToken().hashCode());
        hashCode = 31 * hashCode + (this.policyDocument() == null ? 0 : this.policyDocument().hashCode());
        hashCode = 31 * hashCode + (this.routeTableIds() == null ? 0 : this.routeTableIds().hashCode());
        hashCode = 31 * hashCode + (this.serviceName() == null ? 0 : this.serviceName().hashCode());
        hashCode = 31 * hashCode + (this.vpcId() == null ? 0 : this.vpcId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpcEndpointRequest)) {
            return false;
        }
        CreateVpcEndpointRequest other = (CreateVpcEndpointRequest)((Object)obj);
        if (other.clientToken() == null ^ this.clientToken() == null) {
            return false;
        }
        if (other.clientToken() != null && !other.clientToken().equals(this.clientToken())) {
            return false;
        }
        if (other.policyDocument() == null ^ this.policyDocument() == null) {
            return false;
        }
        if (other.policyDocument() != null && !other.policyDocument().equals(this.policyDocument())) {
            return false;
        }
        if (other.routeTableIds() == null ^ this.routeTableIds() == null) {
            return false;
        }
        if (other.routeTableIds() != null && !other.routeTableIds().equals(this.routeTableIds())) {
            return false;
        }
        if (other.serviceName() == null ^ this.serviceName() == null) {
            return false;
        }
        if (other.serviceName() != null && !other.serviceName().equals(this.serviceName())) {
            return false;
        }
        if (other.vpcId() == null ^ this.vpcId() == null) {
            return false;
        }
        return other.vpcId() == null || other.vpcId().equals(this.vpcId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clientToken() != null) {
            sb.append("ClientToken: ").append(this.clientToken()).append(",");
        }
        if (this.policyDocument() != null) {
            sb.append("PolicyDocument: ").append(this.policyDocument()).append(",");
        }
        if (this.routeTableIds() != null) {
            sb.append("RouteTableIds: ").append(this.routeTableIds()).append(",");
        }
        if (this.serviceName() != null) {
            sb.append("ServiceName: ").append(this.serviceName()).append(",");
        }
        if (this.vpcId() != null) {
            sb.append("VpcId: ").append(this.vpcId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String clientToken;
        private String policyDocument;
        private List<String> routeTableIds = new SdkInternalList();
        private String serviceName;
        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpcEndpointRequest model) {
            this.setClientToken(model.clientToken);
            this.setPolicyDocument(model.policyDocument);
            this.setRouteTableIds(model.routeTableIds);
            this.setServiceName(model.serviceName);
            this.setVpcId(model.vpcId);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getPolicyDocument() {
            return this.policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        public final Collection<String> getRouteTableIds() {
            return this.routeTableIds;
        }

        @Override
        public final Builder routeTableIds(Collection<String> routeTableIds) {
            this.routeTableIds = ValueStringListCopier.copy(routeTableIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeTableIds(String ... routeTableIds) {
            if (this.routeTableIds == null) {
                this.routeTableIds = new SdkInternalList(routeTableIds.length);
            }
            for (String e : routeTableIds) {
                this.routeTableIds.add(e);
            }
            return this;
        }

        public final void setRouteTableIds(Collection<String> routeTableIds) {
            this.routeTableIds = ValueStringListCopier.copy(routeTableIds);
        }

        @SafeVarargs
        public final void setRouteTableIds(String ... routeTableIds) {
            if (this.routeTableIds == null) {
                this.routeTableIds = new SdkInternalList(routeTableIds.length);
            }
            for (String e : routeTableIds) {
                this.routeTableIds.add(e);
            }
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public CreateVpcEndpointRequest build() {
            return new CreateVpcEndpointRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateVpcEndpointRequest> {
        public Builder clientToken(String var1);

        public Builder policyDocument(String var1);

        public Builder routeTableIds(Collection<String> var1);

        public Builder routeTableIds(String ... var1);

        public Builder serviceName(String var1);

        public Builder vpcId(String var1);
    }
}

