/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Date;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ClientData
implements ToCopyableBuilder<Builder, ClientData> {
    private final String comment;
    private final Date uploadEnd;
    private final Double uploadSize;
    private final Date uploadStart;

    private ClientData(BuilderImpl builder) {
        this.comment = builder.comment;
        this.uploadEnd = builder.uploadEnd;
        this.uploadSize = builder.uploadSize;
        this.uploadStart = builder.uploadStart;
    }

    public String comment() {
        return this.comment;
    }

    public Date uploadEnd() {
        return this.uploadEnd;
    }

    public Double uploadSize() {
        return this.uploadSize;
    }

    public Date uploadStart() {
        return this.uploadStart;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.comment() == null ? 0 : this.comment().hashCode());
        hashCode = 31 * hashCode + (this.uploadEnd() == null ? 0 : this.uploadEnd().hashCode());
        hashCode = 31 * hashCode + (this.uploadSize() == null ? 0 : this.uploadSize().hashCode());
        hashCode = 31 * hashCode + (this.uploadStart() == null ? 0 : this.uploadStart().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClientData)) {
            return false;
        }
        ClientData other = (ClientData)obj;
        if (other.comment() == null ^ this.comment() == null) {
            return false;
        }
        if (other.comment() != null && !other.comment().equals(this.comment())) {
            return false;
        }
        if (other.uploadEnd() == null ^ this.uploadEnd() == null) {
            return false;
        }
        if (other.uploadEnd() != null && !other.uploadEnd().equals(this.uploadEnd())) {
            return false;
        }
        if (other.uploadSize() == null ^ this.uploadSize() == null) {
            return false;
        }
        if (other.uploadSize() != null && !other.uploadSize().equals(this.uploadSize())) {
            return false;
        }
        if (other.uploadStart() == null ^ this.uploadStart() == null) {
            return false;
        }
        return other.uploadStart() == null || other.uploadStart().equals(this.uploadStart());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.comment() != null) {
            sb.append("Comment: ").append(this.comment()).append(",");
        }
        if (this.uploadEnd() != null) {
            sb.append("UploadEnd: ").append(this.uploadEnd()).append(",");
        }
        if (this.uploadSize() != null) {
            sb.append("UploadSize: ").append(this.uploadSize()).append(",");
        }
        if (this.uploadStart() != null) {
            sb.append("UploadStart: ").append(this.uploadStart()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String comment;
        private Date uploadEnd;
        private Double uploadSize;
        private Date uploadStart;

        private BuilderImpl() {
        }

        private BuilderImpl(ClientData model) {
            this.setComment(model.comment);
            this.setUploadEnd(model.uploadEnd);
            this.setUploadSize(model.uploadSize);
            this.setUploadStart(model.uploadStart);
        }

        public final String getComment() {
            return this.comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        public final Date getUploadEnd() {
            return this.uploadEnd;
        }

        @Override
        public final Builder uploadEnd(Date uploadEnd) {
            this.uploadEnd = StandardMemberCopier.copy((Date)uploadEnd);
            return this;
        }

        public final void setUploadEnd(Date uploadEnd) {
            this.uploadEnd = StandardMemberCopier.copy((Date)uploadEnd);
        }

        public final Double getUploadSize() {
            return this.uploadSize;
        }

        @Override
        public final Builder uploadSize(Double uploadSize) {
            this.uploadSize = uploadSize;
            return this;
        }

        public final void setUploadSize(Double uploadSize) {
            this.uploadSize = uploadSize;
        }

        public final Date getUploadStart() {
            return this.uploadStart;
        }

        @Override
        public final Builder uploadStart(Date uploadStart) {
            this.uploadStart = StandardMemberCopier.copy((Date)uploadStart);
            return this;
        }

        public final void setUploadStart(Date uploadStart) {
            this.uploadStart = StandardMemberCopier.copy((Date)uploadStart);
        }

        public ClientData build() {
            return new ClientData(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ClientData> {
        public Builder comment(String var1);

        public Builder uploadEnd(Date var1);

        public Builder uploadSize(Double var1);

        public Builder uploadStart(Date var1);
    }
}

