/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ec2.model.PrivateIpAddressStringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AssignPrivateIpAddressesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, AssignPrivateIpAddressesRequest> {
    private final Boolean allowReassignment;
    private final String networkInterfaceId;
    private final List<String> privateIpAddresses;
    private final Integer secondaryPrivateIpAddressCount;

    private AssignPrivateIpAddressesRequest(BuilderImpl builder) {
        this.allowReassignment = builder.allowReassignment;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.privateIpAddresses = builder.privateIpAddresses;
        this.secondaryPrivateIpAddressCount = builder.secondaryPrivateIpAddressCount;
    }

    public Boolean allowReassignment() {
        return this.allowReassignment;
    }

    public String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public List<String> privateIpAddresses() {
        return this.privateIpAddresses;
    }

    public Integer secondaryPrivateIpAddressCount() {
        return this.secondaryPrivateIpAddressCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.allowReassignment() == null ? 0 : this.allowReassignment().hashCode());
        hashCode = 31 * hashCode + (this.networkInterfaceId() == null ? 0 : this.networkInterfaceId().hashCode());
        hashCode = 31 * hashCode + (this.privateIpAddresses() == null ? 0 : this.privateIpAddresses().hashCode());
        hashCode = 31 * hashCode + (this.secondaryPrivateIpAddressCount() == null ? 0 : this.secondaryPrivateIpAddressCount().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssignPrivateIpAddressesRequest)) {
            return false;
        }
        AssignPrivateIpAddressesRequest other = (AssignPrivateIpAddressesRequest)((Object)obj);
        if (other.allowReassignment() == null ^ this.allowReassignment() == null) {
            return false;
        }
        if (other.allowReassignment() != null && !other.allowReassignment().equals(this.allowReassignment())) {
            return false;
        }
        if (other.networkInterfaceId() == null ^ this.networkInterfaceId() == null) {
            return false;
        }
        if (other.networkInterfaceId() != null && !other.networkInterfaceId().equals(this.networkInterfaceId())) {
            return false;
        }
        if (other.privateIpAddresses() == null ^ this.privateIpAddresses() == null) {
            return false;
        }
        if (other.privateIpAddresses() != null && !other.privateIpAddresses().equals(this.privateIpAddresses())) {
            return false;
        }
        if (other.secondaryPrivateIpAddressCount() == null ^ this.secondaryPrivateIpAddressCount() == null) {
            return false;
        }
        return other.secondaryPrivateIpAddressCount() == null || other.secondaryPrivateIpAddressCount().equals(this.secondaryPrivateIpAddressCount());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.allowReassignment() != null) {
            sb.append("AllowReassignment: ").append(this.allowReassignment()).append(",");
        }
        if (this.networkInterfaceId() != null) {
            sb.append("NetworkInterfaceId: ").append(this.networkInterfaceId()).append(",");
        }
        if (this.privateIpAddresses() != null) {
            sb.append("PrivateIpAddresses: ").append(this.privateIpAddresses()).append(",");
        }
        if (this.secondaryPrivateIpAddressCount() != null) {
            sb.append("SecondaryPrivateIpAddressCount: ").append(this.secondaryPrivateIpAddressCount()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Boolean allowReassignment;
        private String networkInterfaceId;
        private List<String> privateIpAddresses = new SdkInternalList();
        private Integer secondaryPrivateIpAddressCount;

        private BuilderImpl() {
        }

        private BuilderImpl(AssignPrivateIpAddressesRequest model) {
            this.setAllowReassignment(model.allowReassignment);
            this.setNetworkInterfaceId(model.networkInterfaceId);
            this.setPrivateIpAddresses(model.privateIpAddresses);
            this.setSecondaryPrivateIpAddressCount(model.secondaryPrivateIpAddressCount);
        }

        public final Boolean getAllowReassignment() {
            return this.allowReassignment;
        }

        @Override
        public final Builder allowReassignment(Boolean allowReassignment) {
            this.allowReassignment = allowReassignment;
            return this;
        }

        public final void setAllowReassignment(Boolean allowReassignment) {
            this.allowReassignment = allowReassignment;
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final Collection<String> getPrivateIpAddresses() {
            return this.privateIpAddresses;
        }

        @Override
        public final Builder privateIpAddresses(Collection<String> privateIpAddresses) {
            this.privateIpAddresses = PrivateIpAddressStringListCopier.copy(privateIpAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddresses(String ... privateIpAddresses) {
            if (this.privateIpAddresses == null) {
                this.privateIpAddresses = new SdkInternalList(privateIpAddresses.length);
            }
            for (String e : privateIpAddresses) {
                this.privateIpAddresses.add(e);
            }
            return this;
        }

        public final void setPrivateIpAddresses(Collection<String> privateIpAddresses) {
            this.privateIpAddresses = PrivateIpAddressStringListCopier.copy(privateIpAddresses);
        }

        @SafeVarargs
        public final void setPrivateIpAddresses(String ... privateIpAddresses) {
            if (this.privateIpAddresses == null) {
                this.privateIpAddresses = new SdkInternalList(privateIpAddresses.length);
            }
            for (String e : privateIpAddresses) {
                this.privateIpAddresses.add(e);
            }
        }

        public final Integer getSecondaryPrivateIpAddressCount() {
            return this.secondaryPrivateIpAddressCount;
        }

        @Override
        public final Builder secondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount) {
            this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
            return this;
        }

        public final void setSecondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount) {
            this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
        }

        public AssignPrivateIpAddressesRequest build() {
            return new AssignPrivateIpAddressesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AssignPrivateIpAddressesRequest> {
        public Builder allowReassignment(Boolean var1);

        public Builder networkInterfaceId(String var1);

        public Builder privateIpAddresses(Collection<String> var1);

        public Builder privateIpAddresses(String ... var1);

        public Builder secondaryPrivateIpAddressCount(Integer var1);
    }
}

