/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ebs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A block of data in an Amazon Elastic Block Store snapshot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Block implements SdkPojo, Serializable, ToCopyableBuilder<Block.Builder, Block> {
    private static final SdkField<Integer> BLOCK_INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BlockIndex").getter(getter(Block::blockIndex)).setter(setter(Builder::blockIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockIndex").build()).build();

    private static final SdkField<String> BLOCK_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BlockToken").getter(getter(Block::blockToken)).setter(setter(Builder::blockToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLOCK_INDEX_FIELD,
            BLOCK_TOKEN_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer blockIndex;

    private final String blockToken;

    private Block(BuilderImpl builder) {
        this.blockIndex = builder.blockIndex;
        this.blockToken = builder.blockToken;
    }

    /**
     * <p>
     * The block index.
     * </p>
     * 
     * @return The block index.
     */
    public final Integer blockIndex() {
        return blockIndex;
    }

    /**
     * <p>
     * The block token for the block index.
     * </p>
     * 
     * @return The block token for the block index.
     */
    public final String blockToken() {
        return blockToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(blockIndex());
        hashCode = 31 * hashCode + Objects.hashCode(blockToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Block)) {
            return false;
        }
        Block other = (Block) obj;
        return Objects.equals(blockIndex(), other.blockIndex()) && Objects.equals(blockToken(), other.blockToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Block").add("BlockIndex", blockIndex()).add("BlockToken", blockToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BlockIndex":
            return Optional.ofNullable(clazz.cast(blockIndex()));
        case "BlockToken":
            return Optional.ofNullable(clazz.cast(blockToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Block, T> g) {
        return obj -> g.apply((Block) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Block> {
        /**
         * <p>
         * The block index.
         * </p>
         * 
         * @param blockIndex
         *        The block index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockIndex(Integer blockIndex);

        /**
         * <p>
         * The block token for the block index.
         * </p>
         * 
         * @param blockToken
         *        The block token for the block index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockToken(String blockToken);
    }

    static final class BuilderImpl implements Builder {
        private Integer blockIndex;

        private String blockToken;

        private BuilderImpl() {
        }

        private BuilderImpl(Block model) {
            blockIndex(model.blockIndex);
            blockToken(model.blockToken);
        }

        public final Integer getBlockIndex() {
            return blockIndex;
        }

        @Override
        public final Builder blockIndex(Integer blockIndex) {
            this.blockIndex = blockIndex;
            return this;
        }

        public final void setBlockIndex(Integer blockIndex) {
            this.blockIndex = blockIndex;
        }

        public final String getBlockToken() {
            return blockToken;
        }

        @Override
        public final Builder blockToken(String blockToken) {
            this.blockToken = blockToken;
            return this;
        }

        public final void setBlockToken(String blockToken) {
            this.blockToken = blockToken;
        }

        @Override
        public Block build() {
            return new Block(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
