/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ebs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Block
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Block> {
    private static final SdkField<Integer> BLOCK_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Block.getter(Block::blockIndex)).setter(Block.setter(Builder::blockIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockIndex").build()}).build();
    private static final SdkField<String> BLOCK_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Block.getter(Block::blockToken)).setter(Block.setter(Builder::blockToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLOCK_INDEX_FIELD, BLOCK_TOKEN_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer blockIndex;
    private final String blockToken;

    private Block(BuilderImpl builder) {
        this.blockIndex = builder.blockIndex;
        this.blockToken = builder.blockToken;
    }

    public Integer blockIndex() {
        return this.blockIndex;
    }

    public String blockToken() {
        return this.blockToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.blockIndex());
        hashCode = 31 * hashCode + Objects.hashCode(this.blockToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Block)) {
            return false;
        }
        Block other = (Block)obj;
        return Objects.equals(this.blockIndex(), other.blockIndex()) && Objects.equals(this.blockToken(), other.blockToken());
    }

    public String toString() {
        return ToString.builder((String)"Block").add("BlockIndex", (Object)this.blockIndex()).add("BlockToken", (Object)this.blockToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BlockIndex": {
                return Optional.ofNullable(clazz.cast(this.blockIndex()));
            }
            case "BlockToken": {
                return Optional.ofNullable(clazz.cast(this.blockToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Block, T> g) {
        return obj -> g.apply((Block)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer blockIndex;
        private String blockToken;

        private BuilderImpl() {
        }

        private BuilderImpl(Block model) {
            this.blockIndex(model.blockIndex);
            this.blockToken(model.blockToken);
        }

        public final Integer getBlockIndex() {
            return this.blockIndex;
        }

        @Override
        public final Builder blockIndex(Integer blockIndex) {
            this.blockIndex = blockIndex;
            return this;
        }

        public final void setBlockIndex(Integer blockIndex) {
            this.blockIndex = blockIndex;
        }

        public final String getBlockToken() {
            return this.blockToken;
        }

        @Override
        public final Builder blockToken(String blockToken) {
            this.blockToken = blockToken;
            return this;
        }

        public final void setBlockToken(String blockToken) {
            this.blockToken = blockToken;
        }

        public Block build() {
            return new Block(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Block> {
        public Builder blockIndex(Integer var1);

        public Builder blockToken(String var1);
    }
}

