/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaCopier;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import software.amazon.awssdk.services.dynamodb.model.Projection;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GlobalSecondaryIndex
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GlobalSecondaryIndex> {
    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GlobalSecondaryIndex.getter(GlobalSecondaryIndex::indexName)).setter(GlobalSecondaryIndex.setter(Builder::indexName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexName").build()}).build();
    private static final SdkField<List<KeySchemaElement>> KEY_SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GlobalSecondaryIndex.getter(GlobalSecondaryIndex::keySchema)).setter(GlobalSecondaryIndex.setter(Builder::keySchema)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeySchema").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KeySchemaElement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Projection> PROJECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(GlobalSecondaryIndex.getter(GlobalSecondaryIndex::projection)).setter(GlobalSecondaryIndex.setter(Builder::projection)).constructor(Projection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Projection").build()}).build();
    private static final SdkField<ProvisionedThroughput> PROVISIONED_THROUGHPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(GlobalSecondaryIndex.getter(GlobalSecondaryIndex::provisionedThroughput)).setter(GlobalSecondaryIndex.setter(Builder::provisionedThroughput)).constructor(ProvisionedThroughput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedThroughput").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_NAME_FIELD, KEY_SCHEMA_FIELD, PROJECTION_FIELD, PROVISIONED_THROUGHPUT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String indexName;
    private final List<KeySchemaElement> keySchema;
    private final Projection projection;
    private final ProvisionedThroughput provisionedThroughput;

    private GlobalSecondaryIndex(BuilderImpl builder) {
        this.indexName = builder.indexName;
        this.keySchema = builder.keySchema;
        this.projection = builder.projection;
        this.provisionedThroughput = builder.provisionedThroughput;
    }

    public String indexName() {
        return this.indexName;
    }

    public List<KeySchemaElement> keySchema() {
        return this.keySchema;
    }

    public Projection projection() {
        return this.projection;
    }

    public ProvisionedThroughput provisionedThroughput() {
        return this.provisionedThroughput;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.indexName());
        hashCode = 31 * hashCode + Objects.hashCode(this.keySchema());
        hashCode = 31 * hashCode + Objects.hashCode(this.projection());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedThroughput());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlobalSecondaryIndex)) {
            return false;
        }
        GlobalSecondaryIndex other = (GlobalSecondaryIndex)obj;
        return Objects.equals(this.indexName(), other.indexName()) && Objects.equals(this.keySchema(), other.keySchema()) && Objects.equals(this.projection(), other.projection()) && Objects.equals(this.provisionedThroughput(), other.provisionedThroughput());
    }

    public String toString() {
        return ToString.builder((String)"GlobalSecondaryIndex").add("IndexName", (Object)this.indexName()).add("KeySchema", this.keySchema()).add("Projection", (Object)this.projection()).add("ProvisionedThroughput", (Object)this.provisionedThroughput()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IndexName": {
                return Optional.ofNullable(clazz.cast(this.indexName()));
            }
            case "KeySchema": {
                return Optional.ofNullable(clazz.cast(this.keySchema()));
            }
            case "Projection": {
                return Optional.ofNullable(clazz.cast(this.projection()));
            }
            case "ProvisionedThroughput": {
                return Optional.ofNullable(clazz.cast(this.provisionedThroughput()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GlobalSecondaryIndex, T> g) {
        return obj -> g.apply((GlobalSecondaryIndex)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String indexName;
        private List<KeySchemaElement> keySchema = DefaultSdkAutoConstructList.getInstance();
        private Projection projection;
        private ProvisionedThroughput provisionedThroughput;

        private BuilderImpl() {
        }

        private BuilderImpl(GlobalSecondaryIndex model) {
            this.indexName(model.indexName);
            this.keySchema(model.keySchema);
            this.projection(model.projection);
            this.provisionedThroughput(model.provisionedThroughput);
        }

        public final String getIndexName() {
            return this.indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        public final Collection<KeySchemaElement.Builder> getKeySchema() {
            return this.keySchema != null ? (Collection)this.keySchema.stream().map(KeySchemaElement::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder keySchema(Collection<KeySchemaElement> keySchema) {
            this.keySchema = KeySchemaCopier.copy(keySchema);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keySchema(KeySchemaElement ... keySchema) {
            this.keySchema(Arrays.asList(keySchema));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keySchema(Consumer<KeySchemaElement.Builder> ... keySchema) {
            this.keySchema(Stream.of(keySchema).map(c -> (KeySchemaElement)((KeySchemaElement.Builder)KeySchemaElement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setKeySchema(Collection<KeySchemaElement.BuilderImpl> keySchema) {
            this.keySchema = KeySchemaCopier.copyFromBuilder(keySchema);
        }

        public final Projection.Builder getProjection() {
            return this.projection != null ? this.projection.toBuilder() : null;
        }

        @Override
        public final Builder projection(Projection projection) {
            this.projection = projection;
            return this;
        }

        public final void setProjection(Projection.BuilderImpl projection) {
            this.projection = projection != null ? projection.build() : null;
        }

        public final ProvisionedThroughput.Builder getProvisionedThroughput() {
            return this.provisionedThroughput != null ? this.provisionedThroughput.toBuilder() : null;
        }

        @Override
        public final Builder provisionedThroughput(ProvisionedThroughput provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput;
            return this;
        }

        public final void setProvisionedThroughput(ProvisionedThroughput.BuilderImpl provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput != null ? provisionedThroughput.build() : null;
        }

        public GlobalSecondaryIndex build() {
            return new GlobalSecondaryIndex(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GlobalSecondaryIndex> {
        public Builder indexName(String var1);

        public Builder keySchema(Collection<KeySchemaElement> var1);

        public Builder keySchema(KeySchemaElement ... var1);

        public Builder keySchema(Consumer<KeySchemaElement.Builder> ... var1);

        public Builder projection(Projection var1);

        default public Builder projection(Consumer<Projection.Builder> projection) {
            return this.projection((Projection)((Projection.Builder)Projection.builder().applyMutation(projection)).build());
        }

        public Builder provisionedThroughput(ProvisionedThroughput var1);

        default public Builder provisionedThroughput(Consumer<ProvisionedThroughput.Builder> provisionedThroughput) {
            return this.provisionedThroughput((ProvisionedThroughput)((ProvisionedThroughput.Builder)ProvisionedThroughput.builder().applyMutation(provisionedThroughput)).build());
        }
    }
}

