/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dynamodb.model.BackupStatus;
import software.amazon.awssdk.services.dynamodb.model.BackupType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BackupSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BackupSummary> {
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BackupSummary.getter(BackupSummary::tableName)).setter(BackupSummary.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()}).build();
    private static final SdkField<String> TABLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BackupSummary.getter(BackupSummary::tableId)).setter(BackupSummary.setter(Builder::tableId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableId").build()}).build();
    private static final SdkField<String> TABLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BackupSummary.getter(BackupSummary::tableArn)).setter(BackupSummary.setter(Builder::tableArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableArn").build()}).build();
    private static final SdkField<String> BACKUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BackupSummary.getter(BackupSummary::backupArn)).setter(BackupSummary.setter(Builder::backupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupArn").build()}).build();
    private static final SdkField<String> BACKUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BackupSummary.getter(BackupSummary::backupName)).setter(BackupSummary.setter(Builder::backupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupName").build()}).build();
    private static final SdkField<Instant> BACKUP_CREATION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(BackupSummary.getter(BackupSummary::backupCreationDateTime)).setter(BackupSummary.setter(Builder::backupCreationDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupCreationDateTime").build()}).build();
    private static final SdkField<Instant> BACKUP_EXPIRY_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(BackupSummary.getter(BackupSummary::backupExpiryDateTime)).setter(BackupSummary.setter(Builder::backupExpiryDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupExpiryDateTime").build()}).build();
    private static final SdkField<String> BACKUP_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BackupSummary.getter(BackupSummary::backupStatusAsString)).setter(BackupSummary.setter(Builder::backupStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupStatus").build()}).build();
    private static final SdkField<String> BACKUP_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BackupSummary.getter(BackupSummary::backupTypeAsString)).setter(BackupSummary.setter(Builder::backupType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupType").build()}).build();
    private static final SdkField<Long> BACKUP_SIZE_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(BackupSummary.getter(BackupSummary::backupSizeBytes)).setter(BackupSummary.setter(Builder::backupSizeBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupSizeBytes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_NAME_FIELD, TABLE_ID_FIELD, TABLE_ARN_FIELD, BACKUP_ARN_FIELD, BACKUP_NAME_FIELD, BACKUP_CREATION_DATE_TIME_FIELD, BACKUP_EXPIRY_DATE_TIME_FIELD, BACKUP_STATUS_FIELD, BACKUP_TYPE_FIELD, BACKUP_SIZE_BYTES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String tableName;
    private final String tableId;
    private final String tableArn;
    private final String backupArn;
    private final String backupName;
    private final Instant backupCreationDateTime;
    private final Instant backupExpiryDateTime;
    private final String backupStatus;
    private final String backupType;
    private final Long backupSizeBytes;

    private BackupSummary(BuilderImpl builder) {
        this.tableName = builder.tableName;
        this.tableId = builder.tableId;
        this.tableArn = builder.tableArn;
        this.backupArn = builder.backupArn;
        this.backupName = builder.backupName;
        this.backupCreationDateTime = builder.backupCreationDateTime;
        this.backupExpiryDateTime = builder.backupExpiryDateTime;
        this.backupStatus = builder.backupStatus;
        this.backupType = builder.backupType;
        this.backupSizeBytes = builder.backupSizeBytes;
    }

    public String tableName() {
        return this.tableName;
    }

    public String tableId() {
        return this.tableId;
    }

    public String tableArn() {
        return this.tableArn;
    }

    public String backupArn() {
        return this.backupArn;
    }

    public String backupName() {
        return this.backupName;
    }

    public Instant backupCreationDateTime() {
        return this.backupCreationDateTime;
    }

    public Instant backupExpiryDateTime() {
        return this.backupExpiryDateTime;
    }

    public BackupStatus backupStatus() {
        return BackupStatus.fromValue(this.backupStatus);
    }

    public String backupStatusAsString() {
        return this.backupStatus;
    }

    public BackupType backupType() {
        return BackupType.fromValue(this.backupType);
    }

    public String backupTypeAsString() {
        return this.backupType;
    }

    public Long backupSizeBytes() {
        return this.backupSizeBytes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableId());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupCreationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupExpiryDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupSizeBytes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BackupSummary)) {
            return false;
        }
        BackupSummary other = (BackupSummary)obj;
        return Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.tableId(), other.tableId()) && Objects.equals(this.tableArn(), other.tableArn()) && Objects.equals(this.backupArn(), other.backupArn()) && Objects.equals(this.backupName(), other.backupName()) && Objects.equals(this.backupCreationDateTime(), other.backupCreationDateTime()) && Objects.equals(this.backupExpiryDateTime(), other.backupExpiryDateTime()) && Objects.equals(this.backupStatusAsString(), other.backupStatusAsString()) && Objects.equals(this.backupTypeAsString(), other.backupTypeAsString()) && Objects.equals(this.backupSizeBytes(), other.backupSizeBytes());
    }

    public String toString() {
        return ToString.builder((String)"BackupSummary").add("TableName", (Object)this.tableName()).add("TableId", (Object)this.tableId()).add("TableArn", (Object)this.tableArn()).add("BackupArn", (Object)this.backupArn()).add("BackupName", (Object)this.backupName()).add("BackupCreationDateTime", (Object)this.backupCreationDateTime()).add("BackupExpiryDateTime", (Object)this.backupExpiryDateTime()).add("BackupStatus", (Object)this.backupStatusAsString()).add("BackupType", (Object)this.backupTypeAsString()).add("BackupSizeBytes", (Object)this.backupSizeBytes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "TableId": {
                return Optional.ofNullable(clazz.cast(this.tableId()));
            }
            case "TableArn": {
                return Optional.ofNullable(clazz.cast(this.tableArn()));
            }
            case "BackupArn": {
                return Optional.ofNullable(clazz.cast(this.backupArn()));
            }
            case "BackupName": {
                return Optional.ofNullable(clazz.cast(this.backupName()));
            }
            case "BackupCreationDateTime": {
                return Optional.ofNullable(clazz.cast(this.backupCreationDateTime()));
            }
            case "BackupExpiryDateTime": {
                return Optional.ofNullable(clazz.cast(this.backupExpiryDateTime()));
            }
            case "BackupStatus": {
                return Optional.ofNullable(clazz.cast(this.backupStatusAsString()));
            }
            case "BackupType": {
                return Optional.ofNullable(clazz.cast(this.backupTypeAsString()));
            }
            case "BackupSizeBytes": {
                return Optional.ofNullable(clazz.cast(this.backupSizeBytes()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BackupSummary, T> g) {
        return obj -> g.apply((BackupSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String tableName;
        private String tableId;
        private String tableArn;
        private String backupArn;
        private String backupName;
        private Instant backupCreationDateTime;
        private Instant backupExpiryDateTime;
        private String backupStatus;
        private String backupType;
        private Long backupSizeBytes;

        private BuilderImpl() {
        }

        private BuilderImpl(BackupSummary model) {
            this.tableName(model.tableName);
            this.tableId(model.tableId);
            this.tableArn(model.tableArn);
            this.backupArn(model.backupArn);
            this.backupName(model.backupName);
            this.backupCreationDateTime(model.backupCreationDateTime);
            this.backupExpiryDateTime(model.backupExpiryDateTime);
            this.backupStatus(model.backupStatus);
            this.backupType(model.backupType);
            this.backupSizeBytes(model.backupSizeBytes);
        }

        public final String getTableName() {
            return this.tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final String getTableId() {
            return this.tableId;
        }

        @Override
        public final Builder tableId(String tableId) {
            this.tableId = tableId;
            return this;
        }

        public final void setTableId(String tableId) {
            this.tableId = tableId;
        }

        public final String getTableArn() {
            return this.tableArn;
        }

        @Override
        public final Builder tableArn(String tableArn) {
            this.tableArn = tableArn;
            return this;
        }

        public final void setTableArn(String tableArn) {
            this.tableArn = tableArn;
        }

        public final String getBackupArn() {
            return this.backupArn;
        }

        @Override
        public final Builder backupArn(String backupArn) {
            this.backupArn = backupArn;
            return this;
        }

        public final void setBackupArn(String backupArn) {
            this.backupArn = backupArn;
        }

        public final String getBackupName() {
            return this.backupName;
        }

        @Override
        public final Builder backupName(String backupName) {
            this.backupName = backupName;
            return this;
        }

        public final void setBackupName(String backupName) {
            this.backupName = backupName;
        }

        public final Instant getBackupCreationDateTime() {
            return this.backupCreationDateTime;
        }

        @Override
        public final Builder backupCreationDateTime(Instant backupCreationDateTime) {
            this.backupCreationDateTime = backupCreationDateTime;
            return this;
        }

        public final void setBackupCreationDateTime(Instant backupCreationDateTime) {
            this.backupCreationDateTime = backupCreationDateTime;
        }

        public final Instant getBackupExpiryDateTime() {
            return this.backupExpiryDateTime;
        }

        @Override
        public final Builder backupExpiryDateTime(Instant backupExpiryDateTime) {
            this.backupExpiryDateTime = backupExpiryDateTime;
            return this;
        }

        public final void setBackupExpiryDateTime(Instant backupExpiryDateTime) {
            this.backupExpiryDateTime = backupExpiryDateTime;
        }

        public final String getBackupStatusAsString() {
            return this.backupStatus;
        }

        @Override
        public final Builder backupStatus(String backupStatus) {
            this.backupStatus = backupStatus;
            return this;
        }

        @Override
        public final Builder backupStatus(BackupStatus backupStatus) {
            this.backupStatus(backupStatus.toString());
            return this;
        }

        public final void setBackupStatus(String backupStatus) {
            this.backupStatus = backupStatus;
        }

        public final String getBackupTypeAsString() {
            return this.backupType;
        }

        @Override
        public final Builder backupType(String backupType) {
            this.backupType = backupType;
            return this;
        }

        @Override
        public final Builder backupType(BackupType backupType) {
            this.backupType(backupType.toString());
            return this;
        }

        public final void setBackupType(String backupType) {
            this.backupType = backupType;
        }

        public final Long getBackupSizeBytes() {
            return this.backupSizeBytes;
        }

        @Override
        public final Builder backupSizeBytes(Long backupSizeBytes) {
            this.backupSizeBytes = backupSizeBytes;
            return this;
        }

        public final void setBackupSizeBytes(Long backupSizeBytes) {
            this.backupSizeBytes = backupSizeBytes;
        }

        public BackupSummary build() {
            return new BackupSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BackupSummary> {
        public Builder tableName(String var1);

        public Builder tableId(String var1);

        public Builder tableArn(String var1);

        public Builder backupArn(String var1);

        public Builder backupName(String var1);

        public Builder backupCreationDateTime(Instant var1);

        public Builder backupExpiryDateTime(Instant var1);

        public Builder backupStatus(String var1);

        public Builder backupStatus(BackupStatus var1);

        public Builder backupType(String var1);

        public Builder backupType(BackupType var1);

        public Builder backupSizeBytes(Long var1);
    }
}

