/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb;

import java.time.Duration;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.retry.AwsRetryPolicy;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.internal.retry.RetryPolicyAdapter;
import software.amazon.awssdk.core.internal.retry.SdkDefaultRetrySetting;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.retry.RetryPolicy;
import software.amazon.awssdk.core.retry.backoff.FullJitterBackoffStrategy;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.retries.api.RetryStrategy;

@SdkInternalApi
final class DynamoDbRetryPolicy {
    private static final int MAX_ERROR_RETRY = 8;
    private static final int MAX_ATTEMPTS = 9;
    private static final Duration BASE_DELAY = Duration.ofMillis(25L);
    private static final software.amazon.awssdk.core.retry.backoff.BackoffStrategy BACKOFF_STRATEGY = FullJitterBackoffStrategy.builder().baseDelay(BASE_DELAY).maxBackoffTime(SdkDefaultRetrySetting.MAX_BACKOFF).build();

    private DynamoDbRetryPolicy() {
    }

    @Deprecated
    public static RetryPolicy resolveRetryPolicy(SdkClientConfiguration config) {
        RetryPolicy configuredRetryPolicy = (RetryPolicy)config.option((ClientOption)SdkClientOption.RETRY_POLICY);
        if (configuredRetryPolicy != null) {
            return configuredRetryPolicy;
        }
        RetryMode retryMode = DynamoDbRetryPolicy.resolveRetryMode(config);
        return DynamoDbRetryPolicy.retryPolicyFor(retryMode);
    }

    public static RetryStrategy resolveRetryStrategy(SdkClientConfiguration config) {
        RetryStrategy configuredRetryStrategy = (RetryStrategy)config.option((ClientOption)SdkClientOption.RETRY_STRATEGY);
        if (configuredRetryStrategy != null) {
            return configuredRetryStrategy;
        }
        RetryMode retryMode = DynamoDbRetryPolicy.resolveRetryMode(config);
        if (retryMode == RetryMode.ADAPTIVE) {
            return RetryPolicyAdapter.builder().retryPolicy(DynamoDbRetryPolicy.retryPolicyFor(retryMode)).build();
        }
        return AwsRetryStrategy.forRetryMode((RetryMode)retryMode).toBuilder().maxAttempts(9).backoffStrategy(BackoffStrategy.exponentialDelay((Duration)BASE_DELAY, (Duration)SdkDefaultRetrySetting.MAX_BACKOFF)).build();
    }

    private static RetryPolicy retryPolicyFor(RetryMode retryMode) {
        return AwsRetryPolicy.forRetryMode((RetryMode)retryMode).toBuilder().additionalRetryConditionsAllowed(false).numRetries(Integer.valueOf(8)).backoffStrategy(BACKOFF_STRATEGY).build();
    }

    private static RetryMode resolveRetryMode(SdkClientConfiguration config) {
        return RetryMode.resolver().profileFile((Supplier)config.option((ClientOption)SdkClientOption.PROFILE_FILE_SUPPLIER)).profileName((String)config.option((ClientOption)SdkClientOption.PROFILE_NAME)).defaultRetryMode((RetryMode)config.option((ClientOption)SdkClientOption.DEFAULT_RETRY_MODE)).resolve();
    }
}

