/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <fullname>Amazon DynamoDB</fullname>
 * <p>
 * Amazon DynamoDB is a fully managed NoSQL database service that provides fast and predictable performance with
 * seamless scalability. DynamoDB lets you offload the administrative burdens of operating and scaling a distributed
 * database, so that you don't have to worry about hardware provisioning, setup and configuration, replication, software
 * patching, or cluster scaling.
 * </p>
 * <p>
 * With DynamoDB, you can create database tables that can store and retrieve any amount of data, and serve any level of
 * request traffic. You can scale up or scale down your tables' throughput capacity without downtime or performance
 * degradation, and use the Amazon Web Services Management Console to monitor resource utilization and performance
 * metrics.
 * </p>
 * <p>
 * DynamoDB automatically spreads the data and traffic for your tables over a sufficient number of servers to handle
 * your throughput and storage requirements, while maintaining consistent and fast performance. All of your data is
 * stored on solid state disks (SSDs) and automatically replicated across multiple Availability Zones in an Amazon Web
 * Services Region, providing built-in high availability and data durability.
 * </p>
 *
 * <h2>Code Examples</h2>
 * <p>
 * For code examples demonstrating how to use this service with the AWS SDK for Java v2, see:
 * </p>
 * <h3>Getting Started</h3>
 * <ul>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_Hello_section.html"
 * target="_top">Hello DynamoDB</a></li>
 * </ul>
 * <h3>Basics</h3>
 * <ul>
 * <li><a href=
 * "https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_Scenario_GettingStartedMovies_section.html"
 * target="_top">Learn the basics of DynamoDB with an AWS SDK</a></li>
 * </ul>
 * <h3>API Actions</h3>
 * <ul>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_CreateTable_section.html"
 * target="_top">Use CreateTable</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_BatchGetItem_section.html"
 * target="_top">Use BatchGetItem</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_DescribeTable_section.html"
 * target="_top">Use DescribeTable</a></li>
 * <li><a
 * href="https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_BatchWriteItem_section.html"
 * target="_top">Use BatchWriteItem</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_DeleteTable_section.html"
 * target="_top">Use DeleteTable</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_PutItem_section.html"
 * target="_top">Use PutItem</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_GetItem_section.html"
 * target="_top">Use GetItem</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_UpdateItem_section.html"
 * target="_top">Use UpdateItem</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_DeleteItem_section.html"
 * target="_top">Use DeleteItem</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_ListTables_section.html"
 * target="_top">Use ListTables</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_Query_section.html"
 * target="_top">Use Query</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_Scan_section.html"
 * target="_top">Use Scan</a></li>
 * <li><a
 * href="https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_UpdateTimeToLive_section.html"
 * target="_top">Use UpdateTimeToLive</a></li>
 * <li><a
 * href="https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_DescribeTimeToLive_section.html"
 * target="_top">Use DescribeTimeToLive</a></li>
 * </ul>
 * <h3>Scenarios</h3>
 * <ul>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_cross_PAM_section.html"
 * target="_top">Create a photo asset management application that lets users manage photos using labels</a></li>
 * <li><a
 * href="https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_cross_DynamoDBDataTracker_section.html"
 * target="_top">Create a web application to track DynamoDB data</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_cross_SubmitDataApp_section.html"
 * target="_top">Build an application to submit data to a DynamoDB table</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_cross_LambdaAPIGateway_section.html"
 * target="_top">Use API Gateway to invoke a Lambda function</a></li>
 * <li><a
 * href="https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_cross_LambdaScheduledEvents_section.html"
 * target="_top">Use scheduled events to invoke a Lambda function</a></li>
 * <li><a
 * href="https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_cross_ServerlessWorkflows_section.html"
 * target="_top">Use Step Functions to invoke Lambda functions</a></li>
 * <li><a href=
 * "https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_cross_RekognitionPhotoAnalyzerPPE_section.html"
 * target="_top">Detect PPE in images with Amazon Rekognition using an AWS SDK</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_cross_MonitorDynamoDB_section.html"
 * target="_top">Monitor performance of Amazon DynamoDB using an AWS SDK</a></li>
 * <li><a href=
 * "https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_Scenario_PartiQLSingle_section.html"
 * target="_top">Query a DynamoDB table using PartiQL and an AWS SDK</a></li>
 * <li><a href=
 * "https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_Scenario_PartiQLBatch_section.html"
 * target="_top">Query a DynamoDB table by using batches of PartiQL statements and an AWS SDK</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_PutItemTTL_section.html"
 * target="_top">Create a DynamoDB item with a TTL using an AWS SDK</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_UpdateItemTTL_section.html"
 * target="_top">Update a DynamoDB item with a TTL using an AWS SDK</a></li>
 * <li><a href=
 * "https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_UpdateItemConditionalTTL_section.html"
 * target="_top">Conditionally update a DynamoDB item with a TTL using an AWS SDK</a></li>
 * <li><a
 * href="https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_QueryFilteredTTL_section.html"
 * target="_top">Query a DynamoDB table for TTL items using an AWS SDK</a></li>
 * <li><a href=
 * "https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_CreateTableWarmThroughput_section.html"
 * target="_top">Create a DynamoDB table with warm throughput setting using an AWS SDK</a></li>
 * <li><a href=
 * "https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_UpdateTableWarmThroughput_section.html"
 * target="_top">Update a DynamoDB table setting with warm throughput using an AWS SDK</a></li>
 * <li><a href=
 * "https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_CreateTableWithGlobalSecondaryIndex_section.html"
 * target="_top">Create a DynamoDB table with a Global Secondary Index using the AWS SDK</a></li>
 * <li><a href=
 * "https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_Scenarios_QueryWithStronglyConsistentReads_section.html"
 * target="_top">Query a DynamoDB table with strongly consistent reads using an AWS SDK</a></li>
 * <li><a href=
 * "https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_Scenarios_QueryWithGlobalSecondaryIndex_section.html"
 * target="_top">Query a DynamoDB table using a Global Secondary Index with an AWS SDK</a></li>
 * <li><a href=
 * "https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_Scenarios_QueryWithBeginsWithCondition_section.html"
 * target="_top">Query a DynamoDB table using a begins_with condition with an AWS SDK</a></li>
 * <li><a href=
 * "https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_Scenarios_QueryWithDateRange_section.html"
 * target="_top">Query a DynamoDB table using a date range in the sort key with an AWS SDK</a></li>
 * <li><a href=
 * "https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_Scenarios_QueryWithComplexFilter_section.html"
 * target="_top">Query a DynamoDB table with a complex filter expression with an AWS SDK</a></li>
 * <li><a href=
 * "https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_Scenarios_QueryWithDynamicFilter_section.html"
 * target="_top">Query a DynamoDB table with a dynamic filter expression with an AWS SDK</a></li>
 * <li><a href=
 * "https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_Scenarios_QueryWithFilterAndLimit_section.html"
 * target="_top">Query a DynamoDB table with a filter expression and limit with an AWS SDK</a></li>
 * <li><a href=
 * "https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_Scenarios_QueryWithPagination_section.html"
 * target="_top">Query a DynamoDB table with pagination using an AWS SDK</a></li>
 * <li><a href=
 * "https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_Scenarios_QueryWithNestedAttributes_section.html"
 * target="_top">Query a DynamoDB table with nested attributes using an AWS SDK</a></li>
 * <li><a href=
 * "https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_Scenario_AdvancedQueryTechniques_section.html"
 * target="_top">Perform advanced DynamoDB query operations using an AWS SDK</a></li>
 * <li><a href=
 * "https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_Scenario_DateTimeQueries_section.html"
 * target="_top">Query DynamoDB tables using date and time patterns with an AWS SDK</a></li>
 * <li><a href=
 * "https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_Scenario_AtomicCounterOperations_section.html"
 * target="_top">Use atomic counter operations in DynamoDB with an AWS SDK</a></li>
 * <li><a href=
 * "https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_Scenario_CompareMultipleValues_section.html"
 * target="_top">Compare multiple values with a single attribute in DynamoDB with an AWS SDK</a></li>
 * <li><a href=
 * "https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_Scenario_ConditionalOperations_section.html"
 * target="_top">Use conditional operations in DynamoDB with an AWS SDK</a></li>
 * <li><a href=
 * "https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_Scenario_ExpressionAttributeNames_section.html"
 * target="_top">Use expression attribute names in DynamoDB with an AWS SDK</a></li>
 * <li><a href=
 * "https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_Scenario_ExpressionOperatorCounting_section.html"
 * target="_top">Count expression operators in DynamoDB with an AWS SDK</a></li>
 * <li><a href=
 * "https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_Scenario_ListOperations_section.html"
 * target="_top">Perform list operations in DynamoDB with an AWS SDK</a></li>
 * <li><a href=
 * "https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_Scenario_MapOperations_section.html"
 * target="_top">Perform map operations in DynamoDB with an AWS SDK</a></li>
 * <li><a href=
 * "https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_Scenario_SetOperations_section.html"
 * target="_top">Perform set operations in DynamoDB with an AWS SDK</a></li>
 * <li><a href=
 * "https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_Scenario_UpdateExpressionOrder_section.html"
 * target="_top">Understand update expression order in DynamoDB with an AWS SDK</a></li>
 * <li><a href=
 * "https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_Scenario_MRSCGlobalTables_section.html"
 * target="_top">Create and manage DynamoDB global tables with Multi-Region Strong Consistency using an AWS SDK</a></li>
 * <li><a href=
 * "https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_dynamodb_Scenario_GlobalTableOperations_section.html"
 * target="_top">Create and manage DynamoDB global tables demonstrating MREC using an AWS SDK</a></li>
 * </ul>
 * <h3>Serverless Examples</h3>
 * <ul>
 * <li><a
 * href="https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_serverless_DynamoDB_Lambda_section.html"
 * target="_top">Invoke a Lambda function from a DynamoDB trigger</a></li>
 * <li><a href=
 * "https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_serverless_DynamoDB_Lambda_batch_item_failures_section.html"
 * target="_top">Reporting batch item failures for Lambda functions with a DynamoDB trigger</a></li>
 * </ul>
 * <h3>TributaryLite</h3>
 * <ul>
 * <li><a href=
 * "https://docs.aws.amazon.com/code-library/latest/ug/dynamodb_example_tributary-lite_serverless-application_section.html"
 * target="_top">Build and test a serverless application</a></li>
 * </ul>
 */
package software.amazon.awssdk.services.dynamodb;