/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dynamodb.model.BackupSummariesCopier;
import software.amazon.awssdk.services.dynamodb.model.BackupSummary;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBackupsResponse
extends DynamoDbResponse
implements ToCopyableBuilder<Builder, ListBackupsResponse> {
    private static final SdkField<List<BackupSummary>> BACKUP_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BackupSummaries").getter(ListBackupsResponse.getter(ListBackupsResponse::backupSummaries)).setter(ListBackupsResponse.setter(Builder::backupSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BackupSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LAST_EVALUATED_BACKUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastEvaluatedBackupArn").getter(ListBackupsResponse.getter(ListBackupsResponse::lastEvaluatedBackupArn)).setter(ListBackupsResponse.setter(Builder::lastEvaluatedBackupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastEvaluatedBackupArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_SUMMARIES_FIELD, LAST_EVALUATED_BACKUP_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListBackupsResponse.memberNameToFieldInitializer();
    private final List<BackupSummary> backupSummaries;
    private final String lastEvaluatedBackupArn;

    private ListBackupsResponse(BuilderImpl builder) {
        super(builder);
        this.backupSummaries = builder.backupSummaries;
        this.lastEvaluatedBackupArn = builder.lastEvaluatedBackupArn;
    }

    public final boolean hasBackupSummaries() {
        return this.backupSummaries != null && !(this.backupSummaries instanceof SdkAutoConstructList);
    }

    public final List<BackupSummary> backupSummaries() {
        return this.backupSummaries;
    }

    public final String lastEvaluatedBackupArn() {
        return this.lastEvaluatedBackupArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBackupSummaries() ? this.backupSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lastEvaluatedBackupArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBackupsResponse)) {
            return false;
        }
        ListBackupsResponse other = (ListBackupsResponse)((Object)obj);
        return this.hasBackupSummaries() == other.hasBackupSummaries() && Objects.equals(this.backupSummaries(), other.backupSummaries()) && Objects.equals(this.lastEvaluatedBackupArn(), other.lastEvaluatedBackupArn());
    }

    public final String toString() {
        return ToString.builder((String)"ListBackupsResponse").add("BackupSummaries", this.hasBackupSummaries() ? this.backupSummaries() : null).add("LastEvaluatedBackupArn", (Object)this.lastEvaluatedBackupArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackupSummaries": {
                return Optional.ofNullable(clazz.cast(this.backupSummaries()));
            }
            case "LastEvaluatedBackupArn": {
                return Optional.ofNullable(clazz.cast(this.lastEvaluatedBackupArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("BackupSummaries", BACKUP_SUMMARIES_FIELD);
        map.put("LastEvaluatedBackupArn", LAST_EVALUATED_BACKUP_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListBackupsResponse, T> g) {
        return obj -> g.apply((ListBackupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DynamoDbResponse.BuilderImpl
    implements Builder {
        private List<BackupSummary> backupSummaries = DefaultSdkAutoConstructList.getInstance();
        private String lastEvaluatedBackupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBackupsResponse model) {
            super(model);
            this.backupSummaries(model.backupSummaries);
            this.lastEvaluatedBackupArn(model.lastEvaluatedBackupArn);
        }

        public final List<BackupSummary.Builder> getBackupSummaries() {
            List<BackupSummary.Builder> result = BackupSummariesCopier.copyToBuilder(this.backupSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBackupSummaries(Collection<BackupSummary.BuilderImpl> backupSummaries) {
            this.backupSummaries = BackupSummariesCopier.copyFromBuilder(backupSummaries);
        }

        @Override
        public final Builder backupSummaries(Collection<BackupSummary> backupSummaries) {
            this.backupSummaries = BackupSummariesCopier.copy(backupSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder backupSummaries(BackupSummary ... backupSummaries) {
            this.backupSummaries(Arrays.asList(backupSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder backupSummaries(Consumer<BackupSummary.Builder> ... backupSummaries) {
            this.backupSummaries(Stream.of(backupSummaries).map(c -> (BackupSummary)((BackupSummary.Builder)BackupSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getLastEvaluatedBackupArn() {
            return this.lastEvaluatedBackupArn;
        }

        public final void setLastEvaluatedBackupArn(String lastEvaluatedBackupArn) {
            this.lastEvaluatedBackupArn = lastEvaluatedBackupArn;
        }

        @Override
        public final Builder lastEvaluatedBackupArn(String lastEvaluatedBackupArn) {
            this.lastEvaluatedBackupArn = lastEvaluatedBackupArn;
            return this;
        }

        @Override
        public ListBackupsResponse build() {
            return new ListBackupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DynamoDbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListBackupsResponse> {
        public Builder backupSummaries(Collection<BackupSummary> var1);

        public Builder backupSummaries(BackupSummary ... var1);

        public Builder backupSummaries(Consumer<BackupSummary.Builder> ... var1);

        public Builder lastEvaluatedBackupArn(String var1);
    }
}

