/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.endpoints.internal;

import java.net.URI;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.endpoints.AwsEndpointAttribute;
import software.amazon.awssdk.awscore.endpoints.authscheme.SigV4AuthScheme;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.dynamodb.endpoints.DynamoDbEndpointParams;
import software.amazon.awssdk.services.dynamodb.endpoints.DynamoDbEndpointProvider;
import software.amazon.awssdk.services.dynamodb.endpoints.internal.RuleArn;
import software.amazon.awssdk.services.dynamodb.endpoints.internal.RulePartition;
import software.amazon.awssdk.services.dynamodb.endpoints.internal.RuleResult;
import software.amazon.awssdk.services.dynamodb.endpoints.internal.RulesFunctions;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultDynamoDbEndpointProvider
implements DynamoDbEndpointProvider {
    @Override
    public CompletableFuture<Endpoint> resolveEndpoint(DynamoDbEndpointParams params) {
        Validate.notNull((Object)params.useDualStack(), (String)"Parameter 'UseDualStack' must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)params.useFips(), (String)"Parameter 'UseFIPS' must not be null", (Object[])new Object[0]);
        try {
            RuleResult result = DefaultDynamoDbEndpointProvider.endpointRule0(params, new LocalState(params.region()));
            if (result.canContinue()) {
                throw SdkClientException.create((String)"Rule engine did not reach an error or endpoint result");
            }
            if (result.isError()) {
                String errorMsg = result.error();
                if (errorMsg.contains("Invalid ARN") && errorMsg.contains(":s3:::")) {
                    errorMsg = errorMsg + ". Use the bucket name instead of simple bucket ARNs in GetBucketLocationRequest.";
                }
                throw SdkClientException.create((String)errorMsg);
            }
            return CompletableFuture.completedFuture(result.endpoint());
        }
        catch (Exception error) {
            return CompletableFutureUtils.failedFuture((Throwable)error);
        }
    }

    private static RuleResult endpointRule0(DynamoDbEndpointParams params, LocalState locals) {
        RuleResult result = DefaultDynamoDbEndpointProvider.endpointRule1(params, locals);
        if (result.isResolved()) {
            return result;
        }
        result = DefaultDynamoDbEndpointProvider.endpointRule5(params, locals);
        if (result.isResolved()) {
            return result;
        }
        return DefaultDynamoDbEndpointProvider.endpointRule50(params, locals);
    }

    private static RuleResult endpointRule1(DynamoDbEndpointParams params, LocalState locals) {
        if (params.endpoint() != null) {
            RuleResult result = DefaultDynamoDbEndpointProvider.endpointRule2(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultDynamoDbEndpointProvider.endpointRule3(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultDynamoDbEndpointProvider.endpointRule4(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule2(DynamoDbEndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue()) {
            return RuleResult.error("Invalid Configuration: FIPS and custom endpoint are not supported");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule3(DynamoDbEndpointParams params, LocalState locals) {
        if (params.useDualStack().booleanValue()) {
            return RuleResult.error("Invalid Configuration: Dualstack and custom endpoint are not supported");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule4(DynamoDbEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create(params.endpoint())).build());
    }

    private static RuleResult endpointRule5(DynamoDbEndpointParams params, LocalState locals) {
        if (locals.region() != null) {
            return DefaultDynamoDbEndpointProvider.endpointRule6(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule6(DynamoDbEndpointParams params, LocalState locals) {
        RulePartition partitionResult = null;
        partitionResult = RulesFunctions.awsPartition(locals.region());
        if (partitionResult != null) {
            RuleResult result = DefaultDynamoDbEndpointProvider.endpointRule7(params, locals = locals.toBuilder().partitionResult(partitionResult).build());
            if (result.isResolved()) {
                return result;
            }
            result = DefaultDynamoDbEndpointProvider.endpointRule11(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultDynamoDbEndpointProvider.endpointRule17(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultDynamoDbEndpointProvider.endpointRule27(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultDynamoDbEndpointProvider.endpointRule35(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultDynamoDbEndpointProvider.endpointRule36(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultDynamoDbEndpointProvider.endpointRule37(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultDynamoDbEndpointProvider.endpointRule41(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultDynamoDbEndpointProvider.endpointRule49(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule7(DynamoDbEndpointParams params, LocalState locals) {
        if ("local".equals(locals.region())) {
            RuleResult result = DefaultDynamoDbEndpointProvider.endpointRule8(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultDynamoDbEndpointProvider.endpointRule9(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultDynamoDbEndpointProvider.endpointRule10(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule8(DynamoDbEndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue()) {
            return RuleResult.error("Invalid Configuration: FIPS and local endpoint are not supported");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule9(DynamoDbEndpointParams params, LocalState locals) {
        if (params.useDualStack().booleanValue()) {
            return RuleResult.error("Invalid Configuration: Dualstack and local endpoint are not supported");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule10(DynamoDbEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("http://localhost:8000")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingName("dynamodb").signingRegion("us-east-1").build())).build());
    }

    private static RuleResult endpointRule11(DynamoDbEndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
            RuleResult result = DefaultDynamoDbEndpointProvider.endpointRule12(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultDynamoDbEndpointProvider.endpointRule16(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule12(DynamoDbEndpointParams params, LocalState locals) {
        if (locals.partitionResult().supportsFIPS() && locals.partitionResult().supportsDualStack()) {
            RuleResult result = DefaultDynamoDbEndpointProvider.endpointRule13(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultDynamoDbEndpointProvider.endpointRule15(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule13(DynamoDbEndpointParams params, LocalState locals) {
        if (params.accountIdEndpointMode() != null && "required".equals(params.accountIdEndpointMode())) {
            return DefaultDynamoDbEndpointProvider.endpointRule14(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule14(DynamoDbEndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid Configuration: AccountIdEndpointMode is required and FIPS is enabled, but FIPS account endpoints are not supported");
    }

    private static RuleResult endpointRule15(DynamoDbEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://dynamodb-fips." + locals.region() + "." + locals.partitionResult().dualStackDnsSuffix())).build());
    }

    private static RuleResult endpointRule16(DynamoDbEndpointParams params, LocalState locals) {
        return RuleResult.error("FIPS and DualStack are enabled, but this partition does not support one or both");
    }

    private static RuleResult endpointRule17(DynamoDbEndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue()) {
            RuleResult result = DefaultDynamoDbEndpointProvider.endpointRule18(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultDynamoDbEndpointProvider.endpointRule26(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule18(DynamoDbEndpointParams params, LocalState locals) {
        if (locals.partitionResult().supportsFIPS()) {
            RuleResult result = DefaultDynamoDbEndpointProvider.endpointRule19(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultDynamoDbEndpointProvider.endpointRule23(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultDynamoDbEndpointProvider.endpointRule25(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule19(DynamoDbEndpointParams params, LocalState locals) {
        if ("aws-us-gov".equals(locals.partitionResult().name())) {
            RuleResult result = DefaultDynamoDbEndpointProvider.endpointRule20(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultDynamoDbEndpointProvider.endpointRule22(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule20(DynamoDbEndpointParams params, LocalState locals) {
        if (params.accountIdEndpointMode() != null && "required".equals(params.accountIdEndpointMode())) {
            return DefaultDynamoDbEndpointProvider.endpointRule21(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule21(DynamoDbEndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid Configuration: AccountIdEndpointMode is required and FIPS is enabled, but FIPS account endpoints are not supported");
    }

    private static RuleResult endpointRule22(DynamoDbEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://dynamodb." + locals.region() + "." + locals.partitionResult().dnsSuffix())).build());
    }

    private static RuleResult endpointRule23(DynamoDbEndpointParams params, LocalState locals) {
        if (params.accountIdEndpointMode() != null && "required".equals(params.accountIdEndpointMode())) {
            return DefaultDynamoDbEndpointProvider.endpointRule24(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule24(DynamoDbEndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid Configuration: AccountIdEndpointMode is required and FIPS is enabled, but FIPS account endpoints are not supported");
    }

    private static RuleResult endpointRule25(DynamoDbEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://dynamodb-fips." + locals.region() + "." + locals.partitionResult().dnsSuffix())).build());
    }

    private static RuleResult endpointRule26(DynamoDbEndpointParams params, LocalState locals) {
        return RuleResult.error("FIPS is enabled but this partition does not support FIPS");
    }

    private static RuleResult endpointRule27(DynamoDbEndpointParams params, LocalState locals) {
        if (params.useDualStack().booleanValue()) {
            RuleResult result = DefaultDynamoDbEndpointProvider.endpointRule28(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultDynamoDbEndpointProvider.endpointRule34(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule28(DynamoDbEndpointParams params, LocalState locals) {
        if (locals.partitionResult().supportsDualStack()) {
            RuleResult result = DefaultDynamoDbEndpointProvider.endpointRule29(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultDynamoDbEndpointProvider.endpointRule33(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule29(DynamoDbEndpointParams params, LocalState locals) {
        if (params.accountIdEndpointMode() != null && "required".equals(params.accountIdEndpointMode())) {
            RuleResult result = DefaultDynamoDbEndpointProvider.endpointRule30(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultDynamoDbEndpointProvider.endpointRule32(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule30(DynamoDbEndpointParams params, LocalState locals) {
        if (!params.useFips().booleanValue()) {
            return DefaultDynamoDbEndpointProvider.endpointRule31(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule31(DynamoDbEndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid Configuration: AccountIdEndpointMode is required and DualStack is enabled, but DualStack account endpoints are not supported");
    }

    private static RuleResult endpointRule32(DynamoDbEndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid Configuration: AccountIdEndpointMode is required and FIPS is enabled, but FIPS account endpoints are not supported");
    }

    private static RuleResult endpointRule33(DynamoDbEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://dynamodb." + locals.region() + "." + locals.partitionResult().dualStackDnsSuffix())).build());
    }

    private static RuleResult endpointRule34(DynamoDbEndpointParams params, LocalState locals) {
        return RuleResult.error("DualStack is enabled but this partition does not support DualStack");
    }

    private static RuleResult endpointRule35(DynamoDbEndpointParams params, LocalState locals) {
        if (params.accountIdEndpointMode() != null && !"disabled".equals(params.accountIdEndpointMode()) && "aws".equals(locals.partitionResult().name()) && !params.useFips().booleanValue() && !params.useDualStack().booleanValue() && params.resourceArn() != null) {
            RuleArn parsedArn = null;
            parsedArn = RulesFunctions.awsParseArn(params.resourceArn());
            if (parsedArn != null && "dynamodb".equals((locals = locals.toBuilder().parsedArn(parsedArn).build()).parsedArn().service()) && RulesFunctions.isValidHostLabel(locals.parsedArn().region(), false) && RulesFunctions.stringEquals(locals.parsedArn().region(), locals.region()) && RulesFunctions.isValidHostLabel(locals.parsedArn().accountId(), false)) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + locals.parsedArn().accountId() + ".ddb." + locals.region() + "." + locals.partitionResult().dnsSuffix())).build());
            }
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule36(DynamoDbEndpointParams params, LocalState locals) {
        if (params.accountIdEndpointMode() != null && !"disabled".equals(params.accountIdEndpointMode()) && "aws".equals(locals.partitionResult().name()) && !params.useFips().booleanValue() && !params.useDualStack().booleanValue() && params.resourceArnList() != null) {
            String firstArn = null;
            RuleArn parsedArn = null;
            firstArn = RulesFunctions.listAccess(params.resourceArnList(), 0);
            if (firstArn == null) {
                return RuleResult.carryOn();
            }
            locals = locals.toBuilder().firstArn(firstArn).build();
            parsedArn = RulesFunctions.awsParseArn(locals.firstArn());
            if (parsedArn != null && "dynamodb".equals((locals = locals.toBuilder().parsedArn(parsedArn).build()).parsedArn().service()) && RulesFunctions.isValidHostLabel(locals.parsedArn().region(), false) && RulesFunctions.stringEquals(locals.parsedArn().region(), locals.region()) && RulesFunctions.isValidHostLabel(locals.parsedArn().accountId(), false)) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + locals.parsedArn().accountId() + ".ddb." + locals.region() + "." + locals.partitionResult().dnsSuffix())).build());
            }
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule37(DynamoDbEndpointParams params, LocalState locals) {
        if (params.accountIdEndpointMode() != null && !"disabled".equals(params.accountIdEndpointMode()) && "aws".equals(locals.partitionResult().name()) && !params.useFips().booleanValue() && !params.useDualStack().booleanValue() && params.accountId() != null) {
            RuleResult result = DefaultDynamoDbEndpointProvider.endpointRule38(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultDynamoDbEndpointProvider.endpointRule40(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule38(DynamoDbEndpointParams params, LocalState locals) {
        if (RulesFunctions.isValidHostLabel(params.accountId(), false)) {
            return DefaultDynamoDbEndpointProvider.endpointRule39(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule39(DynamoDbEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.accountId() + ".ddb." + locals.region() + "." + locals.partitionResult().dnsSuffix())).build());
    }

    private static RuleResult endpointRule40(DynamoDbEndpointParams params, LocalState locals) {
        return RuleResult.error("Credentials-sourced account ID parameter is invalid");
    }

    private static RuleResult endpointRule41(DynamoDbEndpointParams params, LocalState locals) {
        if (params.accountIdEndpointMode() != null && "required".equals(params.accountIdEndpointMode())) {
            RuleResult result = DefaultDynamoDbEndpointProvider.endpointRule42(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultDynamoDbEndpointProvider.endpointRule48(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule42(DynamoDbEndpointParams params, LocalState locals) {
        if (!params.useFips().booleanValue()) {
            RuleResult result = DefaultDynamoDbEndpointProvider.endpointRule43(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultDynamoDbEndpointProvider.endpointRule47(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule43(DynamoDbEndpointParams params, LocalState locals) {
        if (!params.useDualStack().booleanValue()) {
            RuleResult result = DefaultDynamoDbEndpointProvider.endpointRule44(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultDynamoDbEndpointProvider.endpointRule46(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule44(DynamoDbEndpointParams params, LocalState locals) {
        if ("aws".equals(locals.partitionResult().name())) {
            return DefaultDynamoDbEndpointProvider.endpointRule45(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule45(DynamoDbEndpointParams params, LocalState locals) {
        return RuleResult.error("AccountIdEndpointMode is required but no AccountID was provided or able to be loaded");
    }

    private static RuleResult endpointRule46(DynamoDbEndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid Configuration: AccountIdEndpointMode is required but account endpoints are not supported in this partition");
    }

    private static RuleResult endpointRule47(DynamoDbEndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid Configuration: AccountIdEndpointMode is required and DualStack is enabled, but DualStack account endpoints are not supported");
    }

    private static RuleResult endpointRule48(DynamoDbEndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid Configuration: AccountIdEndpointMode is required and FIPS is enabled, but FIPS account endpoints are not supported");
    }

    private static RuleResult endpointRule49(DynamoDbEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://dynamodb." + locals.region() + "." + locals.partitionResult().dnsSuffix())).build());
    }

    private static RuleResult endpointRule50(DynamoDbEndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid Configuration: Missing Region");
    }

    public boolean equals(Object rhs) {
        return rhs != null && this.getClass().equals(rhs.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    private static final class LocalStateBuilder {
        private String region;
        private RulePartition partitionResult;
        private RuleArn parsedArn;
        private String firstArn;

        LocalStateBuilder() {
            this.region = null;
            this.partitionResult = null;
            this.parsedArn = null;
            this.firstArn = null;
        }

        LocalStateBuilder(LocalState locals) {
            this.region = locals.region;
            this.partitionResult = locals.partitionResult;
            this.parsedArn = locals.parsedArn;
            this.firstArn = locals.firstArn;
        }

        public LocalStateBuilder region(String value) {
            this.region = value;
            return this;
        }

        public LocalStateBuilder partitionResult(RulePartition value) {
            this.partitionResult = value;
            return this;
        }

        public LocalStateBuilder parsedArn(RuleArn value) {
            this.parsedArn = value;
            return this;
        }

        public LocalStateBuilder firstArn(String value) {
            this.firstArn = value;
            return this;
        }

        LocalState build() {
            return new LocalState(this);
        }
    }

    private static final class LocalState {
        private final String region;
        private final RulePartition partitionResult;
        private final RuleArn parsedArn;
        private final String firstArn;

        LocalState() {
            this.region = null;
            this.partitionResult = null;
            this.parsedArn = null;
            this.firstArn = null;
        }

        LocalState(Region region) {
            this.region = region != null ? region.id() : null;
            this.partitionResult = null;
            this.parsedArn = null;
            this.firstArn = null;
        }

        LocalState(LocalStateBuilder builder) {
            this.region = builder.region;
            this.partitionResult = builder.partitionResult;
            this.parsedArn = builder.parsedArn;
            this.firstArn = builder.firstArn;
        }

        public String region() {
            return this.region;
        }

        public RulePartition partitionResult() {
            return this.partitionResult;
        }

        public RuleArn parsedArn() {
            return this.parsedArn;
        }

        public String firstArn() {
            return this.firstArn;
        }

        public LocalStateBuilder toBuilder() {
            return new LocalStateBuilder(this);
        }
    }
}

