/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinitionsCopier;
import software.amazon.awssdk.services.dynamodb.model.BillingMode;
import software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndex;
import software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexListCopier;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaCopier;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import software.amazon.awssdk.services.dynamodb.model.OnDemandThroughput;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughput;
import software.amazon.awssdk.services.dynamodb.model.SSESpecification;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TableCreationParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TableCreationParameters> {
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableName").getter(TableCreationParameters.getter(TableCreationParameters::tableName)).setter(TableCreationParameters.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()}).build();
    private static final SdkField<List<AttributeDefinition>> ATTRIBUTE_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AttributeDefinitions").getter(TableCreationParameters.getter(TableCreationParameters::attributeDefinitions)).setter(TableCreationParameters.setter(Builder::attributeDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeDefinitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<KeySchemaElement>> KEY_SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("KeySchema").getter(TableCreationParameters.getter(TableCreationParameters::keySchema)).setter(TableCreationParameters.setter(Builder::keySchema)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeySchema").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KeySchemaElement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> BILLING_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BillingMode").getter(TableCreationParameters.getter(TableCreationParameters::billingModeAsString)).setter(TableCreationParameters.setter(Builder::billingMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingMode").build()}).build();
    private static final SdkField<ProvisionedThroughput> PROVISIONED_THROUGHPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProvisionedThroughput").getter(TableCreationParameters.getter(TableCreationParameters::provisionedThroughput)).setter(TableCreationParameters.setter(Builder::provisionedThroughput)).constructor(ProvisionedThroughput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedThroughput").build()}).build();
    private static final SdkField<OnDemandThroughput> ON_DEMAND_THROUGHPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OnDemandThroughput").getter(TableCreationParameters.getter(TableCreationParameters::onDemandThroughput)).setter(TableCreationParameters.setter(Builder::onDemandThroughput)).constructor(OnDemandThroughput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnDemandThroughput").build()}).build();
    private static final SdkField<SSESpecification> SSE_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SSESpecification").getter(TableCreationParameters.getter(TableCreationParameters::sseSpecification)).setter(TableCreationParameters.setter(Builder::sseSpecification)).constructor(SSESpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SSESpecification").build()}).build();
    private static final SdkField<List<GlobalSecondaryIndex>> GLOBAL_SECONDARY_INDEXES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GlobalSecondaryIndexes").getter(TableCreationParameters.getter(TableCreationParameters::globalSecondaryIndexes)).setter(TableCreationParameters.setter(Builder::globalSecondaryIndexes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalSecondaryIndexes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GlobalSecondaryIndex::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_NAME_FIELD, ATTRIBUTE_DEFINITIONS_FIELD, KEY_SCHEMA_FIELD, BILLING_MODE_FIELD, PROVISIONED_THROUGHPUT_FIELD, ON_DEMAND_THROUGHPUT_FIELD, SSE_SPECIFICATION_FIELD, GLOBAL_SECONDARY_INDEXES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TableCreationParameters.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String tableName;
    private final List<AttributeDefinition> attributeDefinitions;
    private final List<KeySchemaElement> keySchema;
    private final String billingMode;
    private final ProvisionedThroughput provisionedThroughput;
    private final OnDemandThroughput onDemandThroughput;
    private final SSESpecification sseSpecification;
    private final List<GlobalSecondaryIndex> globalSecondaryIndexes;

    private TableCreationParameters(BuilderImpl builder) {
        this.tableName = builder.tableName;
        this.attributeDefinitions = builder.attributeDefinitions;
        this.keySchema = builder.keySchema;
        this.billingMode = builder.billingMode;
        this.provisionedThroughput = builder.provisionedThroughput;
        this.onDemandThroughput = builder.onDemandThroughput;
        this.sseSpecification = builder.sseSpecification;
        this.globalSecondaryIndexes = builder.globalSecondaryIndexes;
    }

    public final String tableName() {
        return this.tableName;
    }

    public final boolean hasAttributeDefinitions() {
        return this.attributeDefinitions != null && !(this.attributeDefinitions instanceof SdkAutoConstructList);
    }

    public final List<AttributeDefinition> attributeDefinitions() {
        return this.attributeDefinitions;
    }

    public final boolean hasKeySchema() {
        return this.keySchema != null && !(this.keySchema instanceof SdkAutoConstructList);
    }

    public final List<KeySchemaElement> keySchema() {
        return this.keySchema;
    }

    public final BillingMode billingMode() {
        return BillingMode.fromValue(this.billingMode);
    }

    public final String billingModeAsString() {
        return this.billingMode;
    }

    public final ProvisionedThroughput provisionedThroughput() {
        return this.provisionedThroughput;
    }

    public final OnDemandThroughput onDemandThroughput() {
        return this.onDemandThroughput;
    }

    public final SSESpecification sseSpecification() {
        return this.sseSpecification;
    }

    public final boolean hasGlobalSecondaryIndexes() {
        return this.globalSecondaryIndexes != null && !(this.globalSecondaryIndexes instanceof SdkAutoConstructList);
    }

    public final List<GlobalSecondaryIndex> globalSecondaryIndexes() {
        return this.globalSecondaryIndexes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributeDefinitions() ? this.attributeDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKeySchema() ? this.keySchema() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.billingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedThroughput());
        hashCode = 31 * hashCode + Objects.hashCode(this.onDemandThroughput());
        hashCode = 31 * hashCode + Objects.hashCode(this.sseSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGlobalSecondaryIndexes() ? this.globalSecondaryIndexes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableCreationParameters)) {
            return false;
        }
        TableCreationParameters other = (TableCreationParameters)obj;
        return Objects.equals(this.tableName(), other.tableName()) && this.hasAttributeDefinitions() == other.hasAttributeDefinitions() && Objects.equals(this.attributeDefinitions(), other.attributeDefinitions()) && this.hasKeySchema() == other.hasKeySchema() && Objects.equals(this.keySchema(), other.keySchema()) && Objects.equals(this.billingModeAsString(), other.billingModeAsString()) && Objects.equals(this.provisionedThroughput(), other.provisionedThroughput()) && Objects.equals(this.onDemandThroughput(), other.onDemandThroughput()) && Objects.equals(this.sseSpecification(), other.sseSpecification()) && this.hasGlobalSecondaryIndexes() == other.hasGlobalSecondaryIndexes() && Objects.equals(this.globalSecondaryIndexes(), other.globalSecondaryIndexes());
    }

    public final String toString() {
        return ToString.builder((String)"TableCreationParameters").add("TableName", (Object)this.tableName()).add("AttributeDefinitions", this.hasAttributeDefinitions() ? this.attributeDefinitions() : null).add("KeySchema", this.hasKeySchema() ? this.keySchema() : null).add("BillingMode", (Object)this.billingModeAsString()).add("ProvisionedThroughput", (Object)this.provisionedThroughput()).add("OnDemandThroughput", (Object)this.onDemandThroughput()).add("SSESpecification", (Object)this.sseSpecification()).add("GlobalSecondaryIndexes", this.hasGlobalSecondaryIndexes() ? this.globalSecondaryIndexes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "AttributeDefinitions": {
                return Optional.ofNullable(clazz.cast(this.attributeDefinitions()));
            }
            case "KeySchema": {
                return Optional.ofNullable(clazz.cast(this.keySchema()));
            }
            case "BillingMode": {
                return Optional.ofNullable(clazz.cast(this.billingModeAsString()));
            }
            case "ProvisionedThroughput": {
                return Optional.ofNullable(clazz.cast(this.provisionedThroughput()));
            }
            case "OnDemandThroughput": {
                return Optional.ofNullable(clazz.cast(this.onDemandThroughput()));
            }
            case "SSESpecification": {
                return Optional.ofNullable(clazz.cast(this.sseSpecification()));
            }
            case "GlobalSecondaryIndexes": {
                return Optional.ofNullable(clazz.cast(this.globalSecondaryIndexes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TableName", TABLE_NAME_FIELD);
        map.put("AttributeDefinitions", ATTRIBUTE_DEFINITIONS_FIELD);
        map.put("KeySchema", KEY_SCHEMA_FIELD);
        map.put("BillingMode", BILLING_MODE_FIELD);
        map.put("ProvisionedThroughput", PROVISIONED_THROUGHPUT_FIELD);
        map.put("OnDemandThroughput", ON_DEMAND_THROUGHPUT_FIELD);
        map.put("SSESpecification", SSE_SPECIFICATION_FIELD);
        map.put("GlobalSecondaryIndexes", GLOBAL_SECONDARY_INDEXES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TableCreationParameters, T> g) {
        return obj -> g.apply((TableCreationParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String tableName;
        private List<AttributeDefinition> attributeDefinitions = DefaultSdkAutoConstructList.getInstance();
        private List<KeySchemaElement> keySchema = DefaultSdkAutoConstructList.getInstance();
        private String billingMode;
        private ProvisionedThroughput provisionedThroughput;
        private OnDemandThroughput onDemandThroughput;
        private SSESpecification sseSpecification;
        private List<GlobalSecondaryIndex> globalSecondaryIndexes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TableCreationParameters model) {
            this.tableName(model.tableName);
            this.attributeDefinitions(model.attributeDefinitions);
            this.keySchema(model.keySchema);
            this.billingMode(model.billingMode);
            this.provisionedThroughput(model.provisionedThroughput);
            this.onDemandThroughput(model.onDemandThroughput);
            this.sseSpecification(model.sseSpecification);
            this.globalSecondaryIndexes(model.globalSecondaryIndexes);
        }

        public final String getTableName() {
            return this.tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final List<AttributeDefinition.Builder> getAttributeDefinitions() {
            List<AttributeDefinition.Builder> result = AttributeDefinitionsCopier.copyToBuilder(this.attributeDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttributeDefinitions(Collection<AttributeDefinition.BuilderImpl> attributeDefinitions) {
            this.attributeDefinitions = AttributeDefinitionsCopier.copyFromBuilder(attributeDefinitions);
        }

        @Override
        public final Builder attributeDefinitions(Collection<AttributeDefinition> attributeDefinitions) {
            this.attributeDefinitions = AttributeDefinitionsCopier.copy(attributeDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeDefinitions(AttributeDefinition ... attributeDefinitions) {
            this.attributeDefinitions(Arrays.asList(attributeDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeDefinitions(Consumer<AttributeDefinition.Builder> ... attributeDefinitions) {
            this.attributeDefinitions(Stream.of(attributeDefinitions).map(c -> (AttributeDefinition)((AttributeDefinition.Builder)AttributeDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<KeySchemaElement.Builder> getKeySchema() {
            List<KeySchemaElement.Builder> result = KeySchemaCopier.copyToBuilder(this.keySchema);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setKeySchema(Collection<KeySchemaElement.BuilderImpl> keySchema) {
            this.keySchema = KeySchemaCopier.copyFromBuilder(keySchema);
        }

        @Override
        public final Builder keySchema(Collection<KeySchemaElement> keySchema) {
            this.keySchema = KeySchemaCopier.copy(keySchema);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keySchema(KeySchemaElement ... keySchema) {
            this.keySchema(Arrays.asList(keySchema));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keySchema(Consumer<KeySchemaElement.Builder> ... keySchema) {
            this.keySchema(Stream.of(keySchema).map(c -> (KeySchemaElement)((KeySchemaElement.Builder)KeySchemaElement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getBillingMode() {
            return this.billingMode;
        }

        public final void setBillingMode(String billingMode) {
            this.billingMode = billingMode;
        }

        @Override
        public final Builder billingMode(String billingMode) {
            this.billingMode = billingMode;
            return this;
        }

        @Override
        public final Builder billingMode(BillingMode billingMode) {
            this.billingMode(billingMode == null ? null : billingMode.toString());
            return this;
        }

        public final ProvisionedThroughput.Builder getProvisionedThroughput() {
            return this.provisionedThroughput != null ? this.provisionedThroughput.toBuilder() : null;
        }

        public final void setProvisionedThroughput(ProvisionedThroughput.BuilderImpl provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput != null ? provisionedThroughput.build() : null;
        }

        @Override
        public final Builder provisionedThroughput(ProvisionedThroughput provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput;
            return this;
        }

        public final OnDemandThroughput.Builder getOnDemandThroughput() {
            return this.onDemandThroughput != null ? this.onDemandThroughput.toBuilder() : null;
        }

        public final void setOnDemandThroughput(OnDemandThroughput.BuilderImpl onDemandThroughput) {
            this.onDemandThroughput = onDemandThroughput != null ? onDemandThroughput.build() : null;
        }

        @Override
        public final Builder onDemandThroughput(OnDemandThroughput onDemandThroughput) {
            this.onDemandThroughput = onDemandThroughput;
            return this;
        }

        public final SSESpecification.Builder getSseSpecification() {
            return this.sseSpecification != null ? this.sseSpecification.toBuilder() : null;
        }

        public final void setSseSpecification(SSESpecification.BuilderImpl sseSpecification) {
            this.sseSpecification = sseSpecification != null ? sseSpecification.build() : null;
        }

        @Override
        public final Builder sseSpecification(SSESpecification sseSpecification) {
            this.sseSpecification = sseSpecification;
            return this;
        }

        public final List<GlobalSecondaryIndex.Builder> getGlobalSecondaryIndexes() {
            List<GlobalSecondaryIndex.Builder> result = GlobalSecondaryIndexListCopier.copyToBuilder(this.globalSecondaryIndexes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGlobalSecondaryIndexes(Collection<GlobalSecondaryIndex.BuilderImpl> globalSecondaryIndexes) {
            this.globalSecondaryIndexes = GlobalSecondaryIndexListCopier.copyFromBuilder(globalSecondaryIndexes);
        }

        @Override
        public final Builder globalSecondaryIndexes(Collection<GlobalSecondaryIndex> globalSecondaryIndexes) {
            this.globalSecondaryIndexes = GlobalSecondaryIndexListCopier.copy(globalSecondaryIndexes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalSecondaryIndexes(GlobalSecondaryIndex ... globalSecondaryIndexes) {
            this.globalSecondaryIndexes(Arrays.asList(globalSecondaryIndexes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalSecondaryIndexes(Consumer<GlobalSecondaryIndex.Builder> ... globalSecondaryIndexes) {
            this.globalSecondaryIndexes(Stream.of(globalSecondaryIndexes).map(c -> (GlobalSecondaryIndex)((GlobalSecondaryIndex.Builder)GlobalSecondaryIndex.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public TableCreationParameters build() {
            return new TableCreationParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TableCreationParameters> {
        public Builder tableName(String var1);

        public Builder attributeDefinitions(Collection<AttributeDefinition> var1);

        public Builder attributeDefinitions(AttributeDefinition ... var1);

        public Builder attributeDefinitions(Consumer<AttributeDefinition.Builder> ... var1);

        public Builder keySchema(Collection<KeySchemaElement> var1);

        public Builder keySchema(KeySchemaElement ... var1);

        public Builder keySchema(Consumer<KeySchemaElement.Builder> ... var1);

        public Builder billingMode(String var1);

        public Builder billingMode(BillingMode var1);

        public Builder provisionedThroughput(ProvisionedThroughput var1);

        default public Builder provisionedThroughput(Consumer<ProvisionedThroughput.Builder> provisionedThroughput) {
            return this.provisionedThroughput((ProvisionedThroughput)((ProvisionedThroughput.Builder)ProvisionedThroughput.builder().applyMutation(provisionedThroughput)).build());
        }

        public Builder onDemandThroughput(OnDemandThroughput var1);

        default public Builder onDemandThroughput(Consumer<OnDemandThroughput.Builder> onDemandThroughput) {
            return this.onDemandThroughput((OnDemandThroughput)((OnDemandThroughput.Builder)OnDemandThroughput.builder().applyMutation(onDemandThroughput)).build());
        }

        public Builder sseSpecification(SSESpecification var1);

        default public Builder sseSpecification(Consumer<SSESpecification.Builder> sseSpecification) {
            return this.sseSpecification((SSESpecification)((SSESpecification.Builder)SSESpecification.builder().applyMutation(sseSpecification)).build());
        }

        public Builder globalSecondaryIndexes(Collection<GlobalSecondaryIndex> var1);

        public Builder globalSecondaryIndexes(GlobalSecondaryIndex ... var1);

        public Builder globalSecondaryIndexes(Consumer<GlobalSecondaryIndex.Builder> ... var1);
    }
}

