/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateContributorInsightsResponse extends DynamoDbResponse implements
        ToCopyableBuilder<UpdateContributorInsightsResponse.Builder, UpdateContributorInsightsResponse> {
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableName").getter(getter(UpdateContributorInsightsResponse::tableName))
            .setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexName").getter(getter(UpdateContributorInsightsResponse::indexName))
            .setter(setter(Builder::indexName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexName").build()).build();

    private static final SdkField<String> CONTRIBUTOR_INSIGHTS_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContributorInsightsStatus")
            .getter(getter(UpdateContributorInsightsResponse::contributorInsightsStatusAsString))
            .setter(setter(Builder::contributorInsightsStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContributorInsightsStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_NAME_FIELD,
            INDEX_NAME_FIELD, CONTRIBUTOR_INSIGHTS_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("TableName", TABLE_NAME_FIELD);
                    put("IndexName", INDEX_NAME_FIELD);
                    put("ContributorInsightsStatus", CONTRIBUTOR_INSIGHTS_STATUS_FIELD);
                }
            });

    private final String tableName;

    private final String indexName;

    private final String contributorInsightsStatus;

    private UpdateContributorInsightsResponse(BuilderImpl builder) {
        super(builder);
        this.tableName = builder.tableName;
        this.indexName = builder.indexName;
        this.contributorInsightsStatus = builder.contributorInsightsStatus;
    }

    /**
     * <p>
     * The name of the table.
     * </p>
     * 
     * @return The name of the table.
     */
    public final String tableName() {
        return tableName;
    }

    /**
     * <p>
     * The name of the global secondary index, if applicable.
     * </p>
     * 
     * @return The name of the global secondary index, if applicable.
     */
    public final String indexName() {
        return indexName;
    }

    /**
     * <p>
     * The status of contributor insights
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contributorInsightsStatus} will return {@link ContributorInsightsStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #contributorInsightsStatusAsString}.
     * </p>
     * 
     * @return The status of contributor insights
     * @see ContributorInsightsStatus
     */
    public final ContributorInsightsStatus contributorInsightsStatus() {
        return ContributorInsightsStatus.fromValue(contributorInsightsStatus);
    }

    /**
     * <p>
     * The status of contributor insights
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contributorInsightsStatus} will return {@link ContributorInsightsStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #contributorInsightsStatusAsString}.
     * </p>
     * 
     * @return The status of contributor insights
     * @see ContributorInsightsStatus
     */
    public final String contributorInsightsStatusAsString() {
        return contributorInsightsStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(indexName());
        hashCode = 31 * hashCode + Objects.hashCode(contributorInsightsStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateContributorInsightsResponse)) {
            return false;
        }
        UpdateContributorInsightsResponse other = (UpdateContributorInsightsResponse) obj;
        return Objects.equals(tableName(), other.tableName()) && Objects.equals(indexName(), other.indexName())
                && Objects.equals(contributorInsightsStatusAsString(), other.contributorInsightsStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateContributorInsightsResponse").add("TableName", tableName()).add("IndexName", indexName())
                .add("ContributorInsightsStatus", contributorInsightsStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "IndexName":
            return Optional.ofNullable(clazz.cast(indexName()));
        case "ContributorInsightsStatus":
            return Optional.ofNullable(clazz.cast(contributorInsightsStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateContributorInsightsResponse, T> g) {
        return obj -> g.apply((UpdateContributorInsightsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DynamoDbResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateContributorInsightsResponse> {
        /**
         * <p>
         * The name of the table.
         * </p>
         * 
         * @param tableName
         *        The name of the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * The name of the global secondary index, if applicable.
         * </p>
         * 
         * @param indexName
         *        The name of the global secondary index, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexName(String indexName);

        /**
         * <p>
         * The status of contributor insights
         * </p>
         * 
         * @param contributorInsightsStatus
         *        The status of contributor insights
         * @see ContributorInsightsStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContributorInsightsStatus
         */
        Builder contributorInsightsStatus(String contributorInsightsStatus);

        /**
         * <p>
         * The status of contributor insights
         * </p>
         * 
         * @param contributorInsightsStatus
         *        The status of contributor insights
         * @see ContributorInsightsStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContributorInsightsStatus
         */
        Builder contributorInsightsStatus(ContributorInsightsStatus contributorInsightsStatus);
    }

    static final class BuilderImpl extends DynamoDbResponse.BuilderImpl implements Builder {
        private String tableName;

        private String indexName;

        private String contributorInsightsStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateContributorInsightsResponse model) {
            super(model);
            tableName(model.tableName);
            indexName(model.indexName);
            contributorInsightsStatus(model.contributorInsightsStatus);
        }

        public final String getTableName() {
            return tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final String getIndexName() {
            return indexName;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final String getContributorInsightsStatus() {
            return contributorInsightsStatus;
        }

        public final void setContributorInsightsStatus(String contributorInsightsStatus) {
            this.contributorInsightsStatus = contributorInsightsStatus;
        }

        @Override
        public final Builder contributorInsightsStatus(String contributorInsightsStatus) {
            this.contributorInsightsStatus = contributorInsightsStatus;
            return this;
        }

        @Override
        public final Builder contributorInsightsStatus(ContributorInsightsStatus contributorInsightsStatus) {
            this.contributorInsightsStatus(contributorInsightsStatus == null ? null : contributorInsightsStatus.toString());
            return this;
        }

        @Override
        public UpdateContributorInsightsResponse build() {
            return new UpdateContributorInsightsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
