/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the auto scaling settings of the replica.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplicaAutoScalingDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<ReplicaAutoScalingDescription.Builder, ReplicaAutoScalingDescription> {
    private static final SdkField<String> REGION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegionName").getter(getter(ReplicaAutoScalingDescription::regionName))
            .setter(setter(Builder::regionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionName").build()).build();

    private static final SdkField<List<ReplicaGlobalSecondaryIndexAutoScalingDescription>> GLOBAL_SECONDARY_INDEXES_FIELD = SdkField
            .<List<ReplicaGlobalSecondaryIndexAutoScalingDescription>> builder(MarshallingType.LIST)
            .memberName("GlobalSecondaryIndexes")
            .getter(getter(ReplicaAutoScalingDescription::globalSecondaryIndexes))
            .setter(setter(Builder::globalSecondaryIndexes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalSecondaryIndexes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReplicaGlobalSecondaryIndexAutoScalingDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReplicaGlobalSecondaryIndexAutoScalingDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AutoScalingSettingsDescription> REPLICA_PROVISIONED_READ_CAPACITY_AUTO_SCALING_SETTINGS_FIELD = SdkField
            .<AutoScalingSettingsDescription> builder(MarshallingType.SDK_POJO)
            .memberName("ReplicaProvisionedReadCapacityAutoScalingSettings")
            .getter(getter(ReplicaAutoScalingDescription::replicaProvisionedReadCapacityAutoScalingSettings))
            .setter(setter(Builder::replicaProvisionedReadCapacityAutoScalingSettings))
            .constructor(AutoScalingSettingsDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ReplicaProvisionedReadCapacityAutoScalingSettings").build()).build();

    private static final SdkField<AutoScalingSettingsDescription> REPLICA_PROVISIONED_WRITE_CAPACITY_AUTO_SCALING_SETTINGS_FIELD = SdkField
            .<AutoScalingSettingsDescription> builder(MarshallingType.SDK_POJO)
            .memberName("ReplicaProvisionedWriteCapacityAutoScalingSettings")
            .getter(getter(ReplicaAutoScalingDescription::replicaProvisionedWriteCapacityAutoScalingSettings))
            .setter(setter(Builder::replicaProvisionedWriteCapacityAutoScalingSettings))
            .constructor(AutoScalingSettingsDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ReplicaProvisionedWriteCapacityAutoScalingSettings").build()).build();

    private static final SdkField<String> REPLICA_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicaStatus").getter(getter(ReplicaAutoScalingDescription::replicaStatusAsString))
            .setter(setter(Builder::replicaStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_NAME_FIELD,
            GLOBAL_SECONDARY_INDEXES_FIELD, REPLICA_PROVISIONED_READ_CAPACITY_AUTO_SCALING_SETTINGS_FIELD,
            REPLICA_PROVISIONED_WRITE_CAPACITY_AUTO_SCALING_SETTINGS_FIELD, REPLICA_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String regionName;

    private final List<ReplicaGlobalSecondaryIndexAutoScalingDescription> globalSecondaryIndexes;

    private final AutoScalingSettingsDescription replicaProvisionedReadCapacityAutoScalingSettings;

    private final AutoScalingSettingsDescription replicaProvisionedWriteCapacityAutoScalingSettings;

    private final String replicaStatus;

    private ReplicaAutoScalingDescription(BuilderImpl builder) {
        this.regionName = builder.regionName;
        this.globalSecondaryIndexes = builder.globalSecondaryIndexes;
        this.replicaProvisionedReadCapacityAutoScalingSettings = builder.replicaProvisionedReadCapacityAutoScalingSettings;
        this.replicaProvisionedWriteCapacityAutoScalingSettings = builder.replicaProvisionedWriteCapacityAutoScalingSettings;
        this.replicaStatus = builder.replicaStatus;
    }

    /**
     * <p>
     * The Region where the replica exists.
     * </p>
     * 
     * @return The Region where the replica exists.
     */
    public final String regionName() {
        return regionName;
    }

    /**
     * For responses, this returns true if the service returned a value for the GlobalSecondaryIndexes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasGlobalSecondaryIndexes() {
        return globalSecondaryIndexes != null && !(globalSecondaryIndexes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Replica-specific global secondary index auto scaling settings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGlobalSecondaryIndexes} method.
     * </p>
     * 
     * @return Replica-specific global secondary index auto scaling settings.
     */
    public final List<ReplicaGlobalSecondaryIndexAutoScalingDescription> globalSecondaryIndexes() {
        return globalSecondaryIndexes;
    }

    /**
     * Returns the value of the ReplicaProvisionedReadCapacityAutoScalingSettings property for this object.
     * 
     * @return The value of the ReplicaProvisionedReadCapacityAutoScalingSettings property for this object.
     */
    public final AutoScalingSettingsDescription replicaProvisionedReadCapacityAutoScalingSettings() {
        return replicaProvisionedReadCapacityAutoScalingSettings;
    }

    /**
     * Returns the value of the ReplicaProvisionedWriteCapacityAutoScalingSettings property for this object.
     * 
     * @return The value of the ReplicaProvisionedWriteCapacityAutoScalingSettings property for this object.
     */
    public final AutoScalingSettingsDescription replicaProvisionedWriteCapacityAutoScalingSettings() {
        return replicaProvisionedWriteCapacityAutoScalingSettings;
    }

    /**
     * <p>
     * The current state of the replica:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATING</code> - The replica is being created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATING</code> - The replica is being updated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code> - The replica is being deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code> - The replica is ready for use.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #replicaStatus}
     * will return {@link ReplicaStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #replicaStatusAsString}.
     * </p>
     * 
     * @return The current state of the replica:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATING</code> - The replica is being created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATING</code> - The replica is being updated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code> - The replica is being deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> - The replica is ready for use.
     *         </p>
     *         </li>
     * @see ReplicaStatus
     */
    public final ReplicaStatus replicaStatus() {
        return ReplicaStatus.fromValue(replicaStatus);
    }

    /**
     * <p>
     * The current state of the replica:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATING</code> - The replica is being created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATING</code> - The replica is being updated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code> - The replica is being deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code> - The replica is ready for use.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #replicaStatus}
     * will return {@link ReplicaStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #replicaStatusAsString}.
     * </p>
     * 
     * @return The current state of the replica:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATING</code> - The replica is being created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATING</code> - The replica is being updated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code> - The replica is being deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> - The replica is ready for use.
     *         </p>
     *         </li>
     * @see ReplicaStatus
     */
    public final String replicaStatusAsString() {
        return replicaStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(regionName());
        hashCode = 31 * hashCode + Objects.hashCode(hasGlobalSecondaryIndexes() ? globalSecondaryIndexes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(replicaProvisionedReadCapacityAutoScalingSettings());
        hashCode = 31 * hashCode + Objects.hashCode(replicaProvisionedWriteCapacityAutoScalingSettings());
        hashCode = 31 * hashCode + Objects.hashCode(replicaStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicaAutoScalingDescription)) {
            return false;
        }
        ReplicaAutoScalingDescription other = (ReplicaAutoScalingDescription) obj;
        return Objects.equals(regionName(), other.regionName())
                && hasGlobalSecondaryIndexes() == other.hasGlobalSecondaryIndexes()
                && Objects.equals(globalSecondaryIndexes(), other.globalSecondaryIndexes())
                && Objects.equals(replicaProvisionedReadCapacityAutoScalingSettings(),
                        other.replicaProvisionedReadCapacityAutoScalingSettings())
                && Objects.equals(replicaProvisionedWriteCapacityAutoScalingSettings(),
                        other.replicaProvisionedWriteCapacityAutoScalingSettings())
                && Objects.equals(replicaStatusAsString(), other.replicaStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReplicaAutoScalingDescription").add("RegionName", regionName())
                .add("GlobalSecondaryIndexes", hasGlobalSecondaryIndexes() ? globalSecondaryIndexes() : null)
                .add("ReplicaProvisionedReadCapacityAutoScalingSettings", replicaProvisionedReadCapacityAutoScalingSettings())
                .add("ReplicaProvisionedWriteCapacityAutoScalingSettings", replicaProvisionedWriteCapacityAutoScalingSettings())
                .add("ReplicaStatus", replicaStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RegionName":
            return Optional.ofNullable(clazz.cast(regionName()));
        case "GlobalSecondaryIndexes":
            return Optional.ofNullable(clazz.cast(globalSecondaryIndexes()));
        case "ReplicaProvisionedReadCapacityAutoScalingSettings":
            return Optional.ofNullable(clazz.cast(replicaProvisionedReadCapacityAutoScalingSettings()));
        case "ReplicaProvisionedWriteCapacityAutoScalingSettings":
            return Optional.ofNullable(clazz.cast(replicaProvisionedWriteCapacityAutoScalingSettings()));
        case "ReplicaStatus":
            return Optional.ofNullable(clazz.cast(replicaStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplicaAutoScalingDescription, T> g) {
        return obj -> g.apply((ReplicaAutoScalingDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReplicaAutoScalingDescription> {
        /**
         * <p>
         * The Region where the replica exists.
         * </p>
         * 
         * @param regionName
         *        The Region where the replica exists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionName(String regionName);

        /**
         * <p>
         * Replica-specific global secondary index auto scaling settings.
         * </p>
         * 
         * @param globalSecondaryIndexes
         *        Replica-specific global secondary index auto scaling settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalSecondaryIndexes(Collection<ReplicaGlobalSecondaryIndexAutoScalingDescription> globalSecondaryIndexes);

        /**
         * <p>
         * Replica-specific global secondary index auto scaling settings.
         * </p>
         * 
         * @param globalSecondaryIndexes
         *        Replica-specific global secondary index auto scaling settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalSecondaryIndexes(ReplicaGlobalSecondaryIndexAutoScalingDescription... globalSecondaryIndexes);

        /**
         * <p>
         * Replica-specific global secondary index auto scaling settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link List
         * <ReplicaGlobalSecondaryIndexAutoScalingDescription>.Builder} avoiding the need to create one manually via
         * {@link List<ReplicaGlobalSecondaryIndexAutoScalingDescription>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List
         * <ReplicaGlobalSecondaryIndexAutoScalingDescription>.Builder#build()} is called immediately and its result is
         * passed to {@link #globalSecondaryIndexes(List<ReplicaGlobalSecondaryIndexAutoScalingDescription>)}.
         * 
         * @param globalSecondaryIndexes
         *        a consumer that will call methods on {@link List
         *        <ReplicaGlobalSecondaryIndexAutoScalingDescription>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #globalSecondaryIndexes(List<ReplicaGlobalSecondaryIndexAutoScalingDescription>)
         */
        Builder globalSecondaryIndexes(
                Consumer<ReplicaGlobalSecondaryIndexAutoScalingDescription.Builder>... globalSecondaryIndexes);

        /**
         * Sets the value of the ReplicaProvisionedReadCapacityAutoScalingSettings property for this object.
         *
         * @param replicaProvisionedReadCapacityAutoScalingSettings
         *        The new value for the ReplicaProvisionedReadCapacityAutoScalingSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicaProvisionedReadCapacityAutoScalingSettings(
                AutoScalingSettingsDescription replicaProvisionedReadCapacityAutoScalingSettings);

        /**
         * Sets the value of the ReplicaProvisionedReadCapacityAutoScalingSettings property for this object.
         *
         * This is a convenience method that creates an instance of the {@link AutoScalingSettingsDescription.Builder}
         * avoiding the need to create one manually via {@link AutoScalingSettingsDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link AutoScalingSettingsDescription.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #replicaProvisionedReadCapacityAutoScalingSettings(AutoScalingSettingsDescription)}.
         * 
         * @param replicaProvisionedReadCapacityAutoScalingSettings
         *        a consumer that will call methods on {@link AutoScalingSettingsDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicaProvisionedReadCapacityAutoScalingSettings(AutoScalingSettingsDescription)
         */
        default Builder replicaProvisionedReadCapacityAutoScalingSettings(
                Consumer<AutoScalingSettingsDescription.Builder> replicaProvisionedReadCapacityAutoScalingSettings) {
            return replicaProvisionedReadCapacityAutoScalingSettings(AutoScalingSettingsDescription.builder()
                    .applyMutation(replicaProvisionedReadCapacityAutoScalingSettings).build());
        }

        /**
         * Sets the value of the ReplicaProvisionedWriteCapacityAutoScalingSettings property for this object.
         *
         * @param replicaProvisionedWriteCapacityAutoScalingSettings
         *        The new value for the ReplicaProvisionedWriteCapacityAutoScalingSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicaProvisionedWriteCapacityAutoScalingSettings(
                AutoScalingSettingsDescription replicaProvisionedWriteCapacityAutoScalingSettings);

        /**
         * Sets the value of the ReplicaProvisionedWriteCapacityAutoScalingSettings property for this object.
         *
         * This is a convenience method that creates an instance of the {@link AutoScalingSettingsDescription.Builder}
         * avoiding the need to create one manually via {@link AutoScalingSettingsDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link AutoScalingSettingsDescription.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #replicaProvisionedWriteCapacityAutoScalingSettings(AutoScalingSettingsDescription)}.
         * 
         * @param replicaProvisionedWriteCapacityAutoScalingSettings
         *        a consumer that will call methods on {@link AutoScalingSettingsDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicaProvisionedWriteCapacityAutoScalingSettings(AutoScalingSettingsDescription)
         */
        default Builder replicaProvisionedWriteCapacityAutoScalingSettings(
                Consumer<AutoScalingSettingsDescription.Builder> replicaProvisionedWriteCapacityAutoScalingSettings) {
            return replicaProvisionedWriteCapacityAutoScalingSettings(AutoScalingSettingsDescription.builder()
                    .applyMutation(replicaProvisionedWriteCapacityAutoScalingSettings).build());
        }

        /**
         * <p>
         * The current state of the replica:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATING</code> - The replica is being created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATING</code> - The replica is being updated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code> - The replica is being deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code> - The replica is ready for use.
         * </p>
         * </li>
         * </ul>
         * 
         * @param replicaStatus
         *        The current state of the replica:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATING</code> - The replica is being created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATING</code> - The replica is being updated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code> - The replica is being deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> - The replica is ready for use.
         *        </p>
         *        </li>
         * @see ReplicaStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicaStatus
         */
        Builder replicaStatus(String replicaStatus);

        /**
         * <p>
         * The current state of the replica:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATING</code> - The replica is being created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATING</code> - The replica is being updated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code> - The replica is being deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code> - The replica is ready for use.
         * </p>
         * </li>
         * </ul>
         * 
         * @param replicaStatus
         *        The current state of the replica:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATING</code> - The replica is being created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATING</code> - The replica is being updated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code> - The replica is being deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> - The replica is ready for use.
         *        </p>
         *        </li>
         * @see ReplicaStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicaStatus
         */
        Builder replicaStatus(ReplicaStatus replicaStatus);
    }

    static final class BuilderImpl implements Builder {
        private String regionName;

        private List<ReplicaGlobalSecondaryIndexAutoScalingDescription> globalSecondaryIndexes = DefaultSdkAutoConstructList
                .getInstance();

        private AutoScalingSettingsDescription replicaProvisionedReadCapacityAutoScalingSettings;

        private AutoScalingSettingsDescription replicaProvisionedWriteCapacityAutoScalingSettings;

        private String replicaStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicaAutoScalingDescription model) {
            regionName(model.regionName);
            globalSecondaryIndexes(model.globalSecondaryIndexes);
            replicaProvisionedReadCapacityAutoScalingSettings(model.replicaProvisionedReadCapacityAutoScalingSettings);
            replicaProvisionedWriteCapacityAutoScalingSettings(model.replicaProvisionedWriteCapacityAutoScalingSettings);
            replicaStatus(model.replicaStatus);
        }

        public final String getRegionName() {
            return regionName;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        @Override
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public final List<ReplicaGlobalSecondaryIndexAutoScalingDescription.Builder> getGlobalSecondaryIndexes() {
            List<ReplicaGlobalSecondaryIndexAutoScalingDescription.Builder> result = ReplicaGlobalSecondaryIndexAutoScalingDescriptionListCopier
                    .copyToBuilder(this.globalSecondaryIndexes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGlobalSecondaryIndexes(
                Collection<ReplicaGlobalSecondaryIndexAutoScalingDescription.BuilderImpl> globalSecondaryIndexes) {
            this.globalSecondaryIndexes = ReplicaGlobalSecondaryIndexAutoScalingDescriptionListCopier
                    .copyFromBuilder(globalSecondaryIndexes);
        }

        @Override
        public final Builder globalSecondaryIndexes(
                Collection<ReplicaGlobalSecondaryIndexAutoScalingDescription> globalSecondaryIndexes) {
            this.globalSecondaryIndexes = ReplicaGlobalSecondaryIndexAutoScalingDescriptionListCopier
                    .copy(globalSecondaryIndexes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalSecondaryIndexes(ReplicaGlobalSecondaryIndexAutoScalingDescription... globalSecondaryIndexes) {
            globalSecondaryIndexes(Arrays.asList(globalSecondaryIndexes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalSecondaryIndexes(
                Consumer<ReplicaGlobalSecondaryIndexAutoScalingDescription.Builder>... globalSecondaryIndexes) {
            globalSecondaryIndexes(Stream.of(globalSecondaryIndexes)
                    .map(c -> ReplicaGlobalSecondaryIndexAutoScalingDescription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final AutoScalingSettingsDescription.Builder getReplicaProvisionedReadCapacityAutoScalingSettings() {
            return replicaProvisionedReadCapacityAutoScalingSettings != null ? replicaProvisionedReadCapacityAutoScalingSettings
                    .toBuilder() : null;
        }

        public final void setReplicaProvisionedReadCapacityAutoScalingSettings(
                AutoScalingSettingsDescription.BuilderImpl replicaProvisionedReadCapacityAutoScalingSettings) {
            this.replicaProvisionedReadCapacityAutoScalingSettings = replicaProvisionedReadCapacityAutoScalingSettings != null ? replicaProvisionedReadCapacityAutoScalingSettings
                    .build() : null;
        }

        @Override
        public final Builder replicaProvisionedReadCapacityAutoScalingSettings(
                AutoScalingSettingsDescription replicaProvisionedReadCapacityAutoScalingSettings) {
            this.replicaProvisionedReadCapacityAutoScalingSettings = replicaProvisionedReadCapacityAutoScalingSettings;
            return this;
        }

        public final AutoScalingSettingsDescription.Builder getReplicaProvisionedWriteCapacityAutoScalingSettings() {
            return replicaProvisionedWriteCapacityAutoScalingSettings != null ? replicaProvisionedWriteCapacityAutoScalingSettings
                    .toBuilder() : null;
        }

        public final void setReplicaProvisionedWriteCapacityAutoScalingSettings(
                AutoScalingSettingsDescription.BuilderImpl replicaProvisionedWriteCapacityAutoScalingSettings) {
            this.replicaProvisionedWriteCapacityAutoScalingSettings = replicaProvisionedWriteCapacityAutoScalingSettings != null ? replicaProvisionedWriteCapacityAutoScalingSettings
                    .build() : null;
        }

        @Override
        public final Builder replicaProvisionedWriteCapacityAutoScalingSettings(
                AutoScalingSettingsDescription replicaProvisionedWriteCapacityAutoScalingSettings) {
            this.replicaProvisionedWriteCapacityAutoScalingSettings = replicaProvisionedWriteCapacityAutoScalingSettings;
            return this;
        }

        public final String getReplicaStatus() {
            return replicaStatus;
        }

        public final void setReplicaStatus(String replicaStatus) {
            this.replicaStatus = replicaStatus;
        }

        @Override
        public final Builder replicaStatus(String replicaStatus) {
            this.replicaStatus = replicaStatus;
            return this;
        }

        @Override
        public final Builder replicaStatus(ReplicaStatus replicaStatus) {
            this.replicaStatus(replicaStatus == null ? null : replicaStatus.toString());
            return this;
        }

        @Override
        public ReplicaAutoScalingDescription build() {
            return new ReplicaAutoScalingDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
