/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the settings used to enable point in time recovery.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PointInTimeRecoverySpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<PointInTimeRecoverySpecification.Builder, PointInTimeRecoverySpecification> {
    private static final SdkField<Boolean> POINT_IN_TIME_RECOVERY_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PointInTimeRecoveryEnabled")
            .getter(getter(PointInTimeRecoverySpecification::pointInTimeRecoveryEnabled))
            .setter(setter(Builder::pointInTimeRecoveryEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PointInTimeRecoveryEnabled").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(POINT_IN_TIME_RECOVERY_ENABLED_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean pointInTimeRecoveryEnabled;

    private PointInTimeRecoverySpecification(BuilderImpl builder) {
        this.pointInTimeRecoveryEnabled = builder.pointInTimeRecoveryEnabled;
    }

    /**
     * <p>
     * Indicates whether point in time recovery is enabled (true) or disabled (false) on the table.
     * </p>
     * 
     * @return Indicates whether point in time recovery is enabled (true) or disabled (false) on the table.
     */
    public Boolean pointInTimeRecoveryEnabled() {
        return pointInTimeRecoveryEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pointInTimeRecoveryEnabled());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PointInTimeRecoverySpecification)) {
            return false;
        }
        PointInTimeRecoverySpecification other = (PointInTimeRecoverySpecification) obj;
        return Objects.equals(pointInTimeRecoveryEnabled(), other.pointInTimeRecoveryEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PointInTimeRecoverySpecification")
                .add("PointInTimeRecoveryEnabled", pointInTimeRecoveryEnabled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PointInTimeRecoveryEnabled":
            return Optional.ofNullable(clazz.cast(pointInTimeRecoveryEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PointInTimeRecoverySpecification, T> g) {
        return obj -> g.apply((PointInTimeRecoverySpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PointInTimeRecoverySpecification> {
        /**
         * <p>
         * Indicates whether point in time recovery is enabled (true) or disabled (false) on the table.
         * </p>
         * 
         * @param pointInTimeRecoveryEnabled
         *        Indicates whether point in time recovery is enabled (true) or disabled (false) on the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pointInTimeRecoveryEnabled(Boolean pointInTimeRecoveryEnabled);
    }

    static final class BuilderImpl implements Builder {
        private Boolean pointInTimeRecoveryEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(PointInTimeRecoverySpecification model) {
            pointInTimeRecoveryEnabled(model.pointInTimeRecoveryEnabled);
        }

        public final Boolean getPointInTimeRecoveryEnabled() {
            return pointInTimeRecoveryEnabled;
        }

        @Override
        public final Builder pointInTimeRecoveryEnabled(Boolean pointInTimeRecoveryEnabled) {
            this.pointInTimeRecoveryEnabled = pointInTimeRecoveryEnabled;
            return this;
        }

        public final void setPointInTimeRecoveryEnabled(Boolean pointInTimeRecoveryEnabled) {
            this.pointInTimeRecoveryEnabled = pointInTimeRecoveryEnabled;
        }

        @Override
        public PointInTimeRecoverySpecification build() {
            return new PointInTimeRecoverySpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
