/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughputOverride;
import software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndex;
import software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndexListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateReplicationGroupMemberAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CreateReplicationGroupMemberAction> {
    private static final SdkField<String> REGION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegionName").getter(CreateReplicationGroupMemberAction.getter(CreateReplicationGroupMemberAction::regionName)).setter(CreateReplicationGroupMemberAction.setter(Builder::regionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionName").build()}).build();
    private static final SdkField<String> KMS_MASTER_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KMSMasterKeyId").getter(CreateReplicationGroupMemberAction.getter(CreateReplicationGroupMemberAction::kmsMasterKeyId)).setter(CreateReplicationGroupMemberAction.setter(Builder::kmsMasterKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSMasterKeyId").build()}).build();
    private static final SdkField<ProvisionedThroughputOverride> PROVISIONED_THROUGHPUT_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProvisionedThroughputOverride").getter(CreateReplicationGroupMemberAction.getter(CreateReplicationGroupMemberAction::provisionedThroughputOverride)).setter(CreateReplicationGroupMemberAction.setter(Builder::provisionedThroughputOverride)).constructor(ProvisionedThroughputOverride::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedThroughputOverride").build()}).build();
    private static final SdkField<List<ReplicaGlobalSecondaryIndex>> GLOBAL_SECONDARY_INDEXES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GlobalSecondaryIndexes").getter(CreateReplicationGroupMemberAction.getter(CreateReplicationGroupMemberAction::globalSecondaryIndexes)).setter(CreateReplicationGroupMemberAction.setter(Builder::globalSecondaryIndexes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalSecondaryIndexes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReplicaGlobalSecondaryIndex::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_NAME_FIELD, KMS_MASTER_KEY_ID_FIELD, PROVISIONED_THROUGHPUT_OVERRIDE_FIELD, GLOBAL_SECONDARY_INDEXES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String regionName;
    private final String kmsMasterKeyId;
    private final ProvisionedThroughputOverride provisionedThroughputOverride;
    private final List<ReplicaGlobalSecondaryIndex> globalSecondaryIndexes;

    private CreateReplicationGroupMemberAction(BuilderImpl builder) {
        this.regionName = builder.regionName;
        this.kmsMasterKeyId = builder.kmsMasterKeyId;
        this.provisionedThroughputOverride = builder.provisionedThroughputOverride;
        this.globalSecondaryIndexes = builder.globalSecondaryIndexes;
    }

    public String regionName() {
        return this.regionName;
    }

    public String kmsMasterKeyId() {
        return this.kmsMasterKeyId;
    }

    public ProvisionedThroughputOverride provisionedThroughputOverride() {
        return this.provisionedThroughputOverride;
    }

    public boolean hasGlobalSecondaryIndexes() {
        return this.globalSecondaryIndexes != null && !(this.globalSecondaryIndexes instanceof SdkAutoConstructList);
    }

    public List<ReplicaGlobalSecondaryIndex> globalSecondaryIndexes() {
        return this.globalSecondaryIndexes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.regionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsMasterKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedThroughputOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.globalSecondaryIndexes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReplicationGroupMemberAction)) {
            return false;
        }
        CreateReplicationGroupMemberAction other = (CreateReplicationGroupMemberAction)obj;
        return Objects.equals(this.regionName(), other.regionName()) && Objects.equals(this.kmsMasterKeyId(), other.kmsMasterKeyId()) && Objects.equals(this.provisionedThroughputOverride(), other.provisionedThroughputOverride()) && Objects.equals(this.globalSecondaryIndexes(), other.globalSecondaryIndexes());
    }

    public String toString() {
        return ToString.builder((String)"CreateReplicationGroupMemberAction").add("RegionName", (Object)this.regionName()).add("KMSMasterKeyId", (Object)this.kmsMasterKeyId()).add("ProvisionedThroughputOverride", (Object)this.provisionedThroughputOverride()).add("GlobalSecondaryIndexes", this.globalSecondaryIndexes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RegionName": {
                return Optional.ofNullable(clazz.cast(this.regionName()));
            }
            case "KMSMasterKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsMasterKeyId()));
            }
            case "ProvisionedThroughputOverride": {
                return Optional.ofNullable(clazz.cast(this.provisionedThroughputOverride()));
            }
            case "GlobalSecondaryIndexes": {
                return Optional.ofNullable(clazz.cast(this.globalSecondaryIndexes()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateReplicationGroupMemberAction, T> g) {
        return obj -> g.apply((CreateReplicationGroupMemberAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String regionName;
        private String kmsMasterKeyId;
        private ProvisionedThroughputOverride provisionedThroughputOverride;
        private List<ReplicaGlobalSecondaryIndex> globalSecondaryIndexes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReplicationGroupMemberAction model) {
            this.regionName(model.regionName);
            this.kmsMasterKeyId(model.kmsMasterKeyId);
            this.provisionedThroughputOverride(model.provisionedThroughputOverride);
            this.globalSecondaryIndexes(model.globalSecondaryIndexes);
        }

        public final String getRegionName() {
            return this.regionName;
        }

        @Override
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        public final String getKmsMasterKeyId() {
            return this.kmsMasterKeyId;
        }

        @Override
        public final Builder kmsMasterKeyId(String kmsMasterKeyId) {
            this.kmsMasterKeyId = kmsMasterKeyId;
            return this;
        }

        public final void setKmsMasterKeyId(String kmsMasterKeyId) {
            this.kmsMasterKeyId = kmsMasterKeyId;
        }

        public final ProvisionedThroughputOverride.Builder getProvisionedThroughputOverride() {
            return this.provisionedThroughputOverride != null ? this.provisionedThroughputOverride.toBuilder() : null;
        }

        @Override
        public final Builder provisionedThroughputOverride(ProvisionedThroughputOverride provisionedThroughputOverride) {
            this.provisionedThroughputOverride = provisionedThroughputOverride;
            return this;
        }

        public final void setProvisionedThroughputOverride(ProvisionedThroughputOverride.BuilderImpl provisionedThroughputOverride) {
            this.provisionedThroughputOverride = provisionedThroughputOverride != null ? provisionedThroughputOverride.build() : null;
        }

        public final Collection<ReplicaGlobalSecondaryIndex.Builder> getGlobalSecondaryIndexes() {
            return this.globalSecondaryIndexes != null ? (Collection)this.globalSecondaryIndexes.stream().map(ReplicaGlobalSecondaryIndex::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder globalSecondaryIndexes(Collection<ReplicaGlobalSecondaryIndex> globalSecondaryIndexes) {
            this.globalSecondaryIndexes = ReplicaGlobalSecondaryIndexListCopier.copy(globalSecondaryIndexes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalSecondaryIndexes(ReplicaGlobalSecondaryIndex ... globalSecondaryIndexes) {
            this.globalSecondaryIndexes(Arrays.asList(globalSecondaryIndexes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalSecondaryIndexes(Consumer<ReplicaGlobalSecondaryIndex.Builder> ... globalSecondaryIndexes) {
            this.globalSecondaryIndexes(Stream.of(globalSecondaryIndexes).map(c -> (ReplicaGlobalSecondaryIndex)((ReplicaGlobalSecondaryIndex.Builder)ReplicaGlobalSecondaryIndex.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGlobalSecondaryIndexes(Collection<ReplicaGlobalSecondaryIndex.BuilderImpl> globalSecondaryIndexes) {
            this.globalSecondaryIndexes = ReplicaGlobalSecondaryIndexListCopier.copyFromBuilder(globalSecondaryIndexes);
        }

        public CreateReplicationGroupMemberAction build() {
            return new CreateReplicationGroupMemberAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CreateReplicationGroupMemberAction> {
        public Builder regionName(String var1);

        public Builder kmsMasterKeyId(String var1);

        public Builder provisionedThroughputOverride(ProvisionedThroughputOverride var1);

        default public Builder provisionedThroughputOverride(Consumer<ProvisionedThroughputOverride.Builder> provisionedThroughputOverride) {
            return this.provisionedThroughputOverride((ProvisionedThroughputOverride)((ProvisionedThroughputOverride.Builder)ProvisionedThroughputOverride.builder().applyMutation(provisionedThroughputOverride)).build());
        }

        public Builder globalSecondaryIndexes(Collection<ReplicaGlobalSecondaryIndex> var1);

        public Builder globalSecondaryIndexes(ReplicaGlobalSecondaryIndex ... var1);

        public Builder globalSecondaryIndexes(Consumer<ReplicaGlobalSecondaryIndex.Builder> ... var1);
    }
}

