/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexInfo;
import software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexesCopier;
import software.amazon.awssdk.services.dynamodb.model.LocalSecondaryIndexInfo;
import software.amazon.awssdk.services.dynamodb.model.LocalSecondaryIndexesCopier;
import software.amazon.awssdk.services.dynamodb.model.SSEDescription;
import software.amazon.awssdk.services.dynamodb.model.StreamSpecification;
import software.amazon.awssdk.services.dynamodb.model.TimeToLiveDescription;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SourceTableFeatureDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SourceTableFeatureDetails> {
    private static final SdkField<List<LocalSecondaryIndexInfo>> LOCAL_SECONDARY_INDEXES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(SourceTableFeatureDetails.getter(SourceTableFeatureDetails::localSecondaryIndexes)).setter(SourceTableFeatureDetails.setter(Builder::localSecondaryIndexes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalSecondaryIndexes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LocalSecondaryIndexInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<GlobalSecondaryIndexInfo>> GLOBAL_SECONDARY_INDEXES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(SourceTableFeatureDetails.getter(SourceTableFeatureDetails::globalSecondaryIndexes)).setter(SourceTableFeatureDetails.setter(Builder::globalSecondaryIndexes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalSecondaryIndexes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GlobalSecondaryIndexInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<StreamSpecification> STREAM_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(SourceTableFeatureDetails.getter(SourceTableFeatureDetails::streamDescription)).setter(SourceTableFeatureDetails.setter(Builder::streamDescription)).constructor(StreamSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamDescription").build()}).build();
    private static final SdkField<TimeToLiveDescription> TIME_TO_LIVE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(SourceTableFeatureDetails.getter(SourceTableFeatureDetails::timeToLiveDescription)).setter(SourceTableFeatureDetails.setter(Builder::timeToLiveDescription)).constructor(TimeToLiveDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeToLiveDescription").build()}).build();
    private static final SdkField<SSEDescription> SSE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(SourceTableFeatureDetails.getter(SourceTableFeatureDetails::sseDescription)).setter(SourceTableFeatureDetails.setter(Builder::sseDescription)).constructor(SSEDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SSEDescription").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCAL_SECONDARY_INDEXES_FIELD, GLOBAL_SECONDARY_INDEXES_FIELD, STREAM_DESCRIPTION_FIELD, TIME_TO_LIVE_DESCRIPTION_FIELD, SSE_DESCRIPTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<LocalSecondaryIndexInfo> localSecondaryIndexes;
    private final List<GlobalSecondaryIndexInfo> globalSecondaryIndexes;
    private final StreamSpecification streamDescription;
    private final TimeToLiveDescription timeToLiveDescription;
    private final SSEDescription sseDescription;

    private SourceTableFeatureDetails(BuilderImpl builder) {
        this.localSecondaryIndexes = builder.localSecondaryIndexes;
        this.globalSecondaryIndexes = builder.globalSecondaryIndexes;
        this.streamDescription = builder.streamDescription;
        this.timeToLiveDescription = builder.timeToLiveDescription;
        this.sseDescription = builder.sseDescription;
    }

    public boolean hasLocalSecondaryIndexes() {
        return this.localSecondaryIndexes != null && !(this.localSecondaryIndexes instanceof SdkAutoConstructList);
    }

    public List<LocalSecondaryIndexInfo> localSecondaryIndexes() {
        return this.localSecondaryIndexes;
    }

    public boolean hasGlobalSecondaryIndexes() {
        return this.globalSecondaryIndexes != null && !(this.globalSecondaryIndexes instanceof SdkAutoConstructList);
    }

    public List<GlobalSecondaryIndexInfo> globalSecondaryIndexes() {
        return this.globalSecondaryIndexes;
    }

    public StreamSpecification streamDescription() {
        return this.streamDescription;
    }

    public TimeToLiveDescription timeToLiveDescription() {
        return this.timeToLiveDescription;
    }

    public SSEDescription sseDescription() {
        return this.sseDescription;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.localSecondaryIndexes());
        hashCode = 31 * hashCode + Objects.hashCode(this.globalSecondaryIndexes());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeToLiveDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.sseDescription());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceTableFeatureDetails)) {
            return false;
        }
        SourceTableFeatureDetails other = (SourceTableFeatureDetails)obj;
        return Objects.equals(this.localSecondaryIndexes(), other.localSecondaryIndexes()) && Objects.equals(this.globalSecondaryIndexes(), other.globalSecondaryIndexes()) && Objects.equals(this.streamDescription(), other.streamDescription()) && Objects.equals(this.timeToLiveDescription(), other.timeToLiveDescription()) && Objects.equals(this.sseDescription(), other.sseDescription());
    }

    public String toString() {
        return ToString.builder((String)"SourceTableFeatureDetails").add("LocalSecondaryIndexes", this.localSecondaryIndexes()).add("GlobalSecondaryIndexes", this.globalSecondaryIndexes()).add("StreamDescription", (Object)this.streamDescription()).add("TimeToLiveDescription", (Object)this.timeToLiveDescription()).add("SSEDescription", (Object)this.sseDescription()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LocalSecondaryIndexes": {
                return Optional.ofNullable(clazz.cast(this.localSecondaryIndexes()));
            }
            case "GlobalSecondaryIndexes": {
                return Optional.ofNullable(clazz.cast(this.globalSecondaryIndexes()));
            }
            case "StreamDescription": {
                return Optional.ofNullable(clazz.cast(this.streamDescription()));
            }
            case "TimeToLiveDescription": {
                return Optional.ofNullable(clazz.cast(this.timeToLiveDescription()));
            }
            case "SSEDescription": {
                return Optional.ofNullable(clazz.cast(this.sseDescription()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SourceTableFeatureDetails, T> g) {
        return obj -> g.apply((SourceTableFeatureDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<LocalSecondaryIndexInfo> localSecondaryIndexes = DefaultSdkAutoConstructList.getInstance();
        private List<GlobalSecondaryIndexInfo> globalSecondaryIndexes = DefaultSdkAutoConstructList.getInstance();
        private StreamSpecification streamDescription;
        private TimeToLiveDescription timeToLiveDescription;
        private SSEDescription sseDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceTableFeatureDetails model) {
            this.localSecondaryIndexes(model.localSecondaryIndexes);
            this.globalSecondaryIndexes(model.globalSecondaryIndexes);
            this.streamDescription(model.streamDescription);
            this.timeToLiveDescription(model.timeToLiveDescription);
            this.sseDescription(model.sseDescription);
        }

        public final Collection<LocalSecondaryIndexInfo.Builder> getLocalSecondaryIndexes() {
            return this.localSecondaryIndexes != null ? (Collection)this.localSecondaryIndexes.stream().map(LocalSecondaryIndexInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder localSecondaryIndexes(Collection<LocalSecondaryIndexInfo> localSecondaryIndexes) {
            this.localSecondaryIndexes = LocalSecondaryIndexesCopier.copy(localSecondaryIndexes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localSecondaryIndexes(LocalSecondaryIndexInfo ... localSecondaryIndexes) {
            this.localSecondaryIndexes(Arrays.asList(localSecondaryIndexes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localSecondaryIndexes(Consumer<LocalSecondaryIndexInfo.Builder> ... localSecondaryIndexes) {
            this.localSecondaryIndexes(Stream.of(localSecondaryIndexes).map(c -> (LocalSecondaryIndexInfo)((LocalSecondaryIndexInfo.Builder)LocalSecondaryIndexInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLocalSecondaryIndexes(Collection<LocalSecondaryIndexInfo.BuilderImpl> localSecondaryIndexes) {
            this.localSecondaryIndexes = LocalSecondaryIndexesCopier.copyFromBuilder(localSecondaryIndexes);
        }

        public final Collection<GlobalSecondaryIndexInfo.Builder> getGlobalSecondaryIndexes() {
            return this.globalSecondaryIndexes != null ? (Collection)this.globalSecondaryIndexes.stream().map(GlobalSecondaryIndexInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder globalSecondaryIndexes(Collection<GlobalSecondaryIndexInfo> globalSecondaryIndexes) {
            this.globalSecondaryIndexes = GlobalSecondaryIndexesCopier.copy(globalSecondaryIndexes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalSecondaryIndexes(GlobalSecondaryIndexInfo ... globalSecondaryIndexes) {
            this.globalSecondaryIndexes(Arrays.asList(globalSecondaryIndexes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalSecondaryIndexes(Consumer<GlobalSecondaryIndexInfo.Builder> ... globalSecondaryIndexes) {
            this.globalSecondaryIndexes(Stream.of(globalSecondaryIndexes).map(c -> (GlobalSecondaryIndexInfo)((GlobalSecondaryIndexInfo.Builder)GlobalSecondaryIndexInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGlobalSecondaryIndexes(Collection<GlobalSecondaryIndexInfo.BuilderImpl> globalSecondaryIndexes) {
            this.globalSecondaryIndexes = GlobalSecondaryIndexesCopier.copyFromBuilder(globalSecondaryIndexes);
        }

        public final StreamSpecification.Builder getStreamDescription() {
            return this.streamDescription != null ? this.streamDescription.toBuilder() : null;
        }

        @Override
        public final Builder streamDescription(StreamSpecification streamDescription) {
            this.streamDescription = streamDescription;
            return this;
        }

        public final void setStreamDescription(StreamSpecification.BuilderImpl streamDescription) {
            this.streamDescription = streamDescription != null ? streamDescription.build() : null;
        }

        public final TimeToLiveDescription.Builder getTimeToLiveDescription() {
            return this.timeToLiveDescription != null ? this.timeToLiveDescription.toBuilder() : null;
        }

        @Override
        public final Builder timeToLiveDescription(TimeToLiveDescription timeToLiveDescription) {
            this.timeToLiveDescription = timeToLiveDescription;
            return this;
        }

        public final void setTimeToLiveDescription(TimeToLiveDescription.BuilderImpl timeToLiveDescription) {
            this.timeToLiveDescription = timeToLiveDescription != null ? timeToLiveDescription.build() : null;
        }

        public final SSEDescription.Builder getSseDescription() {
            return this.sseDescription != null ? this.sseDescription.toBuilder() : null;
        }

        @Override
        public final Builder sseDescription(SSEDescription sseDescription) {
            this.sseDescription = sseDescription;
            return this;
        }

        public final void setSseDescription(SSEDescription.BuilderImpl sseDescription) {
            this.sseDescription = sseDescription != null ? sseDescription.build() : null;
        }

        public SourceTableFeatureDetails build() {
            return new SourceTableFeatureDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SourceTableFeatureDetails> {
        public Builder localSecondaryIndexes(Collection<LocalSecondaryIndexInfo> var1);

        public Builder localSecondaryIndexes(LocalSecondaryIndexInfo ... var1);

        public Builder localSecondaryIndexes(Consumer<LocalSecondaryIndexInfo.Builder> ... var1);

        public Builder globalSecondaryIndexes(Collection<GlobalSecondaryIndexInfo> var1);

        public Builder globalSecondaryIndexes(GlobalSecondaryIndexInfo ... var1);

        public Builder globalSecondaryIndexes(Consumer<GlobalSecondaryIndexInfo.Builder> ... var1);

        public Builder streamDescription(StreamSpecification var1);

        default public Builder streamDescription(Consumer<StreamSpecification.Builder> streamDescription) {
            return this.streamDescription((StreamSpecification)((StreamSpecification.Builder)StreamSpecification.builder().applyMutation(streamDescription)).build());
        }

        public Builder timeToLiveDescription(TimeToLiveDescription var1);

        default public Builder timeToLiveDescription(Consumer<TimeToLiveDescription.Builder> timeToLiveDescription) {
            return this.timeToLiveDescription((TimeToLiveDescription)((TimeToLiveDescription.Builder)TimeToLiveDescription.builder().applyMutation(timeToLiveDescription)).build());
        }

        public Builder sseDescription(SSEDescription var1);

        default public Builder sseDescription(Consumer<SSEDescription.Builder> sseDescription) {
            return this.sseDescription((SSEDescription)((SSEDescription.Builder)SSEDescription.builder().applyMutation(sseDescription)).build());
        }
    }
}

