/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.dynamodb.model.BackupDetails;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class BackupDetailsMarshaller {
    private static final MarshallingInfo<String> BACKUPARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BackupArn").isBinary(false).build();
    private static final MarshallingInfo<String> BACKUPNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BackupName").isBinary(false).build();
    private static final MarshallingInfo<Long> BACKUPSIZEBYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BackupSizeBytes").isBinary(false).build();
    private static final MarshallingInfo<String> BACKUPSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BackupStatus").isBinary(false).build();
    private static final MarshallingInfo<Instant> BACKUPCREATIONDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BackupCreationDateTime").isBinary(false).build();
    private static final BackupDetailsMarshaller INSTANCE = new BackupDetailsMarshaller();

    private BackupDetailsMarshaller() {
    }

    public static BackupDetailsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BackupDetails backupDetails, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)backupDetails, (String)"backupDetails");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)backupDetails.backupArn(), BACKUPARN_BINDING);
            protocolMarshaller.marshall((Object)backupDetails.backupName(), BACKUPNAME_BINDING);
            protocolMarshaller.marshall((Object)backupDetails.backupSizeBytes(), BACKUPSIZEBYTES_BINDING);
            protocolMarshaller.marshall((Object)backupDetails.backupStatusAsString(), BACKUPSTATUS_BINDING);
            protocolMarshaller.marshall((Object)backupDetails.backupCreationDateTime(), BACKUPCREATIONDATETIME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

