/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemRequestMapCopier;
import software.amazon.awssdk.services.dynamodb.model.ConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.ConsumedCapacityMultipleCopier;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbResponse;
import software.amazon.awssdk.services.dynamodb.model.ItemCollectionMetrics;
import software.amazon.awssdk.services.dynamodb.model.ItemCollectionMetricsPerTableCopier;
import software.amazon.awssdk.services.dynamodb.model.WriteRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchWriteItemResponse
extends DynamoDbResponse
implements ToCopyableBuilder<Builder, BatchWriteItemResponse> {
    private final Map<String, List<WriteRequest>> unprocessedItems;
    private final Map<String, List<ItemCollectionMetrics>> itemCollectionMetrics;
    private final List<ConsumedCapacity> consumedCapacity;

    private BatchWriteItemResponse(BuilderImpl builder) {
        super(builder);
        this.unprocessedItems = builder.unprocessedItems;
        this.itemCollectionMetrics = builder.itemCollectionMetrics;
        this.consumedCapacity = builder.consumedCapacity;
    }

    public Map<String, List<WriteRequest>> unprocessedItems() {
        return this.unprocessedItems;
    }

    public Map<String, List<ItemCollectionMetrics>> itemCollectionMetrics() {
        return this.itemCollectionMetrics;
    }

    public List<ConsumedCapacity> consumedCapacity() {
        return this.consumedCapacity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.unprocessedItems());
        hashCode = 31 * hashCode + Objects.hashCode(this.itemCollectionMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(this.consumedCapacity());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchWriteItemResponse)) {
            return false;
        }
        BatchWriteItemResponse other = (BatchWriteItemResponse)((Object)obj);
        return Objects.equals(this.unprocessedItems(), other.unprocessedItems()) && Objects.equals(this.itemCollectionMetrics(), other.itemCollectionMetrics()) && Objects.equals(this.consumedCapacity(), other.consumedCapacity());
    }

    public String toString() {
        return ToString.builder((String)"BatchWriteItemResponse").add("UnprocessedItems", this.unprocessedItems()).add("ItemCollectionMetrics", this.itemCollectionMetrics()).add("ConsumedCapacity", this.consumedCapacity()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UnprocessedItems": {
                return Optional.ofNullable(clazz.cast(this.unprocessedItems()));
            }
            case "ItemCollectionMetrics": {
                return Optional.ofNullable(clazz.cast(this.itemCollectionMetrics()));
            }
            case "ConsumedCapacity": {
                return Optional.ofNullable(clazz.cast(this.consumedCapacity()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DynamoDbResponse.BuilderImpl
    implements Builder {
        private Map<String, List<WriteRequest>> unprocessedItems = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, List<ItemCollectionMetrics>> itemCollectionMetrics = DefaultSdkAutoConstructMap.getInstance();
        private List<ConsumedCapacity> consumedCapacity = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchWriteItemResponse model) {
            super(model);
            this.unprocessedItems(model.unprocessedItems);
            this.itemCollectionMetrics(model.itemCollectionMetrics);
            this.consumedCapacity(model.consumedCapacity);
        }

        public final Map<String, ? extends Collection<WriteRequest>> getUnprocessedItems() {
            return this.unprocessedItems;
        }

        @Override
        public final Builder unprocessedItems(Map<String, ? extends Collection<WriteRequest>> unprocessedItems) {
            this.unprocessedItems = BatchWriteItemRequestMapCopier.copy(unprocessedItems);
            return this;
        }

        public final void setUnprocessedItems(Map<String, ? extends Collection<WriteRequest>> unprocessedItems) {
            this.unprocessedItems = BatchWriteItemRequestMapCopier.copy(unprocessedItems);
        }

        public final Map<String, ? extends Collection<ItemCollectionMetrics>> getItemCollectionMetrics() {
            return this.itemCollectionMetrics;
        }

        @Override
        public final Builder itemCollectionMetrics(Map<String, ? extends Collection<ItemCollectionMetrics>> itemCollectionMetrics) {
            this.itemCollectionMetrics = ItemCollectionMetricsPerTableCopier.copy(itemCollectionMetrics);
            return this;
        }

        public final void setItemCollectionMetrics(Map<String, ? extends Collection<ItemCollectionMetrics>> itemCollectionMetrics) {
            this.itemCollectionMetrics = ItemCollectionMetricsPerTableCopier.copy(itemCollectionMetrics);
        }

        public final Collection<ConsumedCapacity.Builder> getConsumedCapacity() {
            return this.consumedCapacity != null ? (Collection)this.consumedCapacity.stream().map(ConsumedCapacity::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder consumedCapacity(Collection<ConsumedCapacity> consumedCapacity) {
            this.consumedCapacity = ConsumedCapacityMultipleCopier.copy(consumedCapacity);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder consumedCapacity(ConsumedCapacity ... consumedCapacity) {
            this.consumedCapacity(Arrays.asList(consumedCapacity));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder consumedCapacity(Consumer<ConsumedCapacity.Builder> ... consumedCapacity) {
            this.consumedCapacity(Stream.of(consumedCapacity).map(c -> (ConsumedCapacity)((ConsumedCapacity.Builder)ConsumedCapacity.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConsumedCapacity(Collection<ConsumedCapacity.BuilderImpl> consumedCapacity) {
            this.consumedCapacity = ConsumedCapacityMultipleCopier.copyFromBuilder(consumedCapacity);
        }

        @Override
        public BatchWriteItemResponse build() {
            return new BatchWriteItemResponse(this);
        }
    }

    public static interface Builder
    extends DynamoDbResponse.Builder,
    CopyableBuilder<Builder, BatchWriteItemResponse> {
        public Builder unprocessedItems(Map<String, ? extends Collection<WriteRequest>> var1);

        public Builder itemCollectionMetrics(Map<String, ? extends Collection<ItemCollectionMetrics>> var1);

        public Builder consumedCapacity(Collection<ConsumedCapacity> var1);

        public Builder consumedCapacity(ConsumedCapacity ... var1);

        public Builder consumedCapacity(Consumer<ConsumedCapacity.Builder> ... var1);
    }
}

