/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.BackupStatus;
import software.amazon.awssdk.services.dynamodb.transform.BackupDetailsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BackupDetails
implements StructuredPojo,
ToCopyableBuilder<Builder, BackupDetails> {
    private final String backupArn;
    private final String backupName;
    private final Long backupSizeBytes;
    private final String backupStatus;
    private final Instant backupCreationDateTime;

    private BackupDetails(BuilderImpl builder) {
        this.backupArn = builder.backupArn;
        this.backupName = builder.backupName;
        this.backupSizeBytes = builder.backupSizeBytes;
        this.backupStatus = builder.backupStatus;
        this.backupCreationDateTime = builder.backupCreationDateTime;
    }

    public String backupArn() {
        return this.backupArn;
    }

    public String backupName() {
        return this.backupName;
    }

    public Long backupSizeBytes() {
        return this.backupSizeBytes;
    }

    public BackupStatus backupStatus() {
        return BackupStatus.fromValue(this.backupStatus);
    }

    public String backupStatusAsString() {
        return this.backupStatus;
    }

    public Instant backupCreationDateTime() {
        return this.backupCreationDateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.backupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupSizeBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupCreationDateTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BackupDetails)) {
            return false;
        }
        BackupDetails other = (BackupDetails)obj;
        return Objects.equals(this.backupArn(), other.backupArn()) && Objects.equals(this.backupName(), other.backupName()) && Objects.equals(this.backupSizeBytes(), other.backupSizeBytes()) && Objects.equals(this.backupStatusAsString(), other.backupStatusAsString()) && Objects.equals(this.backupCreationDateTime(), other.backupCreationDateTime());
    }

    public String toString() {
        return ToString.builder((String)"BackupDetails").add("BackupArn", (Object)this.backupArn()).add("BackupName", (Object)this.backupName()).add("BackupSizeBytes", (Object)this.backupSizeBytes()).add("BackupStatus", (Object)this.backupStatusAsString()).add("BackupCreationDateTime", (Object)this.backupCreationDateTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackupArn": {
                return Optional.ofNullable(clazz.cast(this.backupArn()));
            }
            case "BackupName": {
                return Optional.ofNullable(clazz.cast(this.backupName()));
            }
            case "BackupSizeBytes": {
                return Optional.ofNullable(clazz.cast(this.backupSizeBytes()));
            }
            case "BackupStatus": {
                return Optional.ofNullable(clazz.cast(this.backupStatusAsString()));
            }
            case "BackupCreationDateTime": {
                return Optional.ofNullable(clazz.cast(this.backupCreationDateTime()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BackupDetailsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String backupArn;
        private String backupName;
        private Long backupSizeBytes;
        private String backupStatus;
        private Instant backupCreationDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(BackupDetails model) {
            this.backupArn(model.backupArn);
            this.backupName(model.backupName);
            this.backupSizeBytes(model.backupSizeBytes);
            this.backupStatus(model.backupStatus);
            this.backupCreationDateTime(model.backupCreationDateTime);
        }

        public final String getBackupArn() {
            return this.backupArn;
        }

        @Override
        public final Builder backupArn(String backupArn) {
            this.backupArn = backupArn;
            return this;
        }

        public final void setBackupArn(String backupArn) {
            this.backupArn = backupArn;
        }

        public final String getBackupName() {
            return this.backupName;
        }

        @Override
        public final Builder backupName(String backupName) {
            this.backupName = backupName;
            return this;
        }

        public final void setBackupName(String backupName) {
            this.backupName = backupName;
        }

        public final Long getBackupSizeBytes() {
            return this.backupSizeBytes;
        }

        @Override
        public final Builder backupSizeBytes(Long backupSizeBytes) {
            this.backupSizeBytes = backupSizeBytes;
            return this;
        }

        public final void setBackupSizeBytes(Long backupSizeBytes) {
            this.backupSizeBytes = backupSizeBytes;
        }

        public final String getBackupStatus() {
            return this.backupStatus;
        }

        @Override
        public final Builder backupStatus(String backupStatus) {
            this.backupStatus = backupStatus;
            return this;
        }

        @Override
        public final Builder backupStatus(BackupStatus backupStatus) {
            this.backupStatus(backupStatus.toString());
            return this;
        }

        public final void setBackupStatus(String backupStatus) {
            this.backupStatus = backupStatus;
        }

        public final Instant getBackupCreationDateTime() {
            return this.backupCreationDateTime;
        }

        @Override
        public final Builder backupCreationDateTime(Instant backupCreationDateTime) {
            this.backupCreationDateTime = backupCreationDateTime;
            return this;
        }

        public final void setBackupCreationDateTime(Instant backupCreationDateTime) {
            this.backupCreationDateTime = backupCreationDateTime;
        }

        public BackupDetails build() {
            return new BackupDetails(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BackupDetails> {
        public Builder backupArn(String var1);

        public Builder backupName(String var1);

        public Builder backupSizeBytes(Long var1);

        public Builder backupStatus(String var1);

        public Builder backupStatus(BackupStatus var1);

        public Builder backupCreationDateTime(Instant var1);
    }
}

