/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.SourceTableFeatureDetails;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SourceTableFeatureDetailsMarshaller {
    private static final MarshallingInfo<List> LOCALSECONDARYINDEXES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LocalSecondaryIndexes").isBinary(false).build();
    private static final MarshallingInfo<List> GLOBALSECONDARYINDEXES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GlobalSecondaryIndexes").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> STREAMDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StreamDescription").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> TIMETOLIVEDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TimeToLiveDescription").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> SSEDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SSEDescription").isBinary(false).build();
    private static final SourceTableFeatureDetailsMarshaller INSTANCE = new SourceTableFeatureDetailsMarshaller();

    private SourceTableFeatureDetailsMarshaller() {
    }

    public static SourceTableFeatureDetailsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SourceTableFeatureDetails sourceTableFeatureDetails, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)sourceTableFeatureDetails, (String)"sourceTableFeatureDetails");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(sourceTableFeatureDetails.localSecondaryIndexes(), LOCALSECONDARYINDEXES_BINDING);
            protocolMarshaller.marshall(sourceTableFeatureDetails.globalSecondaryIndexes(), GLOBALSECONDARYINDEXES_BINDING);
            protocolMarshaller.marshall((Object)sourceTableFeatureDetails.streamDescription(), STREAMDESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)sourceTableFeatureDetails.timeToLiveDescription(), TIMETOLIVEDESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)sourceTableFeatureDetails.sseDescription(), SSEDESCRIPTION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

