/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RestoreTableToPointInTimeRequest
extends DynamoDbRequest
implements ToCopyableBuilder<Builder, RestoreTableToPointInTimeRequest> {
    private final String sourceTableName;
    private final String targetTableName;
    private final Boolean useLatestRestorableTime;
    private final Instant restoreDateTime;

    private RestoreTableToPointInTimeRequest(BuilderImpl builder) {
        super(builder);
        this.sourceTableName = builder.sourceTableName;
        this.targetTableName = builder.targetTableName;
        this.useLatestRestorableTime = builder.useLatestRestorableTime;
        this.restoreDateTime = builder.restoreDateTime;
    }

    public String sourceTableName() {
        return this.sourceTableName;
    }

    public String targetTableName() {
        return this.targetTableName;
    }

    public Boolean useLatestRestorableTime() {
        return this.useLatestRestorableTime;
    }

    public Instant restoreDateTime() {
        return this.restoreDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceTableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetTableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.useLatestRestorableTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.restoreDateTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreTableToPointInTimeRequest)) {
            return false;
        }
        RestoreTableToPointInTimeRequest other = (RestoreTableToPointInTimeRequest)((Object)obj);
        return Objects.equals(this.sourceTableName(), other.sourceTableName()) && Objects.equals(this.targetTableName(), other.targetTableName()) && Objects.equals(this.useLatestRestorableTime(), other.useLatestRestorableTime()) && Objects.equals(this.restoreDateTime(), other.restoreDateTime());
    }

    public String toString() {
        return ToString.builder((String)"RestoreTableToPointInTimeRequest").add("SourceTableName", (Object)this.sourceTableName()).add("TargetTableName", (Object)this.targetTableName()).add("UseLatestRestorableTime", (Object)this.useLatestRestorableTime()).add("RestoreDateTime", (Object)this.restoreDateTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceTableName": {
                return Optional.ofNullable(clazz.cast(this.sourceTableName()));
            }
            case "TargetTableName": {
                return Optional.ofNullable(clazz.cast(this.targetTableName()));
            }
            case "UseLatestRestorableTime": {
                return Optional.ofNullable(clazz.cast(this.useLatestRestorableTime()));
            }
            case "RestoreDateTime": {
                return Optional.ofNullable(clazz.cast(this.restoreDateTime()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DynamoDbRequest.BuilderImpl
    implements Builder {
        private String sourceTableName;
        private String targetTableName;
        private Boolean useLatestRestorableTime;
        private Instant restoreDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreTableToPointInTimeRequest model) {
            super(model);
            this.sourceTableName(model.sourceTableName);
            this.targetTableName(model.targetTableName);
            this.useLatestRestorableTime(model.useLatestRestorableTime);
            this.restoreDateTime(model.restoreDateTime);
        }

        public final String getSourceTableName() {
            return this.sourceTableName;
        }

        @Override
        public final Builder sourceTableName(String sourceTableName) {
            this.sourceTableName = sourceTableName;
            return this;
        }

        public final void setSourceTableName(String sourceTableName) {
            this.sourceTableName = sourceTableName;
        }

        public final String getTargetTableName() {
            return this.targetTableName;
        }

        @Override
        public final Builder targetTableName(String targetTableName) {
            this.targetTableName = targetTableName;
            return this;
        }

        public final void setTargetTableName(String targetTableName) {
            this.targetTableName = targetTableName;
        }

        public final Boolean getUseLatestRestorableTime() {
            return this.useLatestRestorableTime;
        }

        @Override
        public final Builder useLatestRestorableTime(Boolean useLatestRestorableTime) {
            this.useLatestRestorableTime = useLatestRestorableTime;
            return this;
        }

        public final void setUseLatestRestorableTime(Boolean useLatestRestorableTime) {
            this.useLatestRestorableTime = useLatestRestorableTime;
        }

        public final Instant getRestoreDateTime() {
            return this.restoreDateTime;
        }

        @Override
        public final Builder restoreDateTime(Instant restoreDateTime) {
            this.restoreDateTime = restoreDateTime;
            return this;
        }

        public final void setRestoreDateTime(Instant restoreDateTime) {
            this.restoreDateTime = restoreDateTime;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RestoreTableToPointInTimeRequest build() {
            return new RestoreTableToPointInTimeRequest(this);
        }
    }

    public static interface Builder
    extends DynamoDbRequest.Builder,
    CopyableBuilder<Builder, RestoreTableToPointInTimeRequest> {
        public Builder sourceTableName(String var1);

        public Builder targetTableName(String var1);

        public Builder useLatestRestorableTime(Boolean var1);

        public Builder restoreDateTime(Instant var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

