/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.dynamodb.model.Replica;
import software.amazon.awssdk.services.dynamodb.model.ReplicaListCopier;
import software.amazon.awssdk.services.dynamodb.transform.GlobalTableMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GlobalTable
implements StructuredPojo,
ToCopyableBuilder<Builder, GlobalTable> {
    private final String globalTableName;
    private final List<Replica> replicationGroup;

    private GlobalTable(BuilderImpl builder) {
        this.globalTableName = builder.globalTableName;
        this.replicationGroup = builder.replicationGroup;
    }

    public String globalTableName() {
        return this.globalTableName;
    }

    public List<Replica> replicationGroup() {
        return this.replicationGroup;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.globalTableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationGroup());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlobalTable)) {
            return false;
        }
        GlobalTable other = (GlobalTable)obj;
        return Objects.equals(this.globalTableName(), other.globalTableName()) && Objects.equals(this.replicationGroup(), other.replicationGroup());
    }

    public String toString() {
        return ToString.builder((String)"GlobalTable").add("GlobalTableName", (Object)this.globalTableName()).add("ReplicationGroup", this.replicationGroup()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GlobalTableName": {
                return Optional.ofNullable(clazz.cast(this.globalTableName()));
            }
            case "ReplicationGroup": {
                return Optional.ofNullable(clazz.cast(this.replicationGroup()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GlobalTableMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String globalTableName;
        private List<Replica> replicationGroup = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GlobalTable model) {
            this.globalTableName(model.globalTableName);
            this.replicationGroup(model.replicationGroup);
        }

        public final String getGlobalTableName() {
            return this.globalTableName;
        }

        @Override
        public final Builder globalTableName(String globalTableName) {
            this.globalTableName = globalTableName;
            return this;
        }

        public final void setGlobalTableName(String globalTableName) {
            this.globalTableName = globalTableName;
        }

        public final Collection<Replica.Builder> getReplicationGroup() {
            return this.replicationGroup != null ? (Collection)this.replicationGroup.stream().map(Replica::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder replicationGroup(Collection<Replica> replicationGroup) {
            this.replicationGroup = ReplicaListCopier.copy(replicationGroup);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationGroup(Replica ... replicationGroup) {
            this.replicationGroup(Arrays.asList(replicationGroup));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationGroup(Consumer<Replica.Builder> ... replicationGroup) {
            this.replicationGroup(Stream.of(replicationGroup).map(c -> (Replica)((Replica.Builder)Replica.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReplicationGroup(Collection<Replica.BuilderImpl> replicationGroup) {
            this.replicationGroup = ReplicaListCopier.copyFromBuilder(replicationGroup);
        }

        public GlobalTable build() {
            return new GlobalTable(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GlobalTable> {
        public Builder globalTableName(String var1);

        public Builder replicationGroup(Collection<Replica> var1);

        public Builder replicationGroup(Replica ... var1);

        public Builder replicationGroup(Consumer<Replica.Builder> ... var1);
    }
}

