/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.dynamodb.model.RestoreSummary;

public class RestoreSummaryUnmarshaller
implements Unmarshaller<RestoreSummary, JsonUnmarshallerContext> {
    private static final RestoreSummaryUnmarshaller INSTANCE = new RestoreSummaryUnmarshaller();

    public RestoreSummary unmarshall(JsonUnmarshallerContext context) throws Exception {
        RestoreSummary.Builder restoreSummaryBuilder = RestoreSummary.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("SourceBackupArn", targetDepth)) {
                    context.nextToken();
                    restoreSummaryBuilder.sourceBackupArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("SourceTableArn", targetDepth)) {
                    context.nextToken();
                    restoreSummaryBuilder.sourceTableArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("RestoreDateTime", targetDepth)) {
                    context.nextToken();
                    restoreSummaryBuilder.restoreDateTime((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("RestoreInProgress", targetDepth)) {
                    context.nextToken();
                    restoreSummaryBuilder.restoreInProgress((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (RestoreSummary)restoreSummaryBuilder.build();
    }

    public static RestoreSummaryUnmarshaller getInstance() {
        return INSTANCE;
    }
}

