/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemResponse;

public class BatchGetItemPublisher
implements SdkPublisher<BatchGetItemResponse> {
    private final DynamoDbAsyncClient client;
    private final BatchGetItemRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public BatchGetItemPublisher(DynamoDbAsyncClient client, BatchGetItemRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private BatchGetItemPublisher(DynamoDbAsyncClient client, BatchGetItemRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new BatchGetItemResponseFetcher();
    }

    public void subscribe(Subscriber<? super BatchGetItemResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final BatchGetItemPublisher resume(BatchGetItemResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new BatchGetItemPublisher(this.client, (BatchGetItemRequest)((Object)this.firstRequest.toBuilder().requestItems(lastSuccessfulPage.unprocessedKeys()).build()));
        }
        return new BatchGetItemPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super BatchGetItemResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class BatchGetItemResponseFetcher
    implements AsyncPageFetcher<BatchGetItemResponse> {
        private BatchGetItemResponseFetcher() {
        }

        public boolean hasNextPage(BatchGetItemResponse previousPage) {
            return previousPage.unprocessedKeys() != null && !SdkAutoConstructList.class.isInstance(previousPage.unprocessedKeys()) && !SdkAutoConstructMap.class.isInstance(previousPage.unprocessedKeys());
        }

        public CompletableFuture<BatchGetItemResponse> nextPage(BatchGetItemResponse previousPage) {
            if (previousPage == null) {
                return BatchGetItemPublisher.this.client.batchGetItem(BatchGetItemPublisher.this.firstRequest);
            }
            return BatchGetItemPublisher.this.client.batchGetItem((BatchGetItemRequest)((Object)BatchGetItemPublisher.this.firstRequest.toBuilder().requestItems(previousPage.unprocessedKeys()).build()));
        }
    }
}

