/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughput;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ProvisionedThroughputMarshaller {
    private static final MarshallingInfo<Long> READCAPACITYUNITS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReadCapacityUnits").isBinary(false).build();
    private static final MarshallingInfo<Long> WRITECAPACITYUNITS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WriteCapacityUnits").isBinary(false).build();
    private static final ProvisionedThroughputMarshaller INSTANCE = new ProvisionedThroughputMarshaller();

    private ProvisionedThroughputMarshaller() {
    }

    public static ProvisionedThroughputMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ProvisionedThroughput provisionedThroughput, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)provisionedThroughput, (String)"provisionedThroughput");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)provisionedThroughput.readCapacityUnits(), READCAPACITYUNITS_BINDING);
            protocolMarshaller.marshall((Object)provisionedThroughput.writeCapacityUnits(), WRITECAPACITYUNITS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

