/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.dynamodb.model.Condition;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ConditionMarshaller {
    private static final MarshallingInfo<List> ATTRIBUTEVALUELIST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttributeValueList").isBinary(false).build();
    private static final MarshallingInfo<String> COMPARISONOPERATOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComparisonOperator").isBinary(false).build();
    private static final ConditionMarshaller INSTANCE = new ConditionMarshaller();

    private ConditionMarshaller() {
    }

    public static ConditionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Condition condition, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)condition, (String)"condition");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(condition.attributeValueList(), ATTRIBUTEVALUELIST_BINDING);
            protocolMarshaller.marshall((Object)condition.comparisonOperatorString(), COMPARISONOPERATOR_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

