/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.dynamodb.model.BatchGetRequestMapCopier;
import software.amazon.awssdk.services.dynamodb.model.DynamoDBRequest;
import software.amazon.awssdk.services.dynamodb.model.KeysAndAttributes;
import software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchGetItemRequest
extends DynamoDBRequest
implements ToCopyableBuilder<Builder, BatchGetItemRequest> {
    private final Map<String, KeysAndAttributes> requestItems;
    private final String returnConsumedCapacity;

    private BatchGetItemRequest(BuilderImpl builder) {
        super(builder);
        this.requestItems = builder.requestItems;
        this.returnConsumedCapacity = builder.returnConsumedCapacity;
    }

    public Map<String, KeysAndAttributes> requestItems() {
        return this.requestItems;
    }

    public ReturnConsumedCapacity returnConsumedCapacity() {
        return ReturnConsumedCapacity.fromValue(this.returnConsumedCapacity);
    }

    public String returnConsumedCapacityString() {
        return this.returnConsumedCapacity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.requestItems());
        hashCode = 31 * hashCode + Objects.hashCode(this.returnConsumedCapacityString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetItemRequest)) {
            return false;
        }
        BatchGetItemRequest other = (BatchGetItemRequest)((Object)obj);
        return Objects.equals(this.requestItems(), other.requestItems()) && Objects.equals(this.returnConsumedCapacityString(), other.returnConsumedCapacityString());
    }

    public String toString() {
        return ToString.builder((String)"BatchGetItemRequest").add("RequestItems", this.requestItems()).add("ReturnConsumedCapacity", (Object)this.returnConsumedCapacityString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RequestItems": {
                return Optional.of(clazz.cast(this.requestItems()));
            }
            case "ReturnConsumedCapacity": {
                return Optional.of(clazz.cast(this.returnConsumedCapacityString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DynamoDBRequest.BuilderImpl
    implements Builder {
        private Map<String, KeysAndAttributes> requestItems;
        private String returnConsumedCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetItemRequest model) {
            this.requestItems(model.requestItems);
            this.returnConsumedCapacity(model.returnConsumedCapacity);
        }

        public final Map<String, KeysAndAttributes.Builder> getRequestItems() {
            return this.requestItems != null ? CollectionUtils.mapValues(this.requestItems, KeysAndAttributes::toBuilder) : null;
        }

        @Override
        public final Builder requestItems(Map<String, KeysAndAttributes> requestItems) {
            this.requestItems = BatchGetRequestMapCopier.copy(requestItems);
            return this;
        }

        public final void setRequestItems(Map<String, KeysAndAttributes.BuilderImpl> requestItems) {
            this.requestItems = BatchGetRequestMapCopier.copyFromBuilder(requestItems);
        }

        public final String getReturnConsumedCapacity() {
            return this.returnConsumedCapacity;
        }

        @Override
        public final Builder returnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
            return this;
        }

        @Override
        public final Builder returnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
            this.returnConsumedCapacity(returnConsumedCapacity.toString());
            return this;
        }

        public final void setReturnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public BatchGetItemRequest build() {
            return new BatchGetItemRequest(this);
        }
    }

    public static interface Builder
    extends DynamoDBRequest.Builder,
    CopyableBuilder<Builder, BatchGetItemRequest> {
        public Builder requestItems(Map<String, KeysAndAttributes> var1);

        public Builder returnConsumedCapacity(String var1);

        public Builder returnConsumedCapacity(ReturnConsumedCapacity var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

