/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.AttributeAction;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.transform.AttributeValueUpdateMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AttributeValueUpdate
implements StructuredPojo,
ToCopyableBuilder<Builder, AttributeValueUpdate> {
    private final AttributeValue value;
    private final String action;

    private AttributeValueUpdate(BuilderImpl builder) {
        this.value = builder.value;
        this.action = builder.action;
    }

    public AttributeValue value() {
        return this.value;
    }

    public AttributeAction action() {
        return AttributeAction.fromValue(this.action);
    }

    public String actionString() {
        return this.action;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttributeValueUpdate)) {
            return false;
        }
        AttributeValueUpdate other = (AttributeValueUpdate)obj;
        return Objects.equals(this.value(), other.value()) && Objects.equals(this.actionString(), other.actionString());
    }

    public String toString() {
        return ToString.builder((String)"AttributeValueUpdate").add("Value", (Object)this.value()).add("Action", (Object)this.actionString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Value": {
                return Optional.of(clazz.cast(this.value()));
            }
            case "Action": {
                return Optional.of(clazz.cast(this.actionString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AttributeValueUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private AttributeValue value;
        private String action;

        private BuilderImpl() {
        }

        private BuilderImpl(AttributeValueUpdate model) {
            this.value(model.value);
            this.action(model.action);
        }

        public final AttributeValue.Builder getValue() {
            return this.value != null ? this.value.toBuilder() : null;
        }

        @Override
        public final Builder value(AttributeValue value) {
            this.value = value;
            return this;
        }

        public final void setValue(AttributeValue.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        public final String getAction() {
            return this.action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(AttributeAction action) {
            this.action(action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public AttributeValueUpdate build() {
            return new AttributeValueUpdate(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AttributeValueUpdate> {
        public Builder value(AttributeValue var1);

        default public Builder value(Consumer<AttributeValue.Builder> value) {
            return this.value((AttributeValue)((AttributeValue.Builder)AttributeValue.builder().apply(value)).build());
        }

        public Builder action(String var1);

        public Builder action(AttributeAction var1);
    }
}

