/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.dynamodb.model.AttributeNameListCopier;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.Condition;
import software.amazon.awssdk.services.dynamodb.model.ConditionalOperator;
import software.amazon.awssdk.services.dynamodb.model.DynamoDBRequest;
import software.amazon.awssdk.services.dynamodb.model.ExpressionAttributeNameMapCopier;
import software.amazon.awssdk.services.dynamodb.model.ExpressionAttributeValueMapCopier;
import software.amazon.awssdk.services.dynamodb.model.FilterConditionMapCopier;
import software.amazon.awssdk.services.dynamodb.model.KeyConditionsCopier;
import software.amazon.awssdk.services.dynamodb.model.KeyCopier;
import software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.Select;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class QueryRequest
extends DynamoDBRequest
implements ToCopyableBuilder<Builder, QueryRequest> {
    private final String tableName;
    private final String indexName;
    private final String select;
    private final List<String> attributesToGet;
    private final Integer limit;
    private final Boolean consistentRead;
    private final Map<String, Condition> keyConditions;
    private final Map<String, Condition> queryFilter;
    private final String conditionalOperator;
    private final Boolean scanIndexForward;
    private final Map<String, AttributeValue> exclusiveStartKey;
    private final String returnConsumedCapacity;
    private final String projectionExpression;
    private final String filterExpression;
    private final String keyConditionExpression;
    private final Map<String, String> expressionAttributeNames;
    private final Map<String, AttributeValue> expressionAttributeValues;

    private QueryRequest(BuilderImpl builder) {
        super(builder);
        this.tableName = builder.tableName;
        this.indexName = builder.indexName;
        this.select = builder.select;
        this.attributesToGet = builder.attributesToGet;
        this.limit = builder.limit;
        this.consistentRead = builder.consistentRead;
        this.keyConditions = builder.keyConditions;
        this.queryFilter = builder.queryFilter;
        this.conditionalOperator = builder.conditionalOperator;
        this.scanIndexForward = builder.scanIndexForward;
        this.exclusiveStartKey = builder.exclusiveStartKey;
        this.returnConsumedCapacity = builder.returnConsumedCapacity;
        this.projectionExpression = builder.projectionExpression;
        this.filterExpression = builder.filterExpression;
        this.keyConditionExpression = builder.keyConditionExpression;
        this.expressionAttributeNames = builder.expressionAttributeNames;
        this.expressionAttributeValues = builder.expressionAttributeValues;
    }

    public String tableName() {
        return this.tableName;
    }

    public String indexName() {
        return this.indexName;
    }

    public Select select() {
        return Select.fromValue(this.select);
    }

    public String selectString() {
        return this.select;
    }

    public List<String> attributesToGet() {
        return this.attributesToGet;
    }

    public Integer limit() {
        return this.limit;
    }

    public Boolean consistentRead() {
        return this.consistentRead;
    }

    public Map<String, Condition> keyConditions() {
        return this.keyConditions;
    }

    public Map<String, Condition> queryFilter() {
        return this.queryFilter;
    }

    public ConditionalOperator conditionalOperator() {
        return ConditionalOperator.fromValue(this.conditionalOperator);
    }

    public String conditionalOperatorString() {
        return this.conditionalOperator;
    }

    public Boolean scanIndexForward() {
        return this.scanIndexForward;
    }

    public Map<String, AttributeValue> exclusiveStartKey() {
        return this.exclusiveStartKey;
    }

    public ReturnConsumedCapacity returnConsumedCapacity() {
        return ReturnConsumedCapacity.fromValue(this.returnConsumedCapacity);
    }

    public String returnConsumedCapacityString() {
        return this.returnConsumedCapacity;
    }

    public String projectionExpression() {
        return this.projectionExpression;
    }

    public String filterExpression() {
        return this.filterExpression;
    }

    public String keyConditionExpression() {
        return this.keyConditionExpression;
    }

    public Map<String, String> expressionAttributeNames() {
        return this.expressionAttributeNames;
    }

    public Map<String, AttributeValue> expressionAttributeValues() {
        return this.expressionAttributeValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexName());
        hashCode = 31 * hashCode + Objects.hashCode(this.selectString());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributesToGet());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.consistentRead());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyConditions());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.conditionalOperatorString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanIndexForward());
        hashCode = 31 * hashCode + Objects.hashCode(this.exclusiveStartKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.returnConsumedCapacityString());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyConditionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.expressionAttributeNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.expressionAttributeValues());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryRequest)) {
            return false;
        }
        QueryRequest other = (QueryRequest)((Object)obj);
        return Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.indexName(), other.indexName()) && Objects.equals(this.selectString(), other.selectString()) && Objects.equals(this.attributesToGet(), other.attributesToGet()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.consistentRead(), other.consistentRead()) && Objects.equals(this.keyConditions(), other.keyConditions()) && Objects.equals(this.queryFilter(), other.queryFilter()) && Objects.equals(this.conditionalOperatorString(), other.conditionalOperatorString()) && Objects.equals(this.scanIndexForward(), other.scanIndexForward()) && Objects.equals(this.exclusiveStartKey(), other.exclusiveStartKey()) && Objects.equals(this.returnConsumedCapacityString(), other.returnConsumedCapacityString()) && Objects.equals(this.projectionExpression(), other.projectionExpression()) && Objects.equals(this.filterExpression(), other.filterExpression()) && Objects.equals(this.keyConditionExpression(), other.keyConditionExpression()) && Objects.equals(this.expressionAttributeNames(), other.expressionAttributeNames()) && Objects.equals(this.expressionAttributeValues(), other.expressionAttributeValues());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.tableName() != null) {
            sb.append("TableName: ").append(this.tableName()).append(",");
        }
        if (this.indexName() != null) {
            sb.append("IndexName: ").append(this.indexName()).append(",");
        }
        if (this.selectString() != null) {
            sb.append("Select: ").append(this.selectString()).append(",");
        }
        if (this.attributesToGet() != null) {
            sb.append("AttributesToGet: ").append(this.attributesToGet()).append(",");
        }
        if (this.limit() != null) {
            sb.append("Limit: ").append(this.limit()).append(",");
        }
        if (this.consistentRead() != null) {
            sb.append("ConsistentRead: ").append(this.consistentRead()).append(",");
        }
        if (this.keyConditions() != null) {
            sb.append("KeyConditions: ").append(this.keyConditions()).append(",");
        }
        if (this.queryFilter() != null) {
            sb.append("QueryFilter: ").append(this.queryFilter()).append(",");
        }
        if (this.conditionalOperatorString() != null) {
            sb.append("ConditionalOperator: ").append(this.conditionalOperatorString()).append(",");
        }
        if (this.scanIndexForward() != null) {
            sb.append("ScanIndexForward: ").append(this.scanIndexForward()).append(",");
        }
        if (this.exclusiveStartKey() != null) {
            sb.append("ExclusiveStartKey: ").append(this.exclusiveStartKey()).append(",");
        }
        if (this.returnConsumedCapacityString() != null) {
            sb.append("ReturnConsumedCapacity: ").append(this.returnConsumedCapacityString()).append(",");
        }
        if (this.projectionExpression() != null) {
            sb.append("ProjectionExpression: ").append(this.projectionExpression()).append(",");
        }
        if (this.filterExpression() != null) {
            sb.append("FilterExpression: ").append(this.filterExpression()).append(",");
        }
        if (this.keyConditionExpression() != null) {
            sb.append("KeyConditionExpression: ").append(this.keyConditionExpression()).append(",");
        }
        if (this.expressionAttributeNames() != null) {
            sb.append("ExpressionAttributeNames: ").append(this.expressionAttributeNames()).append(",");
        }
        if (this.expressionAttributeValues() != null) {
            sb.append("ExpressionAttributeValues: ").append(this.expressionAttributeValues()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TableName": {
                return Optional.of(clazz.cast(this.tableName()));
            }
            case "IndexName": {
                return Optional.of(clazz.cast(this.indexName()));
            }
            case "Select": {
                return Optional.of(clazz.cast(this.selectString()));
            }
            case "AttributesToGet": {
                return Optional.of(clazz.cast(this.attributesToGet()));
            }
            case "Limit": {
                return Optional.of(clazz.cast(this.limit()));
            }
            case "ConsistentRead": {
                return Optional.of(clazz.cast(this.consistentRead()));
            }
            case "KeyConditions": {
                return Optional.of(clazz.cast(this.keyConditions()));
            }
            case "QueryFilter": {
                return Optional.of(clazz.cast(this.queryFilter()));
            }
            case "ConditionalOperator": {
                return Optional.of(clazz.cast(this.conditionalOperatorString()));
            }
            case "ScanIndexForward": {
                return Optional.of(clazz.cast(this.scanIndexForward()));
            }
            case "ExclusiveStartKey": {
                return Optional.of(clazz.cast(this.exclusiveStartKey()));
            }
            case "ReturnConsumedCapacity": {
                return Optional.of(clazz.cast(this.returnConsumedCapacityString()));
            }
            case "ProjectionExpression": {
                return Optional.of(clazz.cast(this.projectionExpression()));
            }
            case "FilterExpression": {
                return Optional.of(clazz.cast(this.filterExpression()));
            }
            case "KeyConditionExpression": {
                return Optional.of(clazz.cast(this.keyConditionExpression()));
            }
            case "ExpressionAttributeNames": {
                return Optional.of(clazz.cast(this.expressionAttributeNames()));
            }
            case "ExpressionAttributeValues": {
                return Optional.of(clazz.cast(this.expressionAttributeValues()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DynamoDBRequest.BuilderImpl
    implements Builder {
        private String tableName;
        private String indexName;
        private String select;
        private List<String> attributesToGet;
        private Integer limit;
        private Boolean consistentRead;
        private Map<String, Condition> keyConditions;
        private Map<String, Condition> queryFilter;
        private String conditionalOperator;
        private Boolean scanIndexForward;
        private Map<String, AttributeValue> exclusiveStartKey;
        private String returnConsumedCapacity;
        private String projectionExpression;
        private String filterExpression;
        private String keyConditionExpression;
        private Map<String, String> expressionAttributeNames;
        private Map<String, AttributeValue> expressionAttributeValues;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryRequest model) {
            this.tableName(model.tableName);
            this.indexName(model.indexName);
            this.select(model.select);
            this.attributesToGet(model.attributesToGet);
            this.limit(model.limit);
            this.consistentRead(model.consistentRead);
            this.keyConditions(model.keyConditions);
            this.queryFilter(model.queryFilter);
            this.conditionalOperator(model.conditionalOperator);
            this.scanIndexForward(model.scanIndexForward);
            this.exclusiveStartKey(model.exclusiveStartKey);
            this.returnConsumedCapacity(model.returnConsumedCapacity);
            this.projectionExpression(model.projectionExpression);
            this.filterExpression(model.filterExpression);
            this.keyConditionExpression(model.keyConditionExpression);
            this.expressionAttributeNames(model.expressionAttributeNames);
            this.expressionAttributeValues(model.expressionAttributeValues);
        }

        public final String getTableName() {
            return this.tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final String getIndexName() {
            return this.indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        public final String getSelect() {
            return this.select;
        }

        @Override
        public final Builder select(String select) {
            this.select = select;
            return this;
        }

        @Override
        public final Builder select(Select select) {
            this.select(select.toString());
            return this;
        }

        public final void setSelect(String select) {
            this.select = select;
        }

        public final Collection<String> getAttributesToGet() {
            return this.attributesToGet;
        }

        @Override
        public final Builder attributesToGet(Collection<String> attributesToGet) {
            this.attributesToGet = AttributeNameListCopier.copy(attributesToGet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributesToGet(String ... attributesToGet) {
            this.attributesToGet(Arrays.asList(attributesToGet));
            return this;
        }

        public final void setAttributesToGet(Collection<String> attributesToGet) {
            this.attributesToGet = AttributeNameListCopier.copy(attributesToGet);
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final Boolean getConsistentRead() {
            return this.consistentRead;
        }

        @Override
        public final Builder consistentRead(Boolean consistentRead) {
            this.consistentRead = consistentRead;
            return this;
        }

        public final void setConsistentRead(Boolean consistentRead) {
            this.consistentRead = consistentRead;
        }

        public final Map<String, Condition.Builder> getKeyConditions() {
            return this.keyConditions != null ? CollectionUtils.mapValues(this.keyConditions, Condition::toBuilder) : null;
        }

        @Override
        public final Builder keyConditions(Map<String, Condition> keyConditions) {
            this.keyConditions = KeyConditionsCopier.copy(keyConditions);
            return this;
        }

        public final void setKeyConditions(Map<String, Condition.BuilderImpl> keyConditions) {
            this.keyConditions = KeyConditionsCopier.copyFromBuilder(keyConditions);
        }

        public final Map<String, Condition.Builder> getQueryFilter() {
            return this.queryFilter != null ? CollectionUtils.mapValues(this.queryFilter, Condition::toBuilder) : null;
        }

        @Override
        public final Builder queryFilter(Map<String, Condition> queryFilter) {
            this.queryFilter = FilterConditionMapCopier.copy(queryFilter);
            return this;
        }

        public final void setQueryFilter(Map<String, Condition.BuilderImpl> queryFilter) {
            this.queryFilter = FilterConditionMapCopier.copyFromBuilder(queryFilter);
        }

        public final String getConditionalOperator() {
            return this.conditionalOperator;
        }

        @Override
        public final Builder conditionalOperator(String conditionalOperator) {
            this.conditionalOperator = conditionalOperator;
            return this;
        }

        @Override
        public final Builder conditionalOperator(ConditionalOperator conditionalOperator) {
            this.conditionalOperator(conditionalOperator.toString());
            return this;
        }

        public final void setConditionalOperator(String conditionalOperator) {
            this.conditionalOperator = conditionalOperator;
        }

        public final Boolean getScanIndexForward() {
            return this.scanIndexForward;
        }

        @Override
        public final Builder scanIndexForward(Boolean scanIndexForward) {
            this.scanIndexForward = scanIndexForward;
            return this;
        }

        public final void setScanIndexForward(Boolean scanIndexForward) {
            this.scanIndexForward = scanIndexForward;
        }

        public final Map<String, AttributeValue.Builder> getExclusiveStartKey() {
            return this.exclusiveStartKey != null ? CollectionUtils.mapValues(this.exclusiveStartKey, AttributeValue::toBuilder) : null;
        }

        @Override
        public final Builder exclusiveStartKey(Map<String, AttributeValue> exclusiveStartKey) {
            this.exclusiveStartKey = KeyCopier.copy(exclusiveStartKey);
            return this;
        }

        public final void setExclusiveStartKey(Map<String, AttributeValue.BuilderImpl> exclusiveStartKey) {
            this.exclusiveStartKey = KeyCopier.copyFromBuilder(exclusiveStartKey);
        }

        public final String getReturnConsumedCapacity() {
            return this.returnConsumedCapacity;
        }

        @Override
        public final Builder returnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
            return this;
        }

        @Override
        public final Builder returnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
            this.returnConsumedCapacity(returnConsumedCapacity.toString());
            return this;
        }

        public final void setReturnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
        }

        public final String getProjectionExpression() {
            return this.projectionExpression;
        }

        @Override
        public final Builder projectionExpression(String projectionExpression) {
            this.projectionExpression = projectionExpression;
            return this;
        }

        public final void setProjectionExpression(String projectionExpression) {
            this.projectionExpression = projectionExpression;
        }

        public final String getFilterExpression() {
            return this.filterExpression;
        }

        @Override
        public final Builder filterExpression(String filterExpression) {
            this.filterExpression = filterExpression;
            return this;
        }

        public final void setFilterExpression(String filterExpression) {
            this.filterExpression = filterExpression;
        }

        public final String getKeyConditionExpression() {
            return this.keyConditionExpression;
        }

        @Override
        public final Builder keyConditionExpression(String keyConditionExpression) {
            this.keyConditionExpression = keyConditionExpression;
            return this;
        }

        public final void setKeyConditionExpression(String keyConditionExpression) {
            this.keyConditionExpression = keyConditionExpression;
        }

        public final Map<String, String> getExpressionAttributeNames() {
            return this.expressionAttributeNames;
        }

        @Override
        public final Builder expressionAttributeNames(Map<String, String> expressionAttributeNames) {
            this.expressionAttributeNames = ExpressionAttributeNameMapCopier.copy(expressionAttributeNames);
            return this;
        }

        public final void setExpressionAttributeNames(Map<String, String> expressionAttributeNames) {
            this.expressionAttributeNames = ExpressionAttributeNameMapCopier.copy(expressionAttributeNames);
        }

        public final Map<String, AttributeValue.Builder> getExpressionAttributeValues() {
            return this.expressionAttributeValues != null ? CollectionUtils.mapValues(this.expressionAttributeValues, AttributeValue::toBuilder) : null;
        }

        @Override
        public final Builder expressionAttributeValues(Map<String, AttributeValue> expressionAttributeValues) {
            this.expressionAttributeValues = ExpressionAttributeValueMapCopier.copy(expressionAttributeValues);
            return this;
        }

        public final void setExpressionAttributeValues(Map<String, AttributeValue.BuilderImpl> expressionAttributeValues) {
            this.expressionAttributeValues = ExpressionAttributeValueMapCopier.copyFromBuilder(expressionAttributeValues);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public QueryRequest build() {
            return new QueryRequest(this);
        }
    }

    public static interface Builder
    extends DynamoDBRequest.Builder,
    CopyableBuilder<Builder, QueryRequest> {
        public Builder tableName(String var1);

        public Builder indexName(String var1);

        public Builder select(String var1);

        public Builder select(Select var1);

        public Builder attributesToGet(Collection<String> var1);

        public Builder attributesToGet(String ... var1);

        public Builder limit(Integer var1);

        public Builder consistentRead(Boolean var1);

        public Builder keyConditions(Map<String, Condition> var1);

        public Builder queryFilter(Map<String, Condition> var1);

        public Builder conditionalOperator(String var1);

        public Builder conditionalOperator(ConditionalOperator var1);

        public Builder scanIndexForward(Boolean var1);

        public Builder exclusiveStartKey(Map<String, AttributeValue> var1);

        public Builder returnConsumedCapacity(String var1);

        public Builder returnConsumedCapacity(ReturnConsumedCapacity var1);

        public Builder projectionExpression(String var1);

        public Builder filterExpression(String var1);

        public Builder keyConditionExpression(String var1);

        public Builder expressionAttributeNames(Map<String, String> var1);

        public Builder expressionAttributeValues(Map<String, AttributeValue> var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

