/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.PutItemInputAttributeMapCopier;
import software.amazon.awssdk.services.dynamodb.transform.PutRequestMarshaller;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutRequest
implements StructuredPojo,
ToCopyableBuilder<Builder, PutRequest> {
    private final Map<String, AttributeValue> item;

    private PutRequest(BuilderImpl builder) {
        this.item = builder.item;
    }

    public Map<String, AttributeValue> item() {
        return this.item;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.item());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRequest)) {
            return false;
        }
        PutRequest other = (PutRequest)obj;
        return Objects.equals(this.item(), other.item());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.item() != null) {
            sb.append("Item: ").append(this.item()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Item": {
                return Optional.of(clazz.cast(this.item()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PutRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, AttributeValue> item;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRequest model) {
            this.item(model.item);
        }

        public final Map<String, AttributeValue.Builder> getItem() {
            return this.item != null ? CollectionUtils.mapValues(this.item, AttributeValue::toBuilder) : null;
        }

        @Override
        public final Builder item(Map<String, AttributeValue> item) {
            this.item = PutItemInputAttributeMapCopier.copy(item);
            return this;
        }

        public final void setItem(Map<String, AttributeValue.BuilderImpl> item) {
            this.item = PutItemInputAttributeMapCopier.copyFromBuilder(item);
        }

        public PutRequest build() {
            return new PutRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PutRequest> {
        public Builder item(Map<String, AttributeValue> var1);
    }
}

