/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.NonKeyAttributeNameListCopier;
import software.amazon.awssdk.services.dynamodb.model.ProjectionType;
import software.amazon.awssdk.services.dynamodb.transform.ProjectionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Projection
implements StructuredPojo,
ToCopyableBuilder<Builder, Projection> {
    private final String projectionType;
    private final List<String> nonKeyAttributes;

    private Projection(BuilderImpl builder) {
        this.projectionType = builder.projectionType;
        this.nonKeyAttributes = builder.nonKeyAttributes;
    }

    public ProjectionType projectionType() {
        return ProjectionType.fromValue(this.projectionType);
    }

    public String projectionTypeString() {
        return this.projectionType;
    }

    public List<String> nonKeyAttributes() {
        return this.nonKeyAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.projectionTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nonKeyAttributes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Projection)) {
            return false;
        }
        Projection other = (Projection)obj;
        return Objects.equals(this.projectionTypeString(), other.projectionTypeString()) && Objects.equals(this.nonKeyAttributes(), other.nonKeyAttributes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.projectionTypeString() != null) {
            sb.append("ProjectionType: ").append(this.projectionTypeString()).append(",");
        }
        if (this.nonKeyAttributes() != null) {
            sb.append("NonKeyAttributes: ").append(this.nonKeyAttributes()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProjectionType": {
                return Optional.of(clazz.cast(this.projectionTypeString()));
            }
            case "NonKeyAttributes": {
                return Optional.of(clazz.cast(this.nonKeyAttributes()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProjectionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String projectionType;
        private List<String> nonKeyAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(Projection model) {
            this.projectionType(model.projectionType);
            this.nonKeyAttributes(model.nonKeyAttributes);
        }

        public final String getProjectionType() {
            return this.projectionType;
        }

        @Override
        public final Builder projectionType(String projectionType) {
            this.projectionType = projectionType;
            return this;
        }

        @Override
        public final Builder projectionType(ProjectionType projectionType) {
            this.projectionType(projectionType.toString());
            return this;
        }

        public final void setProjectionType(String projectionType) {
            this.projectionType = projectionType;
        }

        public final Collection<String> getNonKeyAttributes() {
            return this.nonKeyAttributes;
        }

        @Override
        public final Builder nonKeyAttributes(Collection<String> nonKeyAttributes) {
            this.nonKeyAttributes = NonKeyAttributeNameListCopier.copy(nonKeyAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nonKeyAttributes(String ... nonKeyAttributes) {
            this.nonKeyAttributes(Arrays.asList(nonKeyAttributes));
            return this;
        }

        public final void setNonKeyAttributes(Collection<String> nonKeyAttributes) {
            this.nonKeyAttributes = NonKeyAttributeNameListCopier.copy(nonKeyAttributes);
        }

        public Projection build() {
            return new Projection(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Projection> {
        public Builder projectionType(String var1);

        public Builder projectionType(ProjectionType var1);

        public Builder nonKeyAttributes(Collection<String> var1);

        public Builder nonKeyAttributes(String ... var1);
    }
}

