/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaCopier;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import software.amazon.awssdk.services.dynamodb.model.Projection;
import software.amazon.awssdk.services.dynamodb.transform.LocalSecondaryIndexDescriptionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class LocalSecondaryIndexDescription
implements StructuredPojo,
ToCopyableBuilder<Builder, LocalSecondaryIndexDescription> {
    private final String indexName;
    private final List<KeySchemaElement> keySchema;
    private final Projection projection;
    private final Long indexSizeBytes;
    private final Long itemCount;
    private final String indexArn;

    private LocalSecondaryIndexDescription(BuilderImpl builder) {
        this.indexName = builder.indexName;
        this.keySchema = builder.keySchema;
        this.projection = builder.projection;
        this.indexSizeBytes = builder.indexSizeBytes;
        this.itemCount = builder.itemCount;
        this.indexArn = builder.indexArn;
    }

    public String indexName() {
        return this.indexName;
    }

    public List<KeySchemaElement> keySchema() {
        return this.keySchema;
    }

    public Projection projection() {
        return this.projection;
    }

    public Long indexSizeBytes() {
        return this.indexSizeBytes;
    }

    public Long itemCount() {
        return this.itemCount;
    }

    public String indexArn() {
        return this.indexArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.indexName());
        hashCode = 31 * hashCode + Objects.hashCode(this.keySchema());
        hashCode = 31 * hashCode + Objects.hashCode(this.projection());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexSizeBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.itemCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LocalSecondaryIndexDescription)) {
            return false;
        }
        LocalSecondaryIndexDescription other = (LocalSecondaryIndexDescription)obj;
        return Objects.equals(this.indexName(), other.indexName()) && Objects.equals(this.keySchema(), other.keySchema()) && Objects.equals(this.projection(), other.projection()) && Objects.equals(this.indexSizeBytes(), other.indexSizeBytes()) && Objects.equals(this.itemCount(), other.itemCount()) && Objects.equals(this.indexArn(), other.indexArn());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.indexName() != null) {
            sb.append("IndexName: ").append(this.indexName()).append(",");
        }
        if (this.keySchema() != null) {
            sb.append("KeySchema: ").append(this.keySchema()).append(",");
        }
        if (this.projection() != null) {
            sb.append("Projection: ").append(this.projection()).append(",");
        }
        if (this.indexSizeBytes() != null) {
            sb.append("IndexSizeBytes: ").append(this.indexSizeBytes()).append(",");
        }
        if (this.itemCount() != null) {
            sb.append("ItemCount: ").append(this.itemCount()).append(",");
        }
        if (this.indexArn() != null) {
            sb.append("IndexArn: ").append(this.indexArn()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IndexName": {
                return Optional.of(clazz.cast(this.indexName()));
            }
            case "KeySchema": {
                return Optional.of(clazz.cast(this.keySchema()));
            }
            case "Projection": {
                return Optional.of(clazz.cast(this.projection()));
            }
            case "IndexSizeBytes": {
                return Optional.of(clazz.cast(this.indexSizeBytes()));
            }
            case "ItemCount": {
                return Optional.of(clazz.cast(this.itemCount()));
            }
            case "IndexArn": {
                return Optional.of(clazz.cast(this.indexArn()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LocalSecondaryIndexDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String indexName;
        private List<KeySchemaElement> keySchema;
        private Projection projection;
        private Long indexSizeBytes;
        private Long itemCount;
        private String indexArn;

        private BuilderImpl() {
        }

        private BuilderImpl(LocalSecondaryIndexDescription model) {
            this.indexName(model.indexName);
            this.keySchema(model.keySchema);
            this.projection(model.projection);
            this.indexSizeBytes(model.indexSizeBytes);
            this.itemCount(model.itemCount);
            this.indexArn(model.indexArn);
        }

        public final String getIndexName() {
            return this.indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        public final Collection<KeySchemaElement.Builder> getKeySchema() {
            return this.keySchema != null ? (Collection)this.keySchema.stream().map(KeySchemaElement::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder keySchema(Collection<KeySchemaElement> keySchema) {
            this.keySchema = KeySchemaCopier.copy(keySchema);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keySchema(KeySchemaElement ... keySchema) {
            this.keySchema(Arrays.asList(keySchema));
            return this;
        }

        public final void setKeySchema(Collection<KeySchemaElement.BuilderImpl> keySchema) {
            this.keySchema = KeySchemaCopier.copyFromBuilder(keySchema);
        }

        public final Projection.Builder getProjection() {
            return this.projection != null ? this.projection.toBuilder() : null;
        }

        @Override
        public final Builder projection(Projection projection) {
            this.projection = projection;
            return this;
        }

        public final void setProjection(Projection.BuilderImpl projection) {
            this.projection = projection != null ? projection.build() : null;
        }

        public final Long getIndexSizeBytes() {
            return this.indexSizeBytes;
        }

        @Override
        public final Builder indexSizeBytes(Long indexSizeBytes) {
            this.indexSizeBytes = indexSizeBytes;
            return this;
        }

        public final void setIndexSizeBytes(Long indexSizeBytes) {
            this.indexSizeBytes = indexSizeBytes;
        }

        public final Long getItemCount() {
            return this.itemCount;
        }

        @Override
        public final Builder itemCount(Long itemCount) {
            this.itemCount = itemCount;
            return this;
        }

        public final void setItemCount(Long itemCount) {
            this.itemCount = itemCount;
        }

        public final String getIndexArn() {
            return this.indexArn;
        }

        @Override
        public final Builder indexArn(String indexArn) {
            this.indexArn = indexArn;
            return this;
        }

        public final void setIndexArn(String indexArn) {
            this.indexArn = indexArn;
        }

        public LocalSecondaryIndexDescription build() {
            return new LocalSecondaryIndexDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LocalSecondaryIndexDescription> {
        public Builder indexName(String var1);

        public Builder keySchema(Collection<KeySchemaElement> var1);

        public Builder keySchema(KeySchemaElement ... var1);

        public Builder projection(Projection var1);

        default public Builder projection(Consumer<Projection.Builder> projection) {
            return this.projection((Projection)((Projection.Builder)Projection.builder().apply(projection)).build());
        }

        public Builder indexSizeBytes(Long var1);

        public Builder itemCount(Long var1);

        public Builder indexArn(String var1);
    }
}

