/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.dynamodb.model.AttributeNameListCopier;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ExpressionAttributeNameMapCopier;
import software.amazon.awssdk.services.dynamodb.model.KeyCopier;
import software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetItemRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetItemRequest> {
    private final String tableName;
    private final Map<String, AttributeValue> key;
    private final List<String> attributesToGet;
    private final Boolean consistentRead;
    private final String returnConsumedCapacity;
    private final String projectionExpression;
    private final Map<String, String> expressionAttributeNames;

    private GetItemRequest(BuilderImpl builder) {
        this.tableName = builder.tableName;
        this.key = builder.key;
        this.attributesToGet = builder.attributesToGet;
        this.consistentRead = builder.consistentRead;
        this.returnConsumedCapacity = builder.returnConsumedCapacity;
        this.projectionExpression = builder.projectionExpression;
        this.expressionAttributeNames = builder.expressionAttributeNames;
    }

    public String tableName() {
        return this.tableName;
    }

    public Map<String, AttributeValue> key() {
        return this.key;
    }

    public List<String> attributesToGet() {
        return this.attributesToGet;
    }

    public Boolean consistentRead() {
        return this.consistentRead;
    }

    public ReturnConsumedCapacity returnConsumedCapacity() {
        return ReturnConsumedCapacity.fromValue(this.returnConsumedCapacity);
    }

    public String returnConsumedCapacityString() {
        return this.returnConsumedCapacity;
    }

    public String projectionExpression() {
        return this.projectionExpression;
    }

    public Map<String, String> expressionAttributeNames() {
        return this.expressionAttributeNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributesToGet());
        hashCode = 31 * hashCode + Objects.hashCode(this.consistentRead());
        hashCode = 31 * hashCode + Objects.hashCode(this.returnConsumedCapacityString());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.expressionAttributeNames());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetItemRequest)) {
            return false;
        }
        GetItemRequest other = (GetItemRequest)((Object)obj);
        return Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.key(), other.key()) && Objects.equals(this.attributesToGet(), other.attributesToGet()) && Objects.equals(this.consistentRead(), other.consistentRead()) && Objects.equals(this.returnConsumedCapacityString(), other.returnConsumedCapacityString()) && Objects.equals(this.projectionExpression(), other.projectionExpression()) && Objects.equals(this.expressionAttributeNames(), other.expressionAttributeNames());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.tableName() != null) {
            sb.append("TableName: ").append(this.tableName()).append(",");
        }
        if (this.key() != null) {
            sb.append("Key: ").append(this.key()).append(",");
        }
        if (this.attributesToGet() != null) {
            sb.append("AttributesToGet: ").append(this.attributesToGet()).append(",");
        }
        if (this.consistentRead() != null) {
            sb.append("ConsistentRead: ").append(this.consistentRead()).append(",");
        }
        if (this.returnConsumedCapacityString() != null) {
            sb.append("ReturnConsumedCapacity: ").append(this.returnConsumedCapacityString()).append(",");
        }
        if (this.projectionExpression() != null) {
            sb.append("ProjectionExpression: ").append(this.projectionExpression()).append(",");
        }
        if (this.expressionAttributeNames() != null) {
            sb.append("ExpressionAttributeNames: ").append(this.expressionAttributeNames()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TableName": {
                return Optional.of(clazz.cast(this.tableName()));
            }
            case "Key": {
                return Optional.of(clazz.cast(this.key()));
            }
            case "AttributesToGet": {
                return Optional.of(clazz.cast(this.attributesToGet()));
            }
            case "ConsistentRead": {
                return Optional.of(clazz.cast(this.consistentRead()));
            }
            case "ReturnConsumedCapacity": {
                return Optional.of(clazz.cast(this.returnConsumedCapacityString()));
            }
            case "ProjectionExpression": {
                return Optional.of(clazz.cast(this.projectionExpression()));
            }
            case "ExpressionAttributeNames": {
                return Optional.of(clazz.cast(this.expressionAttributeNames()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String tableName;
        private Map<String, AttributeValue> key;
        private List<String> attributesToGet;
        private Boolean consistentRead;
        private String returnConsumedCapacity;
        private String projectionExpression;
        private Map<String, String> expressionAttributeNames;

        private BuilderImpl() {
        }

        private BuilderImpl(GetItemRequest model) {
            this.tableName(model.tableName);
            this.key(model.key);
            this.attributesToGet(model.attributesToGet);
            this.consistentRead(model.consistentRead);
            this.returnConsumedCapacity(model.returnConsumedCapacity);
            this.projectionExpression(model.projectionExpression);
            this.expressionAttributeNames(model.expressionAttributeNames);
        }

        public final String getTableName() {
            return this.tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final Map<String, AttributeValue.Builder> getKey() {
            return this.key != null ? CollectionUtils.mapValues(this.key, AttributeValue::toBuilder) : null;
        }

        @Override
        public final Builder key(Map<String, AttributeValue> key) {
            this.key = KeyCopier.copy(key);
            return this;
        }

        public final void setKey(Map<String, AttributeValue.BuilderImpl> key) {
            this.key = KeyCopier.copyFromBuilder(key);
        }

        public final Collection<String> getAttributesToGet() {
            return this.attributesToGet;
        }

        @Override
        public final Builder attributesToGet(Collection<String> attributesToGet) {
            this.attributesToGet = AttributeNameListCopier.copy(attributesToGet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributesToGet(String ... attributesToGet) {
            this.attributesToGet(Arrays.asList(attributesToGet));
            return this;
        }

        public final void setAttributesToGet(Collection<String> attributesToGet) {
            this.attributesToGet = AttributeNameListCopier.copy(attributesToGet);
        }

        public final Boolean getConsistentRead() {
            return this.consistentRead;
        }

        @Override
        public final Builder consistentRead(Boolean consistentRead) {
            this.consistentRead = consistentRead;
            return this;
        }

        public final void setConsistentRead(Boolean consistentRead) {
            this.consistentRead = consistentRead;
        }

        public final String getReturnConsumedCapacity() {
            return this.returnConsumedCapacity;
        }

        @Override
        public final Builder returnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
            return this;
        }

        @Override
        public final Builder returnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
            this.returnConsumedCapacity(returnConsumedCapacity.toString());
            return this;
        }

        public final void setReturnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
        }

        public final String getProjectionExpression() {
            return this.projectionExpression;
        }

        @Override
        public final Builder projectionExpression(String projectionExpression) {
            this.projectionExpression = projectionExpression;
            return this;
        }

        public final void setProjectionExpression(String projectionExpression) {
            this.projectionExpression = projectionExpression;
        }

        public final Map<String, String> getExpressionAttributeNames() {
            return this.expressionAttributeNames;
        }

        @Override
        public final Builder expressionAttributeNames(Map<String, String> expressionAttributeNames) {
            this.expressionAttributeNames = ExpressionAttributeNameMapCopier.copy(expressionAttributeNames);
            return this;
        }

        public final void setExpressionAttributeNames(Map<String, String> expressionAttributeNames) {
            this.expressionAttributeNames = ExpressionAttributeNameMapCopier.copy(expressionAttributeNames);
        }

        public GetItemRequest build() {
            return new GetItemRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetItemRequest> {
        public Builder tableName(String var1);

        public Builder key(Map<String, AttributeValue> var1);

        public Builder attributesToGet(Collection<String> var1);

        public Builder attributesToGet(String ... var1);

        public Builder consistentRead(Boolean var1);

        public Builder returnConsumedCapacity(String var1);

        public Builder returnConsumedCapacity(ReturnConsumedCapacity var1);

        public Builder projectionExpression(String var1);

        public Builder expressionAttributeNames(Map<String, String> var1);
    }
}

