/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;

@SdkInternalApi
public class KeySchemaElementMarshaller {
    private static final MarshallingInfo<String> ATTRIBUTENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttributeName").build();
    private static final MarshallingInfo<String> KEYTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyType").build();
    private static final KeySchemaElementMarshaller INSTANCE = new KeySchemaElementMarshaller();

    public static KeySchemaElementMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(KeySchemaElement keySchemaElement, ProtocolMarshaller protocolMarshaller) {
        if (keySchemaElement == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)keySchemaElement.attributeName(), ATTRIBUTENAME_BINDING);
            protocolMarshaller.marshall((Object)keySchemaElement.keyTypeString(), KEYTYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

