/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Map;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ConditionalOperator;
import software.amazon.awssdk.services.dynamodb.model.ExpectedAttributeMapCopier;
import software.amazon.awssdk.services.dynamodb.model.ExpectedAttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ExpressionAttributeNameMapCopier;
import software.amazon.awssdk.services.dynamodb.model.ExpressionAttributeValueMapCopier;
import software.amazon.awssdk.services.dynamodb.model.PutItemInputAttributeMapCopier;
import software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.ReturnItemCollectionMetrics;
import software.amazon.awssdk.services.dynamodb.model.ReturnValue;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutItemRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, PutItemRequest> {
    private final String tableName;
    private final Map<String, AttributeValue> item;
    private final Map<String, ExpectedAttributeValue> expected;
    private final String returnValues;
    private final String returnConsumedCapacity;
    private final String returnItemCollectionMetrics;
    private final String conditionalOperator;
    private final String conditionExpression;
    private final Map<String, String> expressionAttributeNames;
    private final Map<String, AttributeValue> expressionAttributeValues;

    private PutItemRequest(BuilderImpl builder) {
        this.tableName = builder.tableName;
        this.item = builder.item;
        this.expected = builder.expected;
        this.returnValues = builder.returnValues;
        this.returnConsumedCapacity = builder.returnConsumedCapacity;
        this.returnItemCollectionMetrics = builder.returnItemCollectionMetrics;
        this.conditionalOperator = builder.conditionalOperator;
        this.conditionExpression = builder.conditionExpression;
        this.expressionAttributeNames = builder.expressionAttributeNames;
        this.expressionAttributeValues = builder.expressionAttributeValues;
    }

    public String tableName() {
        return this.tableName;
    }

    public Map<String, AttributeValue> item() {
        return this.item;
    }

    public Map<String, ExpectedAttributeValue> expected() {
        return this.expected;
    }

    public ReturnValue returnValues() {
        return ReturnValue.fromValue(this.returnValues);
    }

    public String returnValuesString() {
        return this.returnValues;
    }

    public ReturnConsumedCapacity returnConsumedCapacity() {
        return ReturnConsumedCapacity.fromValue(this.returnConsumedCapacity);
    }

    public String returnConsumedCapacityString() {
        return this.returnConsumedCapacity;
    }

    public ReturnItemCollectionMetrics returnItemCollectionMetrics() {
        return ReturnItemCollectionMetrics.fromValue(this.returnItemCollectionMetrics);
    }

    public String returnItemCollectionMetricsString() {
        return this.returnItemCollectionMetrics;
    }

    public ConditionalOperator conditionalOperator() {
        return ConditionalOperator.fromValue(this.conditionalOperator);
    }

    public String conditionalOperatorString() {
        return this.conditionalOperator;
    }

    public String conditionExpression() {
        return this.conditionExpression;
    }

    public Map<String, String> expressionAttributeNames() {
        return this.expressionAttributeNames;
    }

    public Map<String, AttributeValue> expressionAttributeValues() {
        return this.expressionAttributeValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.tableName() == null ? 0 : this.tableName().hashCode());
        hashCode = 31 * hashCode + (this.item() == null ? 0 : this.item().hashCode());
        hashCode = 31 * hashCode + (this.expected() == null ? 0 : this.expected().hashCode());
        hashCode = 31 * hashCode + (this.returnValuesString() == null ? 0 : this.returnValuesString().hashCode());
        hashCode = 31 * hashCode + (this.returnConsumedCapacityString() == null ? 0 : this.returnConsumedCapacityString().hashCode());
        hashCode = 31 * hashCode + (this.returnItemCollectionMetricsString() == null ? 0 : this.returnItemCollectionMetricsString().hashCode());
        hashCode = 31 * hashCode + (this.conditionalOperatorString() == null ? 0 : this.conditionalOperatorString().hashCode());
        hashCode = 31 * hashCode + (this.conditionExpression() == null ? 0 : this.conditionExpression().hashCode());
        hashCode = 31 * hashCode + (this.expressionAttributeNames() == null ? 0 : this.expressionAttributeNames().hashCode());
        hashCode = 31 * hashCode + (this.expressionAttributeValues() == null ? 0 : this.expressionAttributeValues().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutItemRequest)) {
            return false;
        }
        PutItemRequest other = (PutItemRequest)((Object)obj);
        if (other.tableName() == null ^ this.tableName() == null) {
            return false;
        }
        if (other.tableName() != null && !other.tableName().equals(this.tableName())) {
            return false;
        }
        if (other.item() == null ^ this.item() == null) {
            return false;
        }
        if (other.item() != null && !other.item().equals(this.item())) {
            return false;
        }
        if (other.expected() == null ^ this.expected() == null) {
            return false;
        }
        if (other.expected() != null && !other.expected().equals(this.expected())) {
            return false;
        }
        if (other.returnValuesString() == null ^ this.returnValuesString() == null) {
            return false;
        }
        if (other.returnValuesString() != null && !other.returnValuesString().equals(this.returnValuesString())) {
            return false;
        }
        if (other.returnConsumedCapacityString() == null ^ this.returnConsumedCapacityString() == null) {
            return false;
        }
        if (other.returnConsumedCapacityString() != null && !other.returnConsumedCapacityString().equals(this.returnConsumedCapacityString())) {
            return false;
        }
        if (other.returnItemCollectionMetricsString() == null ^ this.returnItemCollectionMetricsString() == null) {
            return false;
        }
        if (other.returnItemCollectionMetricsString() != null && !other.returnItemCollectionMetricsString().equals(this.returnItemCollectionMetricsString())) {
            return false;
        }
        if (other.conditionalOperatorString() == null ^ this.conditionalOperatorString() == null) {
            return false;
        }
        if (other.conditionalOperatorString() != null && !other.conditionalOperatorString().equals(this.conditionalOperatorString())) {
            return false;
        }
        if (other.conditionExpression() == null ^ this.conditionExpression() == null) {
            return false;
        }
        if (other.conditionExpression() != null && !other.conditionExpression().equals(this.conditionExpression())) {
            return false;
        }
        if (other.expressionAttributeNames() == null ^ this.expressionAttributeNames() == null) {
            return false;
        }
        if (other.expressionAttributeNames() != null && !other.expressionAttributeNames().equals(this.expressionAttributeNames())) {
            return false;
        }
        if (other.expressionAttributeValues() == null ^ this.expressionAttributeValues() == null) {
            return false;
        }
        return other.expressionAttributeValues() == null || other.expressionAttributeValues().equals(this.expressionAttributeValues());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.tableName() != null) {
            sb.append("TableName: ").append(this.tableName()).append(",");
        }
        if (this.item() != null) {
            sb.append("Item: ").append(this.item()).append(",");
        }
        if (this.expected() != null) {
            sb.append("Expected: ").append(this.expected()).append(",");
        }
        if (this.returnValuesString() != null) {
            sb.append("ReturnValues: ").append(this.returnValuesString()).append(",");
        }
        if (this.returnConsumedCapacityString() != null) {
            sb.append("ReturnConsumedCapacity: ").append(this.returnConsumedCapacityString()).append(",");
        }
        if (this.returnItemCollectionMetricsString() != null) {
            sb.append("ReturnItemCollectionMetrics: ").append(this.returnItemCollectionMetricsString()).append(",");
        }
        if (this.conditionalOperatorString() != null) {
            sb.append("ConditionalOperator: ").append(this.conditionalOperatorString()).append(",");
        }
        if (this.conditionExpression() != null) {
            sb.append("ConditionExpression: ").append(this.conditionExpression()).append(",");
        }
        if (this.expressionAttributeNames() != null) {
            sb.append("ExpressionAttributeNames: ").append(this.expressionAttributeNames()).append(",");
        }
        if (this.expressionAttributeValues() != null) {
            sb.append("ExpressionAttributeValues: ").append(this.expressionAttributeValues()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TableName": {
                return Optional.of(clazz.cast(this.tableName()));
            }
            case "Item": {
                return Optional.of(clazz.cast(this.item()));
            }
            case "Expected": {
                return Optional.of(clazz.cast(this.expected()));
            }
            case "ReturnValues": {
                return Optional.of(clazz.cast(this.returnValuesString()));
            }
            case "ReturnConsumedCapacity": {
                return Optional.of(clazz.cast(this.returnConsumedCapacityString()));
            }
            case "ReturnItemCollectionMetrics": {
                return Optional.of(clazz.cast(this.returnItemCollectionMetricsString()));
            }
            case "ConditionalOperator": {
                return Optional.of(clazz.cast(this.conditionalOperatorString()));
            }
            case "ConditionExpression": {
                return Optional.of(clazz.cast(this.conditionExpression()));
            }
            case "ExpressionAttributeNames": {
                return Optional.of(clazz.cast(this.expressionAttributeNames()));
            }
            case "ExpressionAttributeValues": {
                return Optional.of(clazz.cast(this.expressionAttributeValues()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String tableName;
        private Map<String, AttributeValue> item;
        private Map<String, ExpectedAttributeValue> expected;
        private String returnValues;
        private String returnConsumedCapacity;
        private String returnItemCollectionMetrics;
        private String conditionalOperator;
        private String conditionExpression;
        private Map<String, String> expressionAttributeNames;
        private Map<String, AttributeValue> expressionAttributeValues;

        private BuilderImpl() {
        }

        private BuilderImpl(PutItemRequest model) {
            this.tableName(model.tableName);
            this.item(model.item);
            this.expected(model.expected);
            this.returnValues(model.returnValues);
            this.returnConsumedCapacity(model.returnConsumedCapacity);
            this.returnItemCollectionMetrics(model.returnItemCollectionMetrics);
            this.conditionalOperator(model.conditionalOperator);
            this.conditionExpression(model.conditionExpression);
            this.expressionAttributeNames(model.expressionAttributeNames);
            this.expressionAttributeValues(model.expressionAttributeValues);
        }

        public final String getTableName() {
            return this.tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final Map<String, AttributeValue.Builder> getItem() {
            return this.item != null ? CollectionUtils.mapValues(this.item, AttributeValue::toBuilder) : null;
        }

        @Override
        public final Builder item(Map<String, AttributeValue> item) {
            this.item = PutItemInputAttributeMapCopier.copy(item);
            return this;
        }

        public final void setItem(Map<String, AttributeValue.BuilderImpl> item) {
            this.item = PutItemInputAttributeMapCopier.copyFromBuilder(item);
        }

        public final Map<String, ExpectedAttributeValue.Builder> getExpected() {
            return this.expected != null ? CollectionUtils.mapValues(this.expected, ExpectedAttributeValue::toBuilder) : null;
        }

        @Override
        public final Builder expected(Map<String, ExpectedAttributeValue> expected) {
            this.expected = ExpectedAttributeMapCopier.copy(expected);
            return this;
        }

        public final void setExpected(Map<String, ExpectedAttributeValue.BuilderImpl> expected) {
            this.expected = ExpectedAttributeMapCopier.copyFromBuilder(expected);
        }

        public final String getReturnValues() {
            return this.returnValues;
        }

        @Override
        public final Builder returnValues(String returnValues) {
            this.returnValues = returnValues;
            return this;
        }

        @Override
        public final Builder returnValues(ReturnValue returnValues) {
            this.returnValues(returnValues.toString());
            return this;
        }

        public final void setReturnValues(String returnValues) {
            this.returnValues = returnValues;
        }

        public final String getReturnConsumedCapacity() {
            return this.returnConsumedCapacity;
        }

        @Override
        public final Builder returnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
            return this;
        }

        @Override
        public final Builder returnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
            this.returnConsumedCapacity(returnConsumedCapacity.toString());
            return this;
        }

        public final void setReturnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
        }

        public final String getReturnItemCollectionMetrics() {
            return this.returnItemCollectionMetrics;
        }

        @Override
        public final Builder returnItemCollectionMetrics(String returnItemCollectionMetrics) {
            this.returnItemCollectionMetrics = returnItemCollectionMetrics;
            return this;
        }

        @Override
        public final Builder returnItemCollectionMetrics(ReturnItemCollectionMetrics returnItemCollectionMetrics) {
            this.returnItemCollectionMetrics(returnItemCollectionMetrics.toString());
            return this;
        }

        public final void setReturnItemCollectionMetrics(String returnItemCollectionMetrics) {
            this.returnItemCollectionMetrics = returnItemCollectionMetrics;
        }

        public final String getConditionalOperator() {
            return this.conditionalOperator;
        }

        @Override
        public final Builder conditionalOperator(String conditionalOperator) {
            this.conditionalOperator = conditionalOperator;
            return this;
        }

        @Override
        public final Builder conditionalOperator(ConditionalOperator conditionalOperator) {
            this.conditionalOperator(conditionalOperator.toString());
            return this;
        }

        public final void setConditionalOperator(String conditionalOperator) {
            this.conditionalOperator = conditionalOperator;
        }

        public final String getConditionExpression() {
            return this.conditionExpression;
        }

        @Override
        public final Builder conditionExpression(String conditionExpression) {
            this.conditionExpression = conditionExpression;
            return this;
        }

        public final void setConditionExpression(String conditionExpression) {
            this.conditionExpression = conditionExpression;
        }

        public final Map<String, String> getExpressionAttributeNames() {
            return this.expressionAttributeNames;
        }

        @Override
        public final Builder expressionAttributeNames(Map<String, String> expressionAttributeNames) {
            this.expressionAttributeNames = ExpressionAttributeNameMapCopier.copy(expressionAttributeNames);
            return this;
        }

        public final void setExpressionAttributeNames(Map<String, String> expressionAttributeNames) {
            this.expressionAttributeNames = ExpressionAttributeNameMapCopier.copy(expressionAttributeNames);
        }

        public final Map<String, AttributeValue.Builder> getExpressionAttributeValues() {
            return this.expressionAttributeValues != null ? CollectionUtils.mapValues(this.expressionAttributeValues, AttributeValue::toBuilder) : null;
        }

        @Override
        public final Builder expressionAttributeValues(Map<String, AttributeValue> expressionAttributeValues) {
            this.expressionAttributeValues = ExpressionAttributeValueMapCopier.copy(expressionAttributeValues);
            return this;
        }

        public final void setExpressionAttributeValues(Map<String, AttributeValue.BuilderImpl> expressionAttributeValues) {
            this.expressionAttributeValues = ExpressionAttributeValueMapCopier.copyFromBuilder(expressionAttributeValues);
        }

        public PutItemRequest build() {
            return new PutItemRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PutItemRequest> {
        public Builder tableName(String var1);

        public Builder item(Map<String, AttributeValue> var1);

        public Builder expected(Map<String, ExpectedAttributeValue> var1);

        public Builder returnValues(String var1);

        public Builder returnValues(ReturnValue var1);

        public Builder returnConsumedCapacity(String var1);

        public Builder returnConsumedCapacity(ReturnConsumedCapacity var1);

        public Builder returnItemCollectionMetrics(String var1);

        public Builder returnItemCollectionMetrics(ReturnItemCollectionMetrics var1);

        public Builder conditionalOperator(String var1);

        public Builder conditionalOperator(ConditionalOperator var1);

        public Builder conditionExpression(String var1);

        public Builder expressionAttributeNames(Map<String, String> var1);

        public Builder expressionAttributeValues(Map<String, AttributeValue> var1);
    }
}

