/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.ExpectedAttributeValue;

@SdkInternalApi
public class ExpectedAttributeValueMarshaller {
    private static final MarshallingInfo<StructuredPojo> VALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Value").build();
    private static final MarshallingInfo<Boolean> EXISTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Exists").build();
    private static final MarshallingInfo<String> COMPARISONOPERATOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComparisonOperator").build();
    private static final MarshallingInfo<List> ATTRIBUTEVALUELIST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttributeValueList").build();
    private static final ExpectedAttributeValueMarshaller INSTANCE = new ExpectedAttributeValueMarshaller();

    public static ExpectedAttributeValueMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ExpectedAttributeValue expectedAttributeValue, ProtocolMarshaller protocolMarshaller) {
        if (expectedAttributeValue == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)expectedAttributeValue.value(), VALUE_BINDING);
            protocolMarshaller.marshall((Object)expectedAttributeValue.exists(), EXISTS_BINDING);
            protocolMarshaller.marshall((Object)expectedAttributeValue.comparisonOperator(), COMPARISONOPERATOR_BINDING);
            protocolMarshaller.marshall(expectedAttributeValue.attributeValueList(), ATTRIBUTEVALUELIST_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

