/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.document.internal;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.dynamodb.DynamoDBClient;
import software.amazon.awssdk.services.dynamodb.document.ItemCollection;
import software.amazon.awssdk.services.dynamodb.document.KeyAttribute;
import software.amazon.awssdk.services.dynamodb.document.KeyConditions;
import software.amazon.awssdk.services.dynamodb.document.QueryFilter;
import software.amazon.awssdk.services.dynamodb.document.QueryOutcome;
import software.amazon.awssdk.services.dynamodb.document.RangeKeyCondition;
import software.amazon.awssdk.services.dynamodb.document.Table;
import software.amazon.awssdk.services.dynamodb.document.api.QueryApi;
import software.amazon.awssdk.services.dynamodb.document.internal.AbstractImpl;
import software.amazon.awssdk.services.dynamodb.document.internal.InternalUtils;
import software.amazon.awssdk.services.dynamodb.document.internal.QueryCollection;
import software.amazon.awssdk.services.dynamodb.document.spec.QuerySpec;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ComparisonOperator;
import software.amazon.awssdk.services.dynamodb.model.Condition;
import software.amazon.awssdk.services.dynamodb.model.QueryRequest;

public class QueryImpl
extends AbstractImpl
implements QueryApi {
    public QueryImpl(DynamoDBClient client, Table table) {
        super(client, table);
    }

    @Override
    public ItemCollection<QueryOutcome> query(String hashKeyName, Object hashKey) {
        return this.doQuery(new QuerySpec().withHashKey(new KeyAttribute(hashKeyName, hashKey)));
    }

    @Override
    public ItemCollection<QueryOutcome> query(KeyAttribute hashKey) {
        return this.doQuery(new QuerySpec().withHashKey(hashKey));
    }

    @Override
    public ItemCollection<QueryOutcome> query(KeyAttribute hashKey, RangeKeyCondition rangeKeyCondition) {
        return this.doQuery(new QuerySpec().withHashKey(hashKey).withRangeKeyCondition(rangeKeyCondition));
    }

    @Override
    public ItemCollection<QueryOutcome> query(KeyAttribute hashKey, RangeKeyCondition rangeKeyCondition, QueryFilter ... queryFilters) {
        return this.doQuery(new QuerySpec().withHashKey(hashKey).withRangeKeyCondition(rangeKeyCondition).withQueryFilters(queryFilters));
    }

    @Override
    public ItemCollection<QueryOutcome> query(KeyAttribute hashKey, RangeKeyCondition rangeKeyCondition, String filterExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.doQuery(new QuerySpec().withHashKey(hashKey).withRangeKeyCondition(rangeKeyCondition).withFilterExpression(filterExpression).withNameMap(nameMap).valueMap(valueMap));
    }

    @Override
    public ItemCollection<QueryOutcome> query(KeyAttribute hashKey, RangeKeyCondition rangeKeyCondition, String filterExpression, String projectionExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.doQuery(new QuerySpec().withHashKey(hashKey).withRangeKeyCondition(rangeKeyCondition).withFilterExpression(filterExpression).withProjectionExpression(projectionExpression).withNameMap(nameMap).valueMap(valueMap));
    }

    @Override
    public ItemCollection<QueryOutcome> query(QuerySpec spec) {
        return this.doQuery(spec);
    }

    protected ItemCollection<QueryOutcome> doQuery(QuerySpec spec) {
        Collection<KeyAttribute> startKey;
        RangeKeyCondition rangeKeyCond;
        KeyAttribute hashKey;
        String tableName = this.getTable().getTableName();
        QueryRequest.Builder requestBuilder = ((QueryRequest)((Object)spec.getRequest())).toBuilder().tableName(tableName);
        LinkedHashMap<String, Condition> conditions = new LinkedHashMap<String, Condition>();
        if (((QueryRequest)((Object)spec.getRequest())).keyConditions() != null) {
            conditions.putAll(((QueryRequest)((Object)spec.getRequest())).keyConditions());
        }
        if ((hashKey = spec.getHashKey()) != null) {
            conditions.put(hashKey.name(), (Condition)Condition.builder().comparisonOperator(ComparisonOperator.EQ).attributeValueList(InternalUtils.toAttributeValue(hashKey.value())).build());
        }
        if ((rangeKeyCond = spec.getRangeKeyCondition()) != null) {
            KeyConditions keyCond = rangeKeyCond.getKeyCondition();
            if (keyCond == null) {
                throw new IllegalArgumentException("key condition not specified in range key condition");
            }
            Object[] values = rangeKeyCond.values();
            if (values == null) {
                throw new IllegalArgumentException("key condition values not specified in range key condition");
            }
            conditions.put(rangeKeyCond.getAttrName(), (Condition)Condition.builder().comparisonOperator(keyCond.toComparisonOperator()).attributeValueList(InternalUtils.toAttributeValues(values)).build());
        }
        requestBuilder.keyConditions(conditions);
        Collection<QueryFilter> filters = spec.getQueryFilters();
        if (filters != null) {
            requestBuilder.queryFilter(InternalUtils.toAttributeConditionMap(filters));
        }
        if ((startKey = spec.getExclusiveStartKey()) != null) {
            requestBuilder.exclusiveStartKey(InternalUtils.toAttributeValueMap(startKey));
        }
        Map<String, AttributeValue> attrValMap = InternalUtils.fromSimpleMap(spec.valueMap());
        requestBuilder.expressionAttributeNames(spec.nameMap()).expressionAttributeValues(attrValMap);
        spec.setRequest((AmazonWebServiceRequest)requestBuilder.build());
        return new QueryCollection(this.getClient(), spec);
    }

    @Override
    public ItemCollection<QueryOutcome> query(String hashKeyName, Object hashKeyValue, RangeKeyCondition rangeKeyCondition) {
        return this.query(new KeyAttribute(hashKeyName, hashKeyValue), rangeKeyCondition);
    }

    @Override
    public ItemCollection<QueryOutcome> query(String hashKeyName, Object hashKeyValue, RangeKeyCondition rangeKeyCondition, QueryFilter ... queryFilters) {
        return this.query(new KeyAttribute(hashKeyName, hashKeyValue), rangeKeyCondition, queryFilters);
    }

    @Override
    public ItemCollection<QueryOutcome> query(String hashKeyName, Object hashKeyValue, RangeKeyCondition rangeKeyCondition, String filterExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.query(new KeyAttribute(hashKeyName, hashKeyValue), rangeKeyCondition, filterExpression, nameMap, valueMap);
    }

    @Override
    public ItemCollection<QueryOutcome> query(String hashKeyName, Object hashKeyValue, RangeKeyCondition rangeKeyCondition, String filterExpression, String projectionExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.query(new KeyAttribute(hashKeyName, hashKeyValue), rangeKeyCondition, filterExpression, projectionExpression, nameMap, valueMap);
    }
}

