/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import java.util.Map;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.ConsumedCapacity;

@SdkInternalApi
public class ConsumedCapacityMarshaller {
    private static final MarshallingInfo<String> TABLENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableName").build();
    private static final MarshallingInfo<Double> CAPACITYUNITS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CapacityUnits").build();
    private static final MarshallingInfo<StructuredPojo> TABLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Table").build();
    private static final MarshallingInfo<Map> LOCALSECONDARYINDEXES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LocalSecondaryIndexes").build();
    private static final MarshallingInfo<Map> GLOBALSECONDARYINDEXES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GlobalSecondaryIndexes").build();
    private static final ConsumedCapacityMarshaller INSTANCE = new ConsumedCapacityMarshaller();

    public static ConsumedCapacityMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ConsumedCapacity consumedCapacity, ProtocolMarshaller protocolMarshaller) {
        if (consumedCapacity == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)consumedCapacity.tableName(), TABLENAME_BINDING);
            protocolMarshaller.marshall((Object)consumedCapacity.capacityUnits(), CAPACITYUNITS_BINDING);
            protocolMarshaller.marshall((Object)consumedCapacity.table(), TABLE_BINDING);
            protocolMarshaller.marshall(consumedCapacity.localSecondaryIndexes(), LOCALSECONDARYINDEXES_BINDING);
            protocolMarshaller.marshall(consumedCapacity.globalSecondaryIndexes(), GLOBALSECONDARYINDEXES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

