/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.AttributeValueListCopier;
import software.amazon.awssdk.services.dynamodb.model.ComparisonOperator;
import software.amazon.awssdk.services.dynamodb.transform.ExpectedAttributeValueMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ExpectedAttributeValue
implements StructuredPojo,
ToCopyableBuilder<Builder, ExpectedAttributeValue> {
    private final AttributeValue value;
    private final Boolean exists;
    private final String comparisonOperator;
    private final List<AttributeValue> attributeValueList;

    private ExpectedAttributeValue(BuilderImpl builder) {
        this.value = builder.value;
        this.exists = builder.exists;
        this.comparisonOperator = builder.comparisonOperator;
        this.attributeValueList = builder.attributeValueList;
    }

    public AttributeValue value() {
        return this.value;
    }

    public Boolean exists() {
        return this.exists;
    }

    public String comparisonOperator() {
        return this.comparisonOperator;
    }

    public List<AttributeValue> attributeValueList() {
        return this.attributeValueList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.value() == null ? 0 : this.value().hashCode());
        hashCode = 31 * hashCode + (this.exists() == null ? 0 : this.exists().hashCode());
        hashCode = 31 * hashCode + (this.comparisonOperator() == null ? 0 : this.comparisonOperator().hashCode());
        hashCode = 31 * hashCode + (this.attributeValueList() == null ? 0 : this.attributeValueList().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExpectedAttributeValue)) {
            return false;
        }
        ExpectedAttributeValue other = (ExpectedAttributeValue)obj;
        if (other.value() == null ^ this.value() == null) {
            return false;
        }
        if (other.value() != null && !other.value().equals(this.value())) {
            return false;
        }
        if (other.exists() == null ^ this.exists() == null) {
            return false;
        }
        if (other.exists() != null && !other.exists().equals(this.exists())) {
            return false;
        }
        if (other.comparisonOperator() == null ^ this.comparisonOperator() == null) {
            return false;
        }
        if (other.comparisonOperator() != null && !other.comparisonOperator().equals(this.comparisonOperator())) {
            return false;
        }
        if (other.attributeValueList() == null ^ this.attributeValueList() == null) {
            return false;
        }
        return other.attributeValueList() == null || other.attributeValueList().equals(this.attributeValueList());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.value() != null) {
            sb.append("Value: ").append(this.value()).append(",");
        }
        if (this.exists() != null) {
            sb.append("Exists: ").append(this.exists()).append(",");
        }
        if (this.comparisonOperator() != null) {
            sb.append("ComparisonOperator: ").append(this.comparisonOperator()).append(",");
        }
        if (this.attributeValueList() != null) {
            sb.append("AttributeValueList: ").append(this.attributeValueList()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ExpectedAttributeValueMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private AttributeValue value;
        private Boolean exists;
        private String comparisonOperator;
        private List<AttributeValue> attributeValueList;

        private BuilderImpl() {
        }

        private BuilderImpl(ExpectedAttributeValue model) {
            this.setValue(model.value);
            this.setExists(model.exists);
            this.setComparisonOperator(model.comparisonOperator);
            this.setAttributeValueList(model.attributeValueList);
        }

        public final AttributeValue getValue() {
            return this.value;
        }

        @Override
        public final Builder value(AttributeValue value) {
            this.value = value;
            return this;
        }

        public final void setValue(AttributeValue value) {
            this.value = value;
        }

        public final Boolean getExists() {
            return this.exists;
        }

        @Override
        public final Builder exists(Boolean exists) {
            this.exists = exists;
            return this;
        }

        public final void setExists(Boolean exists) {
            this.exists = exists;
        }

        public final String getComparisonOperator() {
            return this.comparisonOperator;
        }

        @Override
        public final Builder comparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
            return this;
        }

        @Override
        public final Builder comparisonOperator(ComparisonOperator comparisonOperator) {
            this.comparisonOperator(comparisonOperator.toString());
            return this;
        }

        public final void setComparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
        }

        public final Collection<AttributeValue> getAttributeValueList() {
            return this.attributeValueList;
        }

        @Override
        public final Builder attributeValueList(Collection<AttributeValue> attributeValueList) {
            this.attributeValueList = AttributeValueListCopier.copy(attributeValueList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeValueList(AttributeValue ... attributeValueList) {
            this.attributeValueList(Arrays.asList(attributeValueList));
            return this;
        }

        public final void setAttributeValueList(Collection<AttributeValue> attributeValueList) {
            this.attributeValueList = AttributeValueListCopier.copy(attributeValueList);
        }

        public ExpectedAttributeValue build() {
            return new ExpectedAttributeValue(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ExpectedAttributeValue> {
        public Builder value(AttributeValue var1);

        public Builder exists(Boolean var1);

        public Builder comparisonOperator(String var1);

        public Builder comparisonOperator(ComparisonOperator var1);

        public Builder attributeValueList(Collection<AttributeValue> var1);

        public Builder attributeValueList(AttributeValue ... var1);
    }
}

