/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.document.internal;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import software.amazon.awssdk.services.dynamodb.DynamoDBClient;
import software.amazon.awssdk.services.dynamodb.document.Item;
import software.amazon.awssdk.services.dynamodb.document.Page;
import software.amazon.awssdk.services.dynamodb.document.QueryOutcome;
import software.amazon.awssdk.services.dynamodb.document.internal.InternalUtils;
import software.amazon.awssdk.services.dynamodb.document.spec.QuerySpec;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.QueryRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryResponse;

class QueryPage
extends Page<Item, QueryOutcome> {
    private final DynamoDBClient client;
    private final QuerySpec spec;
    private QueryRequest request;
    private final int index;
    private final Map<String, AttributeValue> lastEvaluatedKey;

    QueryPage(DynamoDBClient client, QuerySpec spec, QueryRequest request, int index, QueryOutcome outcome) {
        super(Collections.unmodifiableList(InternalUtils.toItemList(outcome.getQueryResponse().items())), outcome);
        this.client = client;
        this.spec = spec;
        this.request = request;
        this.index = index;
        Integer max = spec.maxResultSize();
        QueryResponse result = outcome.getQueryResponse();
        List<Map<String, AttributeValue>> ilist = result.items();
        int size = ilist == null ? 0 : ilist.size();
        this.lastEvaluatedKey = max != null && index + size > max ? null : result.lastEvaluatedKey();
    }

    @Override
    public boolean hasNextPage() {
        if (this.lastEvaluatedKey == null) {
            return false;
        }
        Integer max = this.spec.maxResultSize();
        if (max == null) {
            return true;
        }
        return this.nextRequestLimit(max) > 0;
    }

    private int nextRequestLimit(int max) {
        int nextIndex = this.index + this.size();
        return InternalUtils.minimum(max - nextIndex, this.spec.maxPageSize());
    }

    @Override
    public Page<Item, QueryOutcome> nextPage() {
        if (this.lastEvaluatedKey == null) {
            throw new NoSuchElementException("No more pages");
        }
        Integer max = this.spec.maxResultSize();
        if (max != null) {
            int nextLimit = this.nextRequestLimit(max);
            if (nextLimit == 0) {
                throw new NoSuchElementException("No more pages");
            }
            this.request = (QueryRequest)((Object)this.request.toBuilder().limit(nextLimit).build());
        }
        this.request = (QueryRequest)((Object)this.request.toBuilder().exclusiveStartKey(this.lastEvaluatedKey).build());
        QueryResponse result = this.client.query(this.request);
        int nextIndex = this.index + this.size();
        return new QueryPage(this.client, this.spec, this.request, nextIndex, new QueryOutcome(result));
    }
}

