/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.dynamodb.model.StreamRecord;
import software.amazon.awssdk.services.dynamodb.transform.AttributeValueUnmarshaller;

public class StreamRecordUnmarshaller
implements Unmarshaller<StreamRecord, JsonUnmarshallerContext> {
    private static StreamRecordUnmarshaller INSTANCE;

    public StreamRecord unmarshall(JsonUnmarshallerContext context) throws Exception {
        StreamRecord.Builder streamRecordBuilder = StreamRecord.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("ApproximateCreationDateTime", targetDepth)) {
                    context.nextToken();
                    streamRecordBuilder.approximateCreationDateTime((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("Keys", targetDepth)) {
                    context.nextToken();
                    streamRecordBuilder.keys(new MapUnmarshaller(context.getUnmarshaller(String.class), (Unmarshaller)AttributeValueUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("NewImage", targetDepth)) {
                    context.nextToken();
                    streamRecordBuilder.newImage(new MapUnmarshaller(context.getUnmarshaller(String.class), (Unmarshaller)AttributeValueUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("OldImage", targetDepth)) {
                    context.nextToken();
                    streamRecordBuilder.oldImage(new MapUnmarshaller(context.getUnmarshaller(String.class), (Unmarshaller)AttributeValueUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("SequenceNumber", targetDepth)) {
                    context.nextToken();
                    streamRecordBuilder.sequenceNumber((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("SizeBytes", targetDepth)) {
                    context.nextToken();
                    streamRecordBuilder.sizeBytes((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
                if (context.testExpression("StreamViewType", targetDepth)) {
                    context.nextToken();
                    streamRecordBuilder.streamViewType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (StreamRecord)streamRecordBuilder.build();
    }

    public static StreamRecordUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new StreamRecordUnmarshaller();
        }
        return INSTANCE;
    }
}

