/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinitionsCopier;
import software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexDescription;
import software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexDescriptionListCopier;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaCopier;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import software.amazon.awssdk.services.dynamodb.model.LocalSecondaryIndexDescription;
import software.amazon.awssdk.services.dynamodb.model.LocalSecondaryIndexDescriptionListCopier;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughputDescription;
import software.amazon.awssdk.services.dynamodb.model.StreamSpecification;
import software.amazon.awssdk.services.dynamodb.model.TableStatus;
import software.amazon.awssdk.services.dynamodb.transform.TableDescriptionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TableDescription
implements StructuredPojo,
ToCopyableBuilder<Builder, TableDescription> {
    private final List<AttributeDefinition> attributeDefinitions;
    private final String tableName;
    private final List<KeySchemaElement> keySchema;
    private final String tableStatus;
    private final Instant creationDateTime;
    private final ProvisionedThroughputDescription provisionedThroughput;
    private final Long tableSizeBytes;
    private final Long itemCount;
    private final String tableArn;
    private final List<LocalSecondaryIndexDescription> localSecondaryIndexes;
    private final List<GlobalSecondaryIndexDescription> globalSecondaryIndexes;
    private final StreamSpecification streamSpecification;
    private final String latestStreamLabel;
    private final String latestStreamArn;

    private TableDescription(BuilderImpl builder) {
        this.attributeDefinitions = builder.attributeDefinitions;
        this.tableName = builder.tableName;
        this.keySchema = builder.keySchema;
        this.tableStatus = builder.tableStatus;
        this.creationDateTime = builder.creationDateTime;
        this.provisionedThroughput = builder.provisionedThroughput;
        this.tableSizeBytes = builder.tableSizeBytes;
        this.itemCount = builder.itemCount;
        this.tableArn = builder.tableArn;
        this.localSecondaryIndexes = builder.localSecondaryIndexes;
        this.globalSecondaryIndexes = builder.globalSecondaryIndexes;
        this.streamSpecification = builder.streamSpecification;
        this.latestStreamLabel = builder.latestStreamLabel;
        this.latestStreamArn = builder.latestStreamArn;
    }

    public List<AttributeDefinition> attributeDefinitions() {
        return this.attributeDefinitions;
    }

    public String tableName() {
        return this.tableName;
    }

    public List<KeySchemaElement> keySchema() {
        return this.keySchema;
    }

    public String tableStatus() {
        return this.tableStatus;
    }

    public Instant creationDateTime() {
        return this.creationDateTime;
    }

    public ProvisionedThroughputDescription provisionedThroughput() {
        return this.provisionedThroughput;
    }

    public Long tableSizeBytes() {
        return this.tableSizeBytes;
    }

    public Long itemCount() {
        return this.itemCount;
    }

    public String tableArn() {
        return this.tableArn;
    }

    public List<LocalSecondaryIndexDescription> localSecondaryIndexes() {
        return this.localSecondaryIndexes;
    }

    public List<GlobalSecondaryIndexDescription> globalSecondaryIndexes() {
        return this.globalSecondaryIndexes;
    }

    public StreamSpecification streamSpecification() {
        return this.streamSpecification;
    }

    public String latestStreamLabel() {
        return this.latestStreamLabel;
    }

    public String latestStreamArn() {
        return this.latestStreamArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.attributeDefinitions() == null ? 0 : this.attributeDefinitions().hashCode());
        hashCode = 31 * hashCode + (this.tableName() == null ? 0 : this.tableName().hashCode());
        hashCode = 31 * hashCode + (this.keySchema() == null ? 0 : this.keySchema().hashCode());
        hashCode = 31 * hashCode + (this.tableStatus() == null ? 0 : this.tableStatus().hashCode());
        hashCode = 31 * hashCode + (this.creationDateTime() == null ? 0 : this.creationDateTime().hashCode());
        hashCode = 31 * hashCode + (this.provisionedThroughput() == null ? 0 : this.provisionedThroughput().hashCode());
        hashCode = 31 * hashCode + (this.tableSizeBytes() == null ? 0 : this.tableSizeBytes().hashCode());
        hashCode = 31 * hashCode + (this.itemCount() == null ? 0 : this.itemCount().hashCode());
        hashCode = 31 * hashCode + (this.tableArn() == null ? 0 : this.tableArn().hashCode());
        hashCode = 31 * hashCode + (this.localSecondaryIndexes() == null ? 0 : this.localSecondaryIndexes().hashCode());
        hashCode = 31 * hashCode + (this.globalSecondaryIndexes() == null ? 0 : this.globalSecondaryIndexes().hashCode());
        hashCode = 31 * hashCode + (this.streamSpecification() == null ? 0 : this.streamSpecification().hashCode());
        hashCode = 31 * hashCode + (this.latestStreamLabel() == null ? 0 : this.latestStreamLabel().hashCode());
        hashCode = 31 * hashCode + (this.latestStreamArn() == null ? 0 : this.latestStreamArn().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableDescription)) {
            return false;
        }
        TableDescription other = (TableDescription)obj;
        if (other.attributeDefinitions() == null ^ this.attributeDefinitions() == null) {
            return false;
        }
        if (other.attributeDefinitions() != null && !other.attributeDefinitions().equals(this.attributeDefinitions())) {
            return false;
        }
        if (other.tableName() == null ^ this.tableName() == null) {
            return false;
        }
        if (other.tableName() != null && !other.tableName().equals(this.tableName())) {
            return false;
        }
        if (other.keySchema() == null ^ this.keySchema() == null) {
            return false;
        }
        if (other.keySchema() != null && !other.keySchema().equals(this.keySchema())) {
            return false;
        }
        if (other.tableStatus() == null ^ this.tableStatus() == null) {
            return false;
        }
        if (other.tableStatus() != null && !other.tableStatus().equals(this.tableStatus())) {
            return false;
        }
        if (other.creationDateTime() == null ^ this.creationDateTime() == null) {
            return false;
        }
        if (other.creationDateTime() != null && !other.creationDateTime().equals(this.creationDateTime())) {
            return false;
        }
        if (other.provisionedThroughput() == null ^ this.provisionedThroughput() == null) {
            return false;
        }
        if (other.provisionedThroughput() != null && !other.provisionedThroughput().equals(this.provisionedThroughput())) {
            return false;
        }
        if (other.tableSizeBytes() == null ^ this.tableSizeBytes() == null) {
            return false;
        }
        if (other.tableSizeBytes() != null && !other.tableSizeBytes().equals(this.tableSizeBytes())) {
            return false;
        }
        if (other.itemCount() == null ^ this.itemCount() == null) {
            return false;
        }
        if (other.itemCount() != null && !other.itemCount().equals(this.itemCount())) {
            return false;
        }
        if (other.tableArn() == null ^ this.tableArn() == null) {
            return false;
        }
        if (other.tableArn() != null && !other.tableArn().equals(this.tableArn())) {
            return false;
        }
        if (other.localSecondaryIndexes() == null ^ this.localSecondaryIndexes() == null) {
            return false;
        }
        if (other.localSecondaryIndexes() != null && !other.localSecondaryIndexes().equals(this.localSecondaryIndexes())) {
            return false;
        }
        if (other.globalSecondaryIndexes() == null ^ this.globalSecondaryIndexes() == null) {
            return false;
        }
        if (other.globalSecondaryIndexes() != null && !other.globalSecondaryIndexes().equals(this.globalSecondaryIndexes())) {
            return false;
        }
        if (other.streamSpecification() == null ^ this.streamSpecification() == null) {
            return false;
        }
        if (other.streamSpecification() != null && !other.streamSpecification().equals(this.streamSpecification())) {
            return false;
        }
        if (other.latestStreamLabel() == null ^ this.latestStreamLabel() == null) {
            return false;
        }
        if (other.latestStreamLabel() != null && !other.latestStreamLabel().equals(this.latestStreamLabel())) {
            return false;
        }
        if (other.latestStreamArn() == null ^ this.latestStreamArn() == null) {
            return false;
        }
        return other.latestStreamArn() == null || other.latestStreamArn().equals(this.latestStreamArn());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.attributeDefinitions() != null) {
            sb.append("AttributeDefinitions: ").append(this.attributeDefinitions()).append(",");
        }
        if (this.tableName() != null) {
            sb.append("TableName: ").append(this.tableName()).append(",");
        }
        if (this.keySchema() != null) {
            sb.append("KeySchema: ").append(this.keySchema()).append(",");
        }
        if (this.tableStatus() != null) {
            sb.append("TableStatus: ").append(this.tableStatus()).append(",");
        }
        if (this.creationDateTime() != null) {
            sb.append("CreationDateTime: ").append(this.creationDateTime()).append(",");
        }
        if (this.provisionedThroughput() != null) {
            sb.append("ProvisionedThroughput: ").append(this.provisionedThroughput()).append(",");
        }
        if (this.tableSizeBytes() != null) {
            sb.append("TableSizeBytes: ").append(this.tableSizeBytes()).append(",");
        }
        if (this.itemCount() != null) {
            sb.append("ItemCount: ").append(this.itemCount()).append(",");
        }
        if (this.tableArn() != null) {
            sb.append("TableArn: ").append(this.tableArn()).append(",");
        }
        if (this.localSecondaryIndexes() != null) {
            sb.append("LocalSecondaryIndexes: ").append(this.localSecondaryIndexes()).append(",");
        }
        if (this.globalSecondaryIndexes() != null) {
            sb.append("GlobalSecondaryIndexes: ").append(this.globalSecondaryIndexes()).append(",");
        }
        if (this.streamSpecification() != null) {
            sb.append("StreamSpecification: ").append(this.streamSpecification()).append(",");
        }
        if (this.latestStreamLabel() != null) {
            sb.append("LatestStreamLabel: ").append(this.latestStreamLabel()).append(",");
        }
        if (this.latestStreamArn() != null) {
            sb.append("LatestStreamArn: ").append(this.latestStreamArn()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TableDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private List<AttributeDefinition> attributeDefinitions;
        private String tableName;
        private List<KeySchemaElement> keySchema;
        private String tableStatus;
        private Instant creationDateTime;
        private ProvisionedThroughputDescription provisionedThroughput;
        private Long tableSizeBytes;
        private Long itemCount;
        private String tableArn;
        private List<LocalSecondaryIndexDescription> localSecondaryIndexes;
        private List<GlobalSecondaryIndexDescription> globalSecondaryIndexes;
        private StreamSpecification streamSpecification;
        private String latestStreamLabel;
        private String latestStreamArn;

        private BuilderImpl() {
        }

        private BuilderImpl(TableDescription model) {
            this.setAttributeDefinitions(model.attributeDefinitions);
            this.setTableName(model.tableName);
            this.setKeySchema(model.keySchema);
            this.setTableStatus(model.tableStatus);
            this.setCreationDateTime(model.creationDateTime);
            this.setProvisionedThroughput(model.provisionedThroughput);
            this.setTableSizeBytes(model.tableSizeBytes);
            this.setItemCount(model.itemCount);
            this.setTableArn(model.tableArn);
            this.setLocalSecondaryIndexes(model.localSecondaryIndexes);
            this.setGlobalSecondaryIndexes(model.globalSecondaryIndexes);
            this.setStreamSpecification(model.streamSpecification);
            this.setLatestStreamLabel(model.latestStreamLabel);
            this.setLatestStreamArn(model.latestStreamArn);
        }

        public final Collection<AttributeDefinition> getAttributeDefinitions() {
            return this.attributeDefinitions;
        }

        @Override
        public final Builder attributeDefinitions(Collection<AttributeDefinition> attributeDefinitions) {
            this.attributeDefinitions = AttributeDefinitionsCopier.copy(attributeDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeDefinitions(AttributeDefinition ... attributeDefinitions) {
            this.attributeDefinitions(Arrays.asList(attributeDefinitions));
            return this;
        }

        public final void setAttributeDefinitions(Collection<AttributeDefinition> attributeDefinitions) {
            this.attributeDefinitions = AttributeDefinitionsCopier.copy(attributeDefinitions);
        }

        @SafeVarargs
        public final void setAttributeDefinitions(AttributeDefinition ... attributeDefinitions) {
            this.attributeDefinitions(Arrays.asList(attributeDefinitions));
        }

        public final String getTableName() {
            return this.tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final Collection<KeySchemaElement> getKeySchema() {
            return this.keySchema;
        }

        @Override
        public final Builder keySchema(Collection<KeySchemaElement> keySchema) {
            this.keySchema = KeySchemaCopier.copy(keySchema);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keySchema(KeySchemaElement ... keySchema) {
            this.keySchema(Arrays.asList(keySchema));
            return this;
        }

        public final void setKeySchema(Collection<KeySchemaElement> keySchema) {
            this.keySchema = KeySchemaCopier.copy(keySchema);
        }

        @SafeVarargs
        public final void setKeySchema(KeySchemaElement ... keySchema) {
            this.keySchema(Arrays.asList(keySchema));
        }

        public final String getTableStatus() {
            return this.tableStatus;
        }

        @Override
        public final Builder tableStatus(String tableStatus) {
            this.tableStatus = tableStatus;
            return this;
        }

        @Override
        public final Builder tableStatus(TableStatus tableStatus) {
            this.tableStatus(tableStatus.toString());
            return this;
        }

        public final void setTableStatus(String tableStatus) {
            this.tableStatus = tableStatus;
        }

        public final void setTableStatus(TableStatus tableStatus) {
            this.tableStatus(tableStatus.toString());
        }

        public final Instant getCreationDateTime() {
            return this.creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        public final ProvisionedThroughputDescription getProvisionedThroughput() {
            return this.provisionedThroughput;
        }

        @Override
        public final Builder provisionedThroughput(ProvisionedThroughputDescription provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput;
            return this;
        }

        public final void setProvisionedThroughput(ProvisionedThroughputDescription provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput;
        }

        public final Long getTableSizeBytes() {
            return this.tableSizeBytes;
        }

        @Override
        public final Builder tableSizeBytes(Long tableSizeBytes) {
            this.tableSizeBytes = tableSizeBytes;
            return this;
        }

        public final void setTableSizeBytes(Long tableSizeBytes) {
            this.tableSizeBytes = tableSizeBytes;
        }

        public final Long getItemCount() {
            return this.itemCount;
        }

        @Override
        public final Builder itemCount(Long itemCount) {
            this.itemCount = itemCount;
            return this;
        }

        public final void setItemCount(Long itemCount) {
            this.itemCount = itemCount;
        }

        public final String getTableArn() {
            return this.tableArn;
        }

        @Override
        public final Builder tableArn(String tableArn) {
            this.tableArn = tableArn;
            return this;
        }

        public final void setTableArn(String tableArn) {
            this.tableArn = tableArn;
        }

        public final Collection<LocalSecondaryIndexDescription> getLocalSecondaryIndexes() {
            return this.localSecondaryIndexes;
        }

        @Override
        public final Builder localSecondaryIndexes(Collection<LocalSecondaryIndexDescription> localSecondaryIndexes) {
            this.localSecondaryIndexes = LocalSecondaryIndexDescriptionListCopier.copy(localSecondaryIndexes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localSecondaryIndexes(LocalSecondaryIndexDescription ... localSecondaryIndexes) {
            this.localSecondaryIndexes(Arrays.asList(localSecondaryIndexes));
            return this;
        }

        public final void setLocalSecondaryIndexes(Collection<LocalSecondaryIndexDescription> localSecondaryIndexes) {
            this.localSecondaryIndexes = LocalSecondaryIndexDescriptionListCopier.copy(localSecondaryIndexes);
        }

        @SafeVarargs
        public final void setLocalSecondaryIndexes(LocalSecondaryIndexDescription ... localSecondaryIndexes) {
            this.localSecondaryIndexes(Arrays.asList(localSecondaryIndexes));
        }

        public final Collection<GlobalSecondaryIndexDescription> getGlobalSecondaryIndexes() {
            return this.globalSecondaryIndexes;
        }

        @Override
        public final Builder globalSecondaryIndexes(Collection<GlobalSecondaryIndexDescription> globalSecondaryIndexes) {
            this.globalSecondaryIndexes = GlobalSecondaryIndexDescriptionListCopier.copy(globalSecondaryIndexes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalSecondaryIndexes(GlobalSecondaryIndexDescription ... globalSecondaryIndexes) {
            this.globalSecondaryIndexes(Arrays.asList(globalSecondaryIndexes));
            return this;
        }

        public final void setGlobalSecondaryIndexes(Collection<GlobalSecondaryIndexDescription> globalSecondaryIndexes) {
            this.globalSecondaryIndexes = GlobalSecondaryIndexDescriptionListCopier.copy(globalSecondaryIndexes);
        }

        @SafeVarargs
        public final void setGlobalSecondaryIndexes(GlobalSecondaryIndexDescription ... globalSecondaryIndexes) {
            this.globalSecondaryIndexes(Arrays.asList(globalSecondaryIndexes));
        }

        public final StreamSpecification getStreamSpecification() {
            return this.streamSpecification;
        }

        @Override
        public final Builder streamSpecification(StreamSpecification streamSpecification) {
            this.streamSpecification = streamSpecification;
            return this;
        }

        public final void setStreamSpecification(StreamSpecification streamSpecification) {
            this.streamSpecification = streamSpecification;
        }

        public final String getLatestStreamLabel() {
            return this.latestStreamLabel;
        }

        @Override
        public final Builder latestStreamLabel(String latestStreamLabel) {
            this.latestStreamLabel = latestStreamLabel;
            return this;
        }

        public final void setLatestStreamLabel(String latestStreamLabel) {
            this.latestStreamLabel = latestStreamLabel;
        }

        public final String getLatestStreamArn() {
            return this.latestStreamArn;
        }

        @Override
        public final Builder latestStreamArn(String latestStreamArn) {
            this.latestStreamArn = latestStreamArn;
            return this;
        }

        public final void setLatestStreamArn(String latestStreamArn) {
            this.latestStreamArn = latestStreamArn;
        }

        public TableDescription build() {
            return new TableDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TableDescription> {
        public Builder attributeDefinitions(Collection<AttributeDefinition> var1);

        public Builder attributeDefinitions(AttributeDefinition ... var1);

        public Builder tableName(String var1);

        public Builder keySchema(Collection<KeySchemaElement> var1);

        public Builder keySchema(KeySchemaElement ... var1);

        public Builder tableStatus(String var1);

        public Builder tableStatus(TableStatus var1);

        public Builder creationDateTime(Instant var1);

        public Builder provisionedThroughput(ProvisionedThroughputDescription var1);

        public Builder tableSizeBytes(Long var1);

        public Builder itemCount(Long var1);

        public Builder tableArn(String var1);

        public Builder localSecondaryIndexes(Collection<LocalSecondaryIndexDescription> var1);

        public Builder localSecondaryIndexes(LocalSecondaryIndexDescription ... var1);

        public Builder globalSecondaryIndexes(Collection<GlobalSecondaryIndexDescription> var1);

        public Builder globalSecondaryIndexes(GlobalSecondaryIndexDescription ... var1);

        public Builder streamSpecification(StreamSpecification var1);

        public Builder latestStreamLabel(String var1);

        public Builder latestStreamArn(String var1);
    }
}

