/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.transform.ProvisionedThroughputMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ProvisionedThroughput
implements StructuredPojo,
ToCopyableBuilder<Builder, ProvisionedThroughput> {
    private final Long readCapacityUnits;
    private final Long writeCapacityUnits;

    private ProvisionedThroughput(BuilderImpl builder) {
        this.readCapacityUnits = builder.readCapacityUnits;
        this.writeCapacityUnits = builder.writeCapacityUnits;
    }

    public Long readCapacityUnits() {
        return this.readCapacityUnits;
    }

    public Long writeCapacityUnits() {
        return this.writeCapacityUnits;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.readCapacityUnits() == null ? 0 : this.readCapacityUnits().hashCode());
        hashCode = 31 * hashCode + (this.writeCapacityUnits() == null ? 0 : this.writeCapacityUnits().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisionedThroughput)) {
            return false;
        }
        ProvisionedThroughput other = (ProvisionedThroughput)obj;
        if (other.readCapacityUnits() == null ^ this.readCapacityUnits() == null) {
            return false;
        }
        if (other.readCapacityUnits() != null && !other.readCapacityUnits().equals(this.readCapacityUnits())) {
            return false;
        }
        if (other.writeCapacityUnits() == null ^ this.writeCapacityUnits() == null) {
            return false;
        }
        return other.writeCapacityUnits() == null || other.writeCapacityUnits().equals(this.writeCapacityUnits());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.readCapacityUnits() != null) {
            sb.append("ReadCapacityUnits: ").append(this.readCapacityUnits()).append(",");
        }
        if (this.writeCapacityUnits() != null) {
            sb.append("WriteCapacityUnits: ").append(this.writeCapacityUnits()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProvisionedThroughputMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Long readCapacityUnits;
        private Long writeCapacityUnits;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisionedThroughput model) {
            this.setReadCapacityUnits(model.readCapacityUnits);
            this.setWriteCapacityUnits(model.writeCapacityUnits);
        }

        public final Long getReadCapacityUnits() {
            return this.readCapacityUnits;
        }

        @Override
        public final Builder readCapacityUnits(Long readCapacityUnits) {
            this.readCapacityUnits = readCapacityUnits;
            return this;
        }

        public final void setReadCapacityUnits(Long readCapacityUnits) {
            this.readCapacityUnits = readCapacityUnits;
        }

        public final Long getWriteCapacityUnits() {
            return this.writeCapacityUnits;
        }

        @Override
        public final Builder writeCapacityUnits(Long writeCapacityUnits) {
            this.writeCapacityUnits = writeCapacityUnits;
            return this;
        }

        public final void setWriteCapacityUnits(Long writeCapacityUnits) {
            this.writeCapacityUnits = writeCapacityUnits;
        }

        public ProvisionedThroughput build() {
            return new ProvisionedThroughput(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ProvisionedThroughput> {
        public Builder readCapacityUnits(Long var1);

        public Builder writeCapacityUnits(Long var1);
    }
}

