/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ItemCollectionKeyAttributeMapCopier;
import software.amazon.awssdk.services.dynamodb.model.ItemCollectionSizeEstimateRangeCopier;
import software.amazon.awssdk.services.dynamodb.transform.ItemCollectionMetricsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ItemCollectionMetrics
implements StructuredPojo,
ToCopyableBuilder<Builder, ItemCollectionMetrics> {
    private final Map<String, AttributeValue> itemCollectionKey;
    private final List<Double> sizeEstimateRangeGB;

    private ItemCollectionMetrics(BuilderImpl builder) {
        this.itemCollectionKey = builder.itemCollectionKey;
        this.sizeEstimateRangeGB = builder.sizeEstimateRangeGB;
    }

    public Map<String, AttributeValue> itemCollectionKey() {
        return this.itemCollectionKey;
    }

    public List<Double> sizeEstimateRangeGB() {
        return this.sizeEstimateRangeGB;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.itemCollectionKey() == null ? 0 : this.itemCollectionKey().hashCode());
        hashCode = 31 * hashCode + (this.sizeEstimateRangeGB() == null ? 0 : this.sizeEstimateRangeGB().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ItemCollectionMetrics)) {
            return false;
        }
        ItemCollectionMetrics other = (ItemCollectionMetrics)obj;
        if (other.itemCollectionKey() == null ^ this.itemCollectionKey() == null) {
            return false;
        }
        if (other.itemCollectionKey() != null && !other.itemCollectionKey().equals(this.itemCollectionKey())) {
            return false;
        }
        if (other.sizeEstimateRangeGB() == null ^ this.sizeEstimateRangeGB() == null) {
            return false;
        }
        return other.sizeEstimateRangeGB() == null || other.sizeEstimateRangeGB().equals(this.sizeEstimateRangeGB());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.itemCollectionKey() != null) {
            sb.append("ItemCollectionKey: ").append(this.itemCollectionKey()).append(",");
        }
        if (this.sizeEstimateRangeGB() != null) {
            sb.append("SizeEstimateRangeGB: ").append(this.sizeEstimateRangeGB()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ItemCollectionMetricsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Map<String, AttributeValue> itemCollectionKey;
        private List<Double> sizeEstimateRangeGB;

        private BuilderImpl() {
        }

        private BuilderImpl(ItemCollectionMetrics model) {
            this.setItemCollectionKey(model.itemCollectionKey);
            this.setSizeEstimateRangeGB(model.sizeEstimateRangeGB);
        }

        public final Map<String, AttributeValue> getItemCollectionKey() {
            return this.itemCollectionKey;
        }

        @Override
        public final Builder itemCollectionKey(Map<String, AttributeValue> itemCollectionKey) {
            this.itemCollectionKey = ItemCollectionKeyAttributeMapCopier.copy(itemCollectionKey);
            return this;
        }

        public final void setItemCollectionKey(Map<String, AttributeValue> itemCollectionKey) {
            this.itemCollectionKey = ItemCollectionKeyAttributeMapCopier.copy(itemCollectionKey);
        }

        public final Collection<Double> getSizeEstimateRangeGB() {
            return this.sizeEstimateRangeGB;
        }

        @Override
        public final Builder sizeEstimateRangeGB(Collection<Double> sizeEstimateRangeGB) {
            this.sizeEstimateRangeGB = ItemCollectionSizeEstimateRangeCopier.copy(sizeEstimateRangeGB);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sizeEstimateRangeGB(Double ... sizeEstimateRangeGB) {
            this.sizeEstimateRangeGB(Arrays.asList(sizeEstimateRangeGB));
            return this;
        }

        public final void setSizeEstimateRangeGB(Collection<Double> sizeEstimateRangeGB) {
            this.sizeEstimateRangeGB = ItemCollectionSizeEstimateRangeCopier.copy(sizeEstimateRangeGB);
        }

        @SafeVarargs
        public final void setSizeEstimateRangeGB(Double ... sizeEstimateRangeGB) {
            this.sizeEstimateRangeGB(Arrays.asList(sizeEstimateRangeGB));
        }

        public ItemCollectionMetrics build() {
            return new ItemCollectionMetrics(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ItemCollectionMetrics> {
        public Builder itemCollectionKey(Map<String, AttributeValue> var1);

        public Builder sizeEstimateRangeGB(Collection<Double> var1);

        public Builder sizeEstimateRangeGB(Double ... var1);
    }
}

