/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeStreamRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeStreamRequest> {
    private final String streamArn;
    private final Integer limit;
    private final String exclusiveStartShardId;

    private DescribeStreamRequest(BuilderImpl builder) {
        this.streamArn = builder.streamArn;
        this.limit = builder.limit;
        this.exclusiveStartShardId = builder.exclusiveStartShardId;
    }

    public String streamArn() {
        return this.streamArn;
    }

    public Integer limit() {
        return this.limit;
    }

    public String exclusiveStartShardId() {
        return this.exclusiveStartShardId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.streamArn() == null ? 0 : this.streamArn().hashCode());
        hashCode = 31 * hashCode + (this.limit() == null ? 0 : this.limit().hashCode());
        hashCode = 31 * hashCode + (this.exclusiveStartShardId() == null ? 0 : this.exclusiveStartShardId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStreamRequest)) {
            return false;
        }
        DescribeStreamRequest other = (DescribeStreamRequest)((Object)obj);
        if (other.streamArn() == null ^ this.streamArn() == null) {
            return false;
        }
        if (other.streamArn() != null && !other.streamArn().equals(this.streamArn())) {
            return false;
        }
        if (other.limit() == null ^ this.limit() == null) {
            return false;
        }
        if (other.limit() != null && !other.limit().equals(this.limit())) {
            return false;
        }
        if (other.exclusiveStartShardId() == null ^ this.exclusiveStartShardId() == null) {
            return false;
        }
        return other.exclusiveStartShardId() == null || other.exclusiveStartShardId().equals(this.exclusiveStartShardId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.streamArn() != null) {
            sb.append("StreamArn: ").append(this.streamArn()).append(",");
        }
        if (this.limit() != null) {
            sb.append("Limit: ").append(this.limit()).append(",");
        }
        if (this.exclusiveStartShardId() != null) {
            sb.append("ExclusiveStartShardId: ").append(this.exclusiveStartShardId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String streamArn;
        private Integer limit;
        private String exclusiveStartShardId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStreamRequest model) {
            this.setStreamArn(model.streamArn);
            this.setLimit(model.limit);
            this.setExclusiveStartShardId(model.exclusiveStartShardId);
        }

        public final String getStreamArn() {
            return this.streamArn;
        }

        @Override
        public final Builder streamArn(String streamArn) {
            this.streamArn = streamArn;
            return this;
        }

        public final void setStreamArn(String streamArn) {
            this.streamArn = streamArn;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getExclusiveStartShardId() {
            return this.exclusiveStartShardId;
        }

        @Override
        public final Builder exclusiveStartShardId(String exclusiveStartShardId) {
            this.exclusiveStartShardId = exclusiveStartShardId;
            return this;
        }

        public final void setExclusiveStartShardId(String exclusiveStartShardId) {
            this.exclusiveStartShardId = exclusiveStartShardId;
        }

        public DescribeStreamRequest build() {
            return new DescribeStreamRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeStreamRequest> {
        public Builder streamArn(String var1);

        public Builder limit(Integer var1);

        public Builder exclusiveStartShardId(String var1);
    }
}

