/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.datamodeling.unmarshallers;

import java.nio.ByteBuffer;
import software.amazon.awssdk.services.dynamodb.datamodeling.unmarshallers.BUnmarshaller;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

public class ByteArrayUnmarshaller
extends BUnmarshaller {
    private static final ByteArrayUnmarshaller INSTANCE = new ByteArrayUnmarshaller();

    private ByteArrayUnmarshaller() {
    }

    public static ByteArrayUnmarshaller instance() {
        return INSTANCE;
    }

    @Override
    public Object unmarshall(AttributeValue value) {
        ByteBuffer buffer = value.b();
        if (buffer.hasArray()) {
            return buffer.array();
        }
        byte[] array = new byte[buffer.remaining()];
        buffer.get(array);
        return array;
    }
}

