/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.datamodeling.marshallers;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import software.amazon.awssdk.services.dynamodb.datamodeling.ArgumentMarshaller;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.util.DateUtils;

public class CalendarSetToStringSetMarshaller
implements ArgumentMarshaller.StringSetAttributeMarshaller {
    private static final CalendarSetToStringSetMarshaller INSTANCE = new CalendarSetToStringSetMarshaller();

    private CalendarSetToStringSetMarshaller() {
    }

    public static CalendarSetToStringSetMarshaller instance() {
        return INSTANCE;
    }

    @Override
    public AttributeValue marshall(Object obj) {
        Set dates = (Set)obj;
        ArrayList<String> timestamps = new ArrayList<String>(dates.size());
        for (Calendar date : dates) {
            timestamps.add(DateUtils.formatIso8601Date((Date)date.getTime()));
        }
        return (AttributeValue)AttributeValue.builder().ss(timestamps).build();
    }
}

