/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.datamodeling;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.math.BigInteger;
import java.util.Arrays;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDb;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbAutoGenerateStrategy;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbAutoGenerated;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbAutoGenerator;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbMappingException;
import software.amazon.awssdk.services.dynamodb.datamodeling.StandardTypeConverters;

@DynamoDb
@DynamoDbAutoGenerated(generator=Generator.class)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.ANNOTATION_TYPE})
public @interface DynamoDbVersioned {

    public static final class Generator<T>
    extends DynamoDbAutoGenerator.AbstractGenerator<T> {
        private final Sequence<T> sequence;

        Generator(Class<T> targetType, DynamoDbVersioned annotation) {
            super(DynamoDbAutoGenerateStrategy.ALWAYS);
            this.sequence = Sequences.of(targetType);
        }

        @Override
        public T generate(T currentValue) {
            return currentValue == null ? this.sequence.init() : this.sequence.next(currentValue);
        }

        static interface Sequence<T> {
            public T init();

            public T next(T var1);
        }

        private static enum Sequences {
            BIG_INTEGER(StandardTypeConverters.Scalar.BIG_INTEGER, new Sequence<BigInteger>(){

                @Override
                public BigInteger init() {
                    return BigInteger.ONE;
                }

                @Override
                public BigInteger next(BigInteger o) {
                    return o.add(BigInteger.ONE);
                }
            }),
            BYTE(StandardTypeConverters.Scalar.BYTE, new Sequence<Byte>(){

                @Override
                public Byte init() {
                    return (byte)1;
                }

                @Override
                public Byte next(Byte o) {
                    return (byte)((o + 1) % 127);
                }
            }),
            INTEGER(StandardTypeConverters.Scalar.INTEGER, new Sequence<Integer>(){

                @Override
                public Integer init() {
                    return 1;
                }

                @Override
                public Integer next(Integer o) {
                    return o + 1;
                }
            }),
            LONG(StandardTypeConverters.Scalar.LONG, new Sequence<Long>(){

                @Override
                public Long init() {
                    return 1L;
                }

                @Override
                public Long next(Long o) {
                    return o + 1L;
                }
            }),
            SHORT(StandardTypeConverters.Scalar.SHORT, new Sequence<Short>(){

                @Override
                public Short init() {
                    return (short)1;
                }

                @Override
                public Short next(Short o) {
                    return (short)(o + 1);
                }
            });

            private final Sequence<?> sequence;
            private final StandardTypeConverters.Scalar scalar;

            private Sequences(StandardTypeConverters.Scalar scalar, Sequence<?> sequence) {
                this.sequence = sequence;
                this.scalar = scalar;
            }

            private static <T> Sequence<T> of(Class<T> targetType) {
                for (Sequences s : Sequences.values()) {
                    if (!s.scalar.is(targetType)) continue;
                    return s.sequence;
                }
                throw new DynamoDbMappingException("type [" + targetType + "] is not supported; allowed only " + Arrays.toString((Object[])Sequences.values()));
            }
        }
    }
}

