/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dynamodb.model.TimeToLiveStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TimeToLiveDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TimeToLiveDescription> {
    private static final SdkField<String> TIME_TO_LIVE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TimeToLiveDescription.getter(TimeToLiveDescription::timeToLiveStatusAsString)).setter(TimeToLiveDescription.setter(Builder::timeToLiveStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeToLiveStatus").build()}).build();
    private static final SdkField<String> ATTRIBUTE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TimeToLiveDescription.getter(TimeToLiveDescription::attributeName)).setter(TimeToLiveDescription.setter(Builder::attributeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIME_TO_LIVE_STATUS_FIELD, ATTRIBUTE_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String timeToLiveStatus;
    private final String attributeName;

    private TimeToLiveDescription(BuilderImpl builder) {
        this.timeToLiveStatus = builder.timeToLiveStatus;
        this.attributeName = builder.attributeName;
    }

    public TimeToLiveStatus timeToLiveStatus() {
        return TimeToLiveStatus.fromValue(this.timeToLiveStatus);
    }

    public String timeToLiveStatusAsString() {
        return this.timeToLiveStatus;
    }

    public String attributeName() {
        return this.attributeName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.timeToLiveStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeToLiveDescription)) {
            return false;
        }
        TimeToLiveDescription other = (TimeToLiveDescription)obj;
        return Objects.equals(this.timeToLiveStatusAsString(), other.timeToLiveStatusAsString()) && Objects.equals(this.attributeName(), other.attributeName());
    }

    public String toString() {
        return ToString.builder((String)"TimeToLiveDescription").add("TimeToLiveStatus", (Object)this.timeToLiveStatusAsString()).add("AttributeName", (Object)this.attributeName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TimeToLiveStatus": {
                return Optional.ofNullable(clazz.cast(this.timeToLiveStatusAsString()));
            }
            case "AttributeName": {
                return Optional.ofNullable(clazz.cast(this.attributeName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TimeToLiveDescription, T> g) {
        return obj -> g.apply((TimeToLiveDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String timeToLiveStatus;
        private String attributeName;

        private BuilderImpl() {
        }

        private BuilderImpl(TimeToLiveDescription model) {
            this.timeToLiveStatus(model.timeToLiveStatus);
            this.attributeName(model.attributeName);
        }

        public final String getTimeToLiveStatus() {
            return this.timeToLiveStatus;
        }

        @Override
        public final Builder timeToLiveStatus(String timeToLiveStatus) {
            this.timeToLiveStatus = timeToLiveStatus;
            return this;
        }

        @Override
        public final Builder timeToLiveStatus(TimeToLiveStatus timeToLiveStatus) {
            this.timeToLiveStatus(timeToLiveStatus.toString());
            return this;
        }

        public final void setTimeToLiveStatus(String timeToLiveStatus) {
            this.timeToLiveStatus = timeToLiveStatus;
        }

        public final String getAttributeName() {
            return this.attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        public TimeToLiveDescription build() {
            return new TimeToLiveDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TimeToLiveDescription> {
        public Builder timeToLiveStatus(String var1);

        public Builder timeToLiveStatus(TimeToLiveStatus var1);

        public Builder attributeName(String var1);
    }
}

